/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.extensions.json;

import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.extensions.shadow.com.jayway.jsonpath.Configuration;
import com.install4j.extensions.shadow.com.jayway.jsonpath.JsonPath;
import com.install4j.extensions.shadow.com.jayway.jsonpath.JsonPathException;
import com.install4j.extensions.shadow.com.jayway.jsonpath.Predicate;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import com.install4j.runtime.installer.helper.Logger;
import java.io.File;
import java.io.IOException;

public abstract class AbstractJsonReadAction
extends SystemInstallOrUninstallAction {
    private File file;
    private String jsonPath;
    private String variableName;

    public File getFile() {
        return (File)this.replaceWithTextOverride("file", AbstractJsonReadAction.replaceVariables((File)this.file), File.class);
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getJsonPath() {
        return AbstractJsonReadAction.replaceVariables((String)AbstractJsonReadAction.replaceVariables((String)this.jsonPath));
    }

    public void setJsonPath(String jsonPath) {
        this.jsonPath = jsonPath;
    }

    public String getVariableName() {
        return AbstractJsonReadAction.replaceVariables((String)this.variableName);
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    protected abstract boolean handleResult(Object var1, Context var2);

    protected void adjustConfiguration(Configuration configuration) {
    }

    public boolean execute(Context context) throws UserCanceledException {
        Configuration configuration = Configuration.defaultConfiguration();
        this.adjustConfiguration(configuration);
        File usedFile = context.getDestinationFile(this.getFile());
        try {
            Object result = JsonPath.using(configuration).parse(usedFile).read(this.getJsonPath(), new Predicate[0]);
            return this.handleResult(result, context);
        }
        catch (JsonPathException e) {
            Logger.getInstance().log((Object)this, "JSONPath error: " + e.getMessage(), false);
            return false;
        }
        catch (IOException e) {
            Logger.getInstance().log((Object)this, "Error reading " + usedFile + ": " + e.getMessage(), false);
            return false;
        }
    }

    public boolean isRollbackSupported() {
        return false;
    }
}

