package com.install4j.api.launcher;

import com.exe4j.runtime.splash.SplashEngine;

/**
 *
 * <p>This class allows you to control the splash screen of an install4j
 * launcher from your Java code.</p>
 *
 * <p>In order to use this class, please include {@code resource/i4jruntime.jar} from your
 * install4j installation into your class path. You do not need to distribute this file
 * along with your application, install4j will do this automatically for you.
 * </p>
 * <p>
 *     To disable the splash screen from the command line on Windows, {@code -J-splash:none} can be passed to the
 *     launcher executable. Other forms of the {@code -splash} argument that work with the standard Java
 *     launcher are not supported by install4j launchers.
 * </p>
 *
 * @author ej-technologies GmbH
 *
 */
public class SplashScreen {

    /**
     * Update the status text line of the splash screen with a different message.
     * @param message the new text.
     * @throws SplashScreen.ConnectionException if there is a communication problem
     *
    */
    public static void writeMessage(String message) throws ConnectionException {
        try {
            SplashEngine.writeMessage(message);
        } catch (Exception e) {
            throw new ConnectionException(e);
        } catch (Throwable ignored) {
        }
    }

    /**
     * Programmatically hide the splash screen. By default,
     * the splash screen will disappear when the first window is shown.
     * @throws SplashScreen.ConnectionException if there is a communication problem
     */
    public static void hide() throws ConnectionException {
        try {
            SplashEngine.hide();
        } catch (Exception e) {
            throw new ConnectionException(e);
        } catch (Throwable ignored) {
        }
    }

    private SplashScreen() {
    }

    /**
     * <p>The exception thrown by methods of the {@code SplashScreen} class to
     * indicate that a splash screen operation was not successful.
     * </p>
     *
     * @author ej-technologies GmbH
     */
    public static class ConnectionException extends Exception {
        private ConnectionException(Exception e) {
            super(e.getMessage());
        }
    }


}