package com.install4j.api.beans;

/**
 * Used in {@link VariableErrorHandlingDescriptor} to configure the error handling for a single variable type.
 * @author ej-technologies GmbH
 */
public enum VariableErrorHandling {

    /**
     * Ignore an undefined variable and leave it in place
     */
    IGNORE("Ignore"),

    /**
     * Replace an undefined variable with an error message
     */
    ERROR_MESSAGE("Error message"),

    /**
     * Throw an exception if an undefined variable is found
     */
    EXCEPTION("Exception");

    private final String verbose;

    VariableErrorHandling(String verbose) {
        this.verbose = verbose;
    }

    @Override
    public String toString() {
        return verbose;
    }
}
