package com.install4j.api.beaninfo;

/**
 * A filter interface that can be used to determine whether a property should be included or not.
 * @see Install4JPropertyDescriptor#setNestedBeanPropertyFilter(PropertyFilter)
 **/
public interface PropertyFilter {
    /**
     * Decides if the property should be included.
     * @param propertyName the name of the property
     * @return if the property should be included
     */
    boolean isPropertyIncluded(String propertyName);
}
