package com.install4j.api.beaninfo;

import com.install4j.api.formcomponents.FormComponent;

/**
 * Base class for form component bean infos.
 * <p>Using this class is not strictly required. In principle, you could also set values for the {@code ATTRIBUTE_*} constants in the bean descriptor
 * of an unrelated bean info class.
 */
public class FormComponentBeanInfo extends Install4JBeanInfo {

    /**
     * @see #setDefaultVisibilityScript(String)
     */
    public static final String ATTRIBUTE_DEFAULT_VISIBILITY_SCRIPT = "defaultVisibilityScript";

    /**
     * @see #setHideVisibilityScript(boolean)
     */
    public static final String ATTRIBUTE_HIDE_VISIBILITY_SCRIPT = "hideVisibilityScript";

    /**
     * Same as {@link Install4JBeanInfo#Install4JBeanInfo(String, String, String, boolean, boolean, Integer, Class, Class)} with
     *  {@code multipleInstancesSupported} set to {@code true} and {@code installedFilesRequired} set to {@code false}.
     */
    public FormComponentBeanInfo(String displayName, String shortDescription, String category, Integer sortKey, Class<? extends FormComponent> beanClass, Class customizerClass) {
        super(displayName, shortDescription, category, true, false, sortKey, beanClass, customizerClass);
    }

    /**
     * Same as {@link Install4JBeanInfo#Install4JBeanInfo(String, String, String, boolean, boolean, Integer, Class, Class)} with
     *  {@code installedFilesRequired} set to {@code false}.
     */
    public FormComponentBeanInfo(String displayName, String shortDescription, String category, boolean multipleInstancesSupported, Integer sortKey, Class<? extends FormComponent> beanClass, Class customizerClass) {
        super(displayName, shortDescription, category, multipleInstancesSupported, false, sortKey, beanClass, customizerClass);
    }

    /**
     * Same as {@link #FormComponentBeanInfo(String, String, String, Integer, Class, Class)} with a customizer class of {@code null}.
     */
    public FormComponentBeanInfo(String displayName, String shortDescription, String category, Integer sortKey, Class<? extends FormComponent> beanClass) {
        super(displayName, shortDescription, category, true, false, sortKey, beanClass);
    }

    /**
     * Configures the default value for the "Visibility script" property of the form component.
     * @param defaultVisibilityScript the default value
     * @see #ATTRIBUTE_DEFAULT_VISIBILITY_SCRIPT
     */
    public void setDefaultVisibilityScript(String defaultVisibilityScript) {
        getBeanDescriptor().setValue(ATTRIBUTE_DEFAULT_VISIBILITY_SCRIPT, defaultVisibilityScript);
    }

    /**
     * Configures if the visibility script should be hidden in the install4j IDE.
     * This is useful for form components that manage visibility on their own.
     * @param hideVisibilityScript if the visibility script should be hidden
     * @see #ATTRIBUTE_HIDE_VISIBILITY_SCRIPT
     */
    public void setHideVisibilityScript(boolean hideVisibilityScript) {
        getBeanDescriptor().setValue(ATTRIBUTE_HIDE_VISIBILITY_SCRIPT, hideVisibilityScript);
    }

}
