package com.install4j.api.beaninfo;

import com.install4j.api.beans.Bean;

/**
 * Interface for the {@link Install4JBeanInfo#ATTRIBUTE_BEAN_INITIALIZER} value of a bean descriptor.
 * With a bean initializer you can modify beans after they are instantiated.
 * <p>This is useful if you have default property values that include compiler variables. Compiler variables in bean properties
 * are replaced directly in the XML representation of a bean. However, the JavaBean serialization mechanism
 * does not save default values for properties, so compiler variables in default values are not replaced at compile time.
 * If you set the default value from a bean initializer, the JavaBean serialization mechanism will recognize this
 * value as non-default and save it explicitly.
 */
public interface BeanInitializer {
    /**
     * Called after the unconfigured bean is instantiated the first time at design-time.
     * For existing bean instances that are loaded from a project, this method is not called
     * after instantiation.
     * @param bean the bean that should be initialized
     */
    void initializeBean(Bean bean);
}
