package com.install4j.jdk.spi;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;

/**
 * Category node for the tree of JDK releases. This node can have child nodes but is not selectable as a release itself.
 */
public interface JdkCategoryNode extends JdkNode {
    /**
     * Returns the child nodes which can be category nodes again or instances of {@link JdkReleaseNode}.
     */
    @NotNull
    Collection<? extends JdkNode> getChildren();

    /**
     * Returns a key for this category.
     * The config key is saved in the install4j project file and
     * passed to {@link JdkProvider#getLatestByCategoryKey(String, Collection)} to find a matching release node
     * when the JDK is downloaded.
     * <p>
     * The config key must either be the Java major version number or start with the major version number followed by a
     * followed by other characters, for example {@code 11} or {@code 11 FX}.
     * </p>
     * <p>
     * Can return null if no latest release can be provided for this category.
     * </p>
     */
    @Nullable
    String getCategoryKey();
}
