<?xml version="1.0" encoding="ISO-8859-1"?>
<!-- install4j 10.0 -->
<xsl:transform version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns=""
               xmlns:math="http://exslt.org/math"
               xmlns:ext="com.install4j.config.XsltExtensions"
               extension-element-prefixes="ext math">

  <xsl:include href="common.xsl"/>

  <xsl:template match="//action[@beanClass='com.install4j.runtime.beans.actions.desktop.CreateFileAssociationAction']/serializedBean/property[
      @name='macIconFile' or
      @name='mac' or
      @name='macRole' or
      @name='restartFinder'
    ]"/>

  <xsl:template match="//action[@beanClass='com.install4j.runtime.beans.actions.desktop.UrlHandlerAction']/serializedBean/property[
      @name='macRole'
    ]"/>

  <xsl:template match="/install4j/launchers/launcher[not(@external) or @external != 'true']">
    <xsl:copy>
      <xsl:copy-of select="@*"/>
      <xsl:variable name="launcherId" select="@id"/>
      <xsl:variable name="selectedActions" select="macStaticAssociationActions[@mode = 'selected']"/>

      <macStaticAssociations>
        <xsl:for-each select="//action[
            @beanClass='com.install4j.runtime.beans.actions.desktop.CreateFileAssociationAction' and
            serializedBean/property[@name = 'launcherId'] = $launcherId and
            (not(serializedBean/property[@name = 'mac']) or serializedBean/property[@name = 'mac']/@value != 'false') and
            (not($selectedActions) or $selectedActions/id/text() = @id)
          ]/serializedBean">
          <fileAssociation extension="{property[@name = 'extension']}" description="{property[@name = 'description']}">
            <xsl:if test="property[@name = 'macRole']">
              <xsl:attribute name="role">
                <xsl:value-of select="translate(property[@name = 'macRole']/@value, 'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz')"/>
              </xsl:attribute>
            </xsl:if>
            <xsl:if test="property[@name = 'macIconFile']">
              <xsl:attribute name="iconFile">
                <xsl:value-of select="property[@name = 'macIconFile']/object/string"/>
              </xsl:attribute>
            </xsl:if>
          </fileAssociation>
        </xsl:for-each>

        <xsl:for-each select="//action[
            @beanClass='com.install4j.runtime.beans.actions.desktop.UrlHandlerAction' and
            serializedBean/property[@name = 'launcherId'] = $launcherId and
            (not($selectedActions) or $selectedActions/id/text() = @id)
          ]/serializedBean">
          <urlHandler scheme="{property[@name = 'scheme']}">
            <xsl:if test="property[@name = 'macRole']">
              <xsl:attribute name="role">
                <xsl:value-of select="translate(property[@name = 'macRole']/@value, 'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz')"/>
              </xsl:attribute>
            </xsl:if>
          </urlHandler>
        </xsl:for-each>
      </macStaticAssociations>

      <xsl:apply-templates/>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="/install4j/mediaSets/windows[@msi='true' and not(@msiScope)]">
    <xsl:copy>
      <xsl:copy-of select="@*"/>
      <xsl:attribute name="msiScope">selectable</xsl:attribute>
      <xsl:apply-templates/>
    </xsl:copy>
  </xsl:template>

</xsl:transform>
