/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.customizers.installationtype;

import com.ejt.internal.gui.bg;
import com.ejt.internal.gui.ev;
import com.ejt.internal.gui.w.i;
import com.install4j.b;
import com.install4j.runtime.beans.customizers.installationtype.ComponentsTab;
import com.install4j.runtime.beans.customizers.installationtype.DescriptionTab;
import com.install4j.runtime.beans.customizers.installationtype.InstallationTypeCustomizer;
import com.install4j.runtime.beans.screens.installationtype.InstallationTypeConfig;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;

public class InstallationTypeDialog
extends ev {
    private static final int FRAME_WIDTH = 500;
    private static final int FRAME_HEIGHT = 500;
    public static final String NAME_TEXT_FIELD_NAME = "nameTextField";
    private InstallationTypeConfig config;
    private InstallationTypeCustomizer customizer;
    private JTextField txtName;
    private JCheckBox chkCustomId;
    private JTextField txtCustomId;
    private JTabbedPane tabbedPane;
    private ComponentsTab componentsTab;
    private DescriptionTab descriptionTab;

    public InstallationTypeDialog(InstallationTypeCustomizer installationTypeCustomizer) {
        super((Window)installationTypeCustomizer.getFrame());
        this.customizer = installationTypeCustomizer;
        this.initDialog();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.chkCustomId) {
            this.checkEnabled();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public InstallationTypeCustomizer getCustomizer() {
        return this.customizer;
    }

    public InstallationTypeConfig getConfig() {
        return this.config;
    }

    public void setConfig(InstallationTypeConfig installationTypeConfig) {
        this.config = installationTypeConfig;
        this.txtName.setText(installationTypeConfig.getName());
        this.chkCustomId.setSelected(!installationTypeConfig.getCustomizedId().isEmpty());
        this.txtCustomId.setText(installationTypeConfig.getCustomizedId());
        this.componentsTab.initConfig();
        this.descriptionTab.initConfig();
        this.checkEnabled();
    }

    @Override
    protected String getTitleText() {
        return "Configure Installation Type";
    }

    @Override
    protected void setupControls() {
        super.setupControls();
        this.txtName = new i();
        this.txtName.setName(NAME_TEXT_FIELD_NAME);
        this.chkCustomId = new JCheckBox("Custom ID:");
        this.txtCustomId = new i();
        this.tabbedPane = new bg();
        this.componentsTab = new ComponentsTab(this);
        this.descriptionTab = new DescriptionTab(this);
    }

    @Override
    protected void setupEventHandlers() {
        super.setupEventHandlers();
        this.chkCustomId.addActionListener(this);
    }

    @Override
    protected JComponent createCenterPanel() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("insets 0", "[][grow]", "[][]unrel[grow]"));
        jPanel.add(new JLabel("Name:"));
        jPanel.add((Component)this.getCustomizer().getFrame().a(this.txtName), "growx, wrap");
        jPanel.add(this.chkCustomId);
        jPanel.add((Component)this.txtCustomId, "growx, wrap");
        this.tabbedPane.addTab("Components", this.componentsTab);
        this.tabbedPane.addTab("Description", this.descriptionTab);
        jPanel.add((Component)this.tabbedPane, "spanx, grow");
        return jPanel;
    }

    @Override
    protected int getFrameWidth() {
        return 500;
    }

    @Override
    protected int getFrameHeight() {
        return 500;
    }

    @Override
    protected void doOk() {
        String string = this.txtName.getText().trim();
        String string2 = this.txtCustomId.getText().trim();
        if (string.isEmpty()) {
            b.a(this, "The name must not be empty.", null, 2);
            this.txtName.requestFocus();
            return;
        }
        if (!this.customizer.isNameUnique(string, this.config)) {
            b.a(this, "This name already exists.", null, 2);
            this.txtName.requestFocus();
            return;
        }
        if (this.chkCustomId.isSelected()) {
            if (string2.isEmpty()) {
                b.a(this, "The ID must not be empty.", null, 2);
                this.txtCustomId.requestFocus();
                return;
            }
            if (!this.customizer.isIdUnique(string2, this.config)) {
                b.a(this, "This ID already exists.", null, 2);
                this.txtCustomId.requestFocus();
                return;
            }
        }
        if (this.componentsTab.synchronizeConfig() | this.descriptionTab.synchronizeConfig() | !this.config.getName().equals(string)) {
            this.customizer.modified();
        }
        this.config.setName(string);
        this.config.setCustomizedId(this.chkCustomId.isSelected() ? string2 : "");
        super.doOk();
    }

    private void checkEnabled() {
        this.txtCustomId.setEnabled(this.chkCustomId.isSelected());
    }
}

