/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.api.beaninfo;

import com.install4j.api.beaninfo.BeanInitializer;
import com.install4j.api.beaninfo.BeanValidationException;
import com.install4j.api.beaninfo.BeanValidator;
import com.install4j.api.beaninfo.CustomizerPlacement;
import com.install4j.api.beaninfo.EnumerationMapper;
import com.install4j.api.beaninfo.Install4JPropertyDescriptor;
import com.install4j.api.beaninfo.PropertyConverter;
import com.install4j.api.beaninfo.SequenceValidator;
import com.install4j.api.beans.Bean;
import com.install4j.api.beans.LocalizedExternalFile;
import com.install4j.api.beans.ScriptProperty;
import java.beans.BeanDescriptor;
import java.beans.PersistenceDelegate;
import java.beans.PropertyDescriptor;
import java.beans.SimpleBeanInfo;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;

public abstract class Install4JBeanInfo
extends SimpleBeanInfo {
    public static final String ATTRIBUTE_MINIMUM_JAVA_VERSION = "minimumJavaVersion";
    public static final String ATTRIBUTE_MULTIPLE_INSTANCES_SUPPORTED = "multipleInstancesSupported";
    public static final String ATTRIBUTE_INSTALLED_FILES_REQUIRED = "installedFilesRequired";
    public static final String ATTRIBUTE_BEAN_CATEGORY = "beanCategory";
    public static final String ATTRIBUTE_COLLAPSED_PROPERTY_CATEGORIES = "collapsedPropertyCategories";
    public static final String ATTRIBUTE_ENUMERATION_MAPPERS = "enumerationMapper";
    public static final String ATTRIBUTE_PROPERTY_CONVERTERS = "propertyConverters";
    public static final String ATTRIBUTE_PERSISTENCE_DELEGATE_MAP = "persistenceDelegateMap";
    public static final String ATTRIBUTE_CUSTOMIZER_PLACEMENT = "customizerPlacement";
    public static final String ATTRIBUTE_CUSTOMIZER_ICON = "customizerIcon";
    public static final String ATTRIBUTE_BEAN_VALIDATOR = "beanValidator";
    public static final String ATTRIBUTE_BEAN_INITIALIZER = "beanInitializer";
    public static final String ATTRIBUTE_SORT_KEY = "sortKey";
    public static final String ATTRIBUTE_SEQUENCE_VALIDATOR = "sequenceValidator";
    public static final String ATTRIBUTE_DEFAULT_ROLLBACK_BARRIER = "defaultRollbackBarrier";
    public static final String ATTRIBUTE_DEFAULT_ROLLBACK_BARRIER_EXIT_CODE = "defaultRollbackBarrierExitCode";
    public static final String ATTRIBUTE_DEFAULT_CONDITION_EXPRESSION = "defaultConditionExpression";
    public static final String ATTRIBUTE_ICON_16x16 = "icon16x16";
    public static final String ATTRIBUTE_ICON_24x24 = "icon24x24";
    public static final String ATTRIBUTE_NOTICE_PANEL = "noticePanel";
    public static final String ATTRIBUTE_CATEGORY_SORT_ORDER = "categorySortOrder";
    public static final String ATTRIBUTE_CATEGORY_SORT_ORDER_OTHER_AT_BOTTOM = "categorySortOrderOtherAtBottom";
    private List<Install4JPropertyDescriptor> propertyDescriptors = new ArrayList<Install4JPropertyDescriptor>();
    private BeanDescriptor beanDescriptor;
    private int nextPropertySortKeyValue = 0;

    protected Install4JBeanInfo(String displayName, String shortDescription, String category, boolean multipleInstancesSupported, boolean installedFilesRequired, Integer sortKey, Class<? extends Bean> beanClass, Class<?> customizerClass) {
        this.initBeanDescriptor(beanClass, customizerClass);
        this.setDisplayName(displayName);
        this.setShortDescription(shortDescription);
        this.setBeanCategory(category);
        this.setMultipleInstancesSupported(multipleInstancesSupported);
        this.setInstalledFilesRequired(installedFilesRequired);
        this.setSortKey(sortKey);
        if (this instanceof BeanValidator) {
            this.setBeanValidator((BeanValidator)((Object)this));
        }
        if (this instanceof BeanInitializer) {
            this.setBeanInitializer((BeanInitializer)((Object)this));
        }
        if (this instanceof SequenceValidator) {
            this.setSequenceValidator((SequenceValidator)((Object)this));
        }
    }

    protected Install4JBeanInfo(String displayName, String shortDescription, String category, boolean multipleInstancesSupported, boolean installedFilesRequired, Integer sortKey, Class<? extends Bean> beanClass) {
        this(displayName, shortDescription, category, multipleInstancesSupported, installedFilesRequired, sortKey, beanClass, null);
    }

    public void addPropertyDescriptor(Install4JPropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor.getValue(ATTRIBUTE_SORT_KEY) == null) {
            this.nextPropertySortKeyValue += 100;
            propertyDescriptor.setSortKey(this.nextPropertySortKeyValue);
        }
        this.propertyDescriptors.add(propertyDescriptor);
    }

    @Override
    public PropertyDescriptor[] getPropertyDescriptors() {
        return this.propertyDescriptors.toArray(new PropertyDescriptor[0]);
    }

    @Override
    public BeanDescriptor getBeanDescriptor() {
        return this.beanDescriptor;
    }

    public void setIcons(Icon icon16x16, Icon icon24x24) {
        BeanDescriptor beanDescriptor = this.getBeanDescriptor();
        if (icon16x16 != null) {
            beanDescriptor.setValue(ATTRIBUTE_ICON_16x16, icon16x16);
        }
        if (icon24x24 != null) {
            beanDescriptor.setValue(ATTRIBUTE_ICON_24x24, icon24x24);
        }
    }

    public void setMinimumJavaVersion(String minimumJavaVersion) {
        if (minimumJavaVersion != null) {
            this.getBeanDescriptor().setValue(ATTRIBUTE_MINIMUM_JAVA_VERSION, minimumJavaVersion);
        }
    }

    public void setCollapsedPropertyCategories(String[] collapsedCategories) {
        if (collapsedCategories != null) {
            this.getBeanDescriptor().setValue(ATTRIBUTE_COLLAPSED_PROPERTY_CATEGORIES, collapsedCategories);
        }
    }

    public void setEnumerationMappers(EnumerationMapper[] enumerationMappers) {
        if (enumerationMappers != null) {
            this.getBeanDescriptor().setValue(ATTRIBUTE_ENUMERATION_MAPPERS, enumerationMappers);
        }
    }

    public void setPropertyConverters(PropertyConverter[] propertyConverters) {
        if (propertyConverters != null) {
            this.getBeanDescriptor().setValue(ATTRIBUTE_PROPERTY_CONVERTERS, propertyConverters);
        }
    }

    public void setPersistenceDelegateMap(Map<? extends Class, ? extends PersistenceDelegate> persistenceDelegates) {
        if (persistenceDelegates != null) {
            this.getBeanDescriptor().setValue(ATTRIBUTE_PERSISTENCE_DELEGATE_MAP, persistenceDelegates);
        }
    }

    public void setCustomizerPlacement(CustomizerPlacement customizerPlacement) {
        if (customizerPlacement != null) {
            this.getBeanDescriptor().setValue(ATTRIBUTE_CUSTOMIZER_PLACEMENT, (Object)customizerPlacement);
        }
    }

    public void setCustomizerIcon(Icon customizerIcon) {
        if (customizerIcon != null) {
            this.getBeanDescriptor().setValue(ATTRIBUTE_CUSTOMIZER_ICON, customizerIcon);
        }
    }

    public void setBeanValidator(BeanValidator beanValidator) {
        if (beanValidator != null) {
            this.getBeanDescriptor().setValue(ATTRIBUTE_BEAN_VALIDATOR, beanValidator);
        }
    }

    public void setBeanInitializer(BeanInitializer beanInitializer) {
        if (beanInitializer != null) {
            this.getBeanDescriptor().setValue(ATTRIBUTE_BEAN_INITIALIZER, beanInitializer);
        }
    }

    public void setSequenceValidator(SequenceValidator sequenceValidator) {
        if (sequenceValidator != null) {
            this.getBeanDescriptor().setValue(ATTRIBUTE_SEQUENCE_VALIDATOR, sequenceValidator);
        }
    }

    public void setDefaultRollbackBarrier(boolean defaultRollbackBarrier) {
        this.getBeanDescriptor().setValue(ATTRIBUTE_DEFAULT_ROLLBACK_BARRIER, defaultRollbackBarrier);
    }

    public void setDefaultRollbackBarrierExitCode(int defaultRollbackBarrierExitCode) {
        this.getBeanDescriptor().setValue(ATTRIBUTE_DEFAULT_ROLLBACK_BARRIER_EXIT_CODE, defaultRollbackBarrierExitCode);
    }

    public void setDefaultConditionExpression(String defaultConditionExpression) {
        this.getBeanDescriptor().setValue(ATTRIBUTE_DEFAULT_CONDITION_EXPRESSION, defaultConditionExpression);
    }

    public void setNoticePanel(JComponent noticePanel) {
        this.getBeanDescriptor().setValue(ATTRIBUTE_NOTICE_PANEL, noticePanel);
    }

    public void setCategorySortOrder(String ... categories) {
        if (categories != null) {
            this.getBeanDescriptor().setValue(ATTRIBUTE_CATEGORY_SORT_ORDER, categories);
        }
    }

    public void setCategorySortOrderOtherAtBottom(boolean categorySortOrderOtherAtBottom) {
        this.getBeanDescriptor().setValue(ATTRIBUTE_CATEGORY_SORT_ORDER_OTHER_AT_BOTTOM, categorySortOrderOtherAtBottom);
    }

    public Class<?> getBeanClass() {
        return this.beanDescriptor.getBeanClass();
    }

    public void checkNotEmpty(String propertyName, Bean bean) throws BeanValidationException {
        if (this.isEmpty(propertyName, bean)) {
            PropertyDescriptor propertyDescriptor = this.findPropertyDescriptor(propertyName);
            String displayName = propertyDescriptor.getDisplayName();
            if (displayName == null || displayName.trim().isEmpty()) {
                throw new BeanValidationException("Please enter all required information.");
            }
            throw new BeanValidationException("The property \"" + displayName + "\" must not be empty.", propertyName);
        }
    }

    public void checkNotEmpty(String propertyName, String errorMessage, Bean bean) throws BeanValidationException {
        if (this.isEmpty(propertyName, bean)) {
            throw new BeanValidationException(errorMessage);
        }
    }

    public boolean isEmpty(String propertyName, Bean bean) {
        PropertyDescriptor propertyDescriptor = this.findPropertyDescriptor(propertyName);
        if (propertyDescriptor == null) {
            return false;
        }
        Object value = this.getPropertyValue(propertyDescriptor, bean);
        if (value == null) {
            return true;
        }
        if (value.getClass().isArray()) {
            return Array.getLength(value) == 0;
        }
        if (value instanceof LocalizedExternalFile) {
            return ((LocalizedExternalFile)value).getLanguageIdToExternalFile().isEmpty();
        }
        if (value instanceof List) {
            return ((List)value).isEmpty();
        }
        if (value instanceof Map) {
            return ((Map)value).isEmpty();
        }
        if (value instanceof ScriptProperty) {
            return ((ScriptProperty)value).getValue().isEmpty();
        }
        return value.toString().trim().isEmpty();
    }

    public Object getPropertyValue(PropertyDescriptor propertyDescriptor, Bean bean) {
        if (propertyDescriptor == null || bean == null) {
            return null;
        }
        Method readMethod = propertyDescriptor.getReadMethod();
        try {
            return readMethod.invoke((Object)bean, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object getPropertyValue(String propertyName, Bean bean) {
        PropertyDescriptor propertyDescriptor = this.findPropertyDescriptor(propertyName);
        if (propertyDescriptor == null) {
            return null;
        }
        return this.getPropertyValue(propertyDescriptor, bean);
    }

    public PropertyDescriptor findPropertyDescriptor(String propertyName) {
        PropertyDescriptor[] propertyDescriptors = this.getPropertyDescriptors();
        if (propertyDescriptors == null) {
            return null;
        }
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            if (!Objects.equals(propertyDescriptor.getName(), propertyName)) continue;
            return propertyDescriptor;
        }
        return null;
    }

    private void initBeanDescriptor(Class<? extends Bean> beanClass, Class<?> customizerClass) {
        this.beanDescriptor = new BeanDescriptor(beanClass, customizerClass);
    }

    private void setDisplayName(String displayName) {
        this.beanDescriptor.setDisplayName(displayName);
    }

    private void setShortDescription(String shortDescription) {
        this.beanDescriptor.setShortDescription(shortDescription);
    }

    private void setBeanCategory(String category) {
        if (category != null) {
            this.getBeanDescriptor().setValue(ATTRIBUTE_BEAN_CATEGORY, category);
        }
    }

    private void setMultipleInstancesSupported(boolean multipleInstancesSupported) {
        this.getBeanDescriptor().setValue(ATTRIBUTE_MULTIPLE_INSTANCES_SUPPORTED, multipleInstancesSupported);
    }

    private void setInstalledFilesRequired(boolean installedFilesRequired) {
        this.getBeanDescriptor().setValue(ATTRIBUTE_INSTALLED_FILES_REQUIRED, installedFilesRequired);
    }

    private void setSortKey(Integer sortKey) {
        if (sortKey != null) {
            this.getBeanDescriptor().setValue(ATTRIBUTE_SORT_KEY, sortKey);
        }
    }
}

