/*
 * Decompiled with CFR 0.152.
 */
package org.pkcs11.jacknji11.jna;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import java.util.ArrayList;
import java.util.List;
import org.pkcs11.jacknji11.CKA;

public class Template
extends PointerType {
    private CKA[] list;
    private List<Memory> pValues;
    private int listLen;

    public Template() {
        this(null);
    }

    public int getListLen() {
        return this.listLen;
    }

    public Template(CKA[] list) {
        this.list = list;
        int n = this.listLen = list == null ? 0 : list.length;
        if (this.listLen == 0) {
            return;
        }
        this.setPointer((Pointer)new Memory((long)(this.listLen * (NativeLong.SIZE + Native.POINTER_SIZE + NativeLong.SIZE))));
        this.pValues = new ArrayList<Memory>();
        int offset = 0;
        for (int i = 0; i < this.listLen; ++i) {
            if (NativeLong.SIZE == 4) {
                this.getPointer().setInt((long)offset, (int)list[i].type);
            } else {
                this.getPointer().setLong((long)offset, list[i].type);
            }
            offset += NativeLong.SIZE;
            Memory pValue = null;
            if (list[i].ulValueLen > 0L) {
                pValue = new Memory(list[i].ulValueLen);
                pValue.write(0L, list[i].pValue, 0, (int)list[i].ulValueLen);
            }
            this.getPointer().setPointer((long)offset, pValue);
            this.pValues.add(pValue);
            offset += Native.POINTER_SIZE;
            if (NativeLong.SIZE == 4) {
                this.getPointer().setInt((long)offset, (int)list[i].ulValueLen);
            } else {
                this.getPointer().setLong((long)offset, list[i].ulValueLen);
            }
            offset += NativeLong.SIZE;
        }
    }

    public void update() {
        if (this.listLen == 0) {
            return;
        }
        int offset = 0;
        for (CKA cka : this.list) {
            Pointer ptr = this.getPointer().getPointer((long)(offset += NativeLong.SIZE));
            int ulValueLen = 0;
            ulValueLen = NativeLong.SIZE == 4 ? this.getPointer().getInt((long)offset) : (int)this.getPointer().getLong((long)(offset += Native.POINTER_SIZE));
            offset += NativeLong.SIZE;
            if (ptr != null && ulValueLen > 0) {
                ptr.read(0L, cka.pValue, 0, ulValueLen);
            }
            cka.ulValueLen = ulValueLen;
            cka.set();
        }
    }
}

