/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.bytecode;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gjt.jclasslib.bytecode.MatchOffsetPair;
import org.gjt.jclasslib.bytecode.Opcode;
import org.gjt.jclasslib.bytecode.PaddedInstruction;
import org.gjt.jclasslib.io.CountingDataInput;
import org.gjt.jclasslib.io.CountingDataOutput;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR \u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lorg/gjt/jclasslib/bytecode/LookupSwitchInstruction;", "Lorg/gjt/jclasslib/bytecode/PaddedInstruction;", "<init>", "()V", "defaultOffset", "", "getDefaultOffset", "()I", "setDefaultOffset", "(I)V", "matchOffsetPairs", "", "Lorg/gjt/jclasslib/bytecode/MatchOffsetPair;", "getMatchOffsetPairs", "()Ljava/util/List;", "setMatchOffsetPairs", "(Ljava/util/List;)V", "size", "getSize", "read", "", "input", "Lorg/gjt/jclasslib/io/CountingDataInput;", "write", "output", "Lorg/gjt/jclasslib/io/CountingDataOutput;", "data"})
public final class LookupSwitchInstruction
extends PaddedInstruction {
    private int defaultOffset;
    @NotNull
    private List<MatchOffsetPair> matchOffsetPairs = new ArrayList();

    public LookupSwitchInstruction() {
        super(Opcode.LOOKUPSWITCH);
    }

    public final int getDefaultOffset() {
        return this.defaultOffset;
    }

    public final void setDefaultOffset(int n) {
        this.defaultOffset = n;
    }

    @NotNull
    public final List<MatchOffsetPair> getMatchOffsetPairs() {
        return this.matchOffsetPairs;
    }

    public final void setMatchOffsetPairs(@NotNull List<MatchOffsetPair> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.matchOffsetPairs = list;
    }

    @Override
    public int getSize() {
        return super.getSize() + 8 + 8 * this.matchOffsetPairs.size();
    }

    @Override
    public void read(@NotNull CountingDataInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        super.read(input);
        this.matchOffsetPairs.clear();
        this.defaultOffset = input.readInt();
        int numberOfPairs = input.readInt();
        int n = 0;
        while (n < numberOfPairs) {
            int it = n++;
            boolean bl = false;
            int match = input.readInt();
            int offset = input.readInt();
            this.matchOffsetPairs.add(new MatchOffsetPair(match, offset));
        }
    }

    @Override
    public void write(@NotNull CountingDataOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        super.write(output);
        output.writeInt(this.defaultOffset);
        int numberOfPairs = this.matchOffsetPairs.size();
        output.writeInt(numberOfPairs);
        for (MatchOffsetPair matchOffsetPair : this.matchOffsetPairs) {
            output.writeInt(matchOffsetPair.getMatch());
            output.writeInt(matchOffsetPair.getOffset());
        }
    }
}

