/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.icons.IconUtils;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.utils.SystemInfo;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.MultiResolutionImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class JideCursors {
    public static final int FIRST_CUSTOM_CURSOR = 20;
    public static final int DRAG_CURSOR = 22;
    public static final int DRAG_STOP_CURSOR = 23;
    public static final int NORTH_CURSOR = 24;
    public static final int SOUTH_CURSOR = 25;
    public static final int EAST_CURSOR = 26;
    public static final int WEST_CURSOR = 27;
    public static final int TAB_CURSOR = 28;
    public static final int FLOAT_CURSOR = 29;
    public static final int VERTICAL_CURSOR = 30;
    public static final int HORIZONTAL_CURSOR = 31;
    public static final int DELETE_CURSOR = 32;
    public static final int DRAG_TEXT_CURSOR = 33;
    public static final int DRAG_TEXT_STOP_CURSOR = 34;
    public static final int PERCENTAGE_CURSOR = 35;
    public static final int MOVE_EAST_CURSOR = 36;
    public static final int MOVE_WEST_CURSOR = 37;
    public static final int LAST_CUSTOM_CURSOR = 38;
    private static final Cursor[] predefined = new Cursor[19];

    public static Cursor getPredefinedCursor(int n2) {
        if (n2 < 20 || n2 > 38) {
            throw new IllegalArgumentException("illegal cursor type");
        }
        if (predefined[n2 - 20] == null) {
            JideCursors.predefined[n2 - 20] = JideCursors.createCursor(n2);
        }
        return predefined[n2 - 20];
    }

    public static void setPredefinedCursor(int n2, Cursor cursor) {
        if (n2 < 20 || n2 > 38) {
            throw new IllegalArgumentException("illegal cursor type");
        }
        JideCursors.predefined[n2 - 20] = cursor == null ? JideCursors.createCursor(n2) : cursor;
    }

    protected static Cursor createCursor(int n2) {
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Dimension dimension = toolkit.getBestCursorSize(32, 32);
            int n3 = toolkit.getMaximumCursorColors();
            switch (n2) {
                case 22: {
                    if (dimension.width != 0 && n3 > 3) {
                        Icon icon = UIDefaultsLookup.getIcon("Cursor.drag");
                        if (icon == null) {
                            return Cursor.getDefaultCursor();
                        }
                        return toolkit.createCustomCursor(JideCursors.getImageIfNeeded(icon), new Point(17, 12), "Drag");
                    }
                    return Cursor.getDefaultCursor();
                }
                case 23: {
                    if (dimension.width != 0 && n3 > 3) {
                        Icon icon = UIDefaultsLookup.getIcon("Cursor.dragStop");
                        if (icon == null) {
                            return Cursor.getDefaultCursor();
                        }
                        return toolkit.createCustomCursor(JideCursors.getImageIfNeeded(icon), new Point(17, 12), "Drag Stop");
                    }
                    return Cursor.getDefaultCursor();
                }
                case 33: {
                    if (dimension.width != 0 && n3 > 3) {
                        Icon icon = UIDefaultsLookup.getIcon("Cursor.dragText");
                        if (icon == null) {
                            return Cursor.getDefaultCursor();
                        }
                        return toolkit.createCustomCursor(JideCursors.getImageIfNeeded(icon), new Point(0, 0), "Drag Text");
                    }
                    return Cursor.getDefaultCursor();
                }
                case 34: {
                    if (dimension.width != 0 && n3 > 3) {
                        Icon icon = UIDefaultsLookup.getIcon("Cursor.dragTextStop");
                        if (icon == null) {
                            return Cursor.getDefaultCursor();
                        }
                        return toolkit.createCustomCursor(JideCursors.getImageIfNeeded(icon), new Point(15, 15), "Drag Text Stop");
                    }
                    return Cursor.getDefaultCursor();
                }
                case 24: {
                    if (dimension.width != 0 && n3 > 3) {
                        Icon icon = UIDefaultsLookup.getIcon("Cursor.north");
                        if (icon == null) {
                            return Cursor.getDefaultCursor();
                        }
                        return toolkit.createCustomCursor(JideCursors.getImageIfNeeded(icon), new Point(15, 10), "North");
                    }
                    return Cursor.getDefaultCursor();
                }
                case 25: {
                    if (dimension.width != 0 && n3 > 3) {
                        Icon icon = UIDefaultsLookup.getIcon("Cursor.south");
                        if (icon == null) {
                            return Cursor.getDefaultCursor();
                        }
                        return toolkit.createCustomCursor(JideCursors.getImageIfNeeded(icon), new Point(15, 20), "South");
                    }
                    return Cursor.getDefaultCursor();
                }
                case 26: {
                    if (dimension.width != 0 && n3 > 3) {
                        Icon icon = UIDefaultsLookup.getIcon("Cursor.east");
                        if (icon == null) {
                            return Cursor.getDefaultCursor();
                        }
                        return toolkit.createCustomCursor(JideCursors.getImageIfNeeded(icon), new Point(20, 15), "East");
                    }
                    return Cursor.getDefaultCursor();
                }
                case 27: {
                    if (dimension.width != 0 && n3 > 3) {
                        Icon icon = UIDefaultsLookup.getIcon("Cursor.west");
                        if (icon == null) {
                            return Cursor.getDefaultCursor();
                        }
                        return toolkit.createCustomCursor(JideCursors.getImageIfNeeded(icon), new Point(10, 15), "West");
                    }
                    return Cursor.getDefaultCursor();
                }
                case 28: {
                    if (dimension.width != 0 && n3 > 3) {
                        Icon icon = UIDefaultsLookup.getIcon("Cursor.tab");
                        if (icon == null) {
                            return Cursor.getDefaultCursor();
                        }
                        return toolkit.createCustomCursor(JideCursors.getImageIfNeeded(icon), new Point(15, 15), "Tabbed");
                    }
                    return Cursor.getDefaultCursor();
                }
                case 29: {
                    if (dimension.width != 0 && n3 > 3) {
                        Icon icon = UIDefaultsLookup.getIcon("Cursor.float");
                        if (icon == null) {
                            return Cursor.getDefaultCursor();
                        }
                        return toolkit.createCustomCursor(JideCursors.getImageIfNeeded(icon), new Point(15, 15), "Floating");
                    }
                    return Cursor.getDefaultCursor();
                }
                case 30: {
                    if (dimension.width != 0 && n3 > 3) {
                        Icon icon = UIDefaultsLookup.getIcon("Cursor.vertical");
                        if (icon == null) {
                            return Cursor.getDefaultCursor();
                        }
                        return toolkit.createCustomCursor(JideCursors.getImageIfNeeded(icon), new Point(15, 15), "Vertical");
                    }
                    return Cursor.getDefaultCursor();
                }
                case 31: {
                    if (dimension.width != 0 && n3 > 3) {
                        Icon icon = UIDefaultsLookup.getIcon("Cursor.horizontal");
                        if (icon == null) {
                            return Cursor.getDefaultCursor();
                        }
                        return toolkit.createCustomCursor(JideCursors.getImageIfNeeded(icon), new Point(15, 15), "Horizontal");
                    }
                    return Cursor.getDefaultCursor();
                }
                case 32: {
                    if (dimension.width != 0 && n3 > 3) {
                        Icon icon = UIDefaultsLookup.getIcon("Cursor.delete");
                        if (icon == null) {
                            return Cursor.getDefaultCursor();
                        }
                        return toolkit.createCustomCursor(JideCursors.getImageIfNeeded(icon), new Point(10, 10), "Delete");
                    }
                    return Cursor.getDefaultCursor();
                }
                case 35: {
                    if (dimension.width != 0 && n3 > 3) {
                        Icon icon = UIDefaultsLookup.getIcon("Cursor.percentage");
                        if (icon == null) {
                            return Cursor.getDefaultCursor();
                        }
                        return toolkit.createCustomCursor(JideCursors.getImageIfNeeded(icon), new Point(20, 15), "Percentage");
                    }
                    return Cursor.getDefaultCursor();
                }
                case 36: {
                    if (dimension.width != 0 && n3 > 3) {
                        Icon icon = UIDefaultsLookup.getIcon("Cursor.moveEast");
                        if (icon == null) {
                            return Cursor.getDefaultCursor();
                        }
                        return toolkit.createCustomCursor(JideCursors.getImageIfNeeded(icon), new Point(11, 15), "Move East");
                    }
                    return Cursor.getDefaultCursor();
                }
                case 37: {
                    if (dimension.width != 0 && n3 > 3) {
                        Icon icon = UIDefaultsLookup.getIcon("Cursor.moveWest");
                        if (icon == null) {
                            return Cursor.getDefaultCursor();
                        }
                        return toolkit.createCustomCursor(JideCursors.getImageIfNeeded(icon), new Point(20, 15), "Move West");
                    }
                    return Cursor.getDefaultCursor();
                }
            }
            return null;
        }
        catch (Exception exception) {
            return Cursor.getDefaultCursor();
        }
    }

    private static Image getImageIfNeeded(Icon icon) {
        if (icon instanceof ImageIcon) {
            Image image = ((ImageIcon)icon).getImage();
            if (image instanceof MultiResolutionImage) {
                double d2 = 64.0 * SystemInfo.getScaleFactor();
                return ((MultiResolutionImage)((Object)image)).getResolutionVariant(d2, d2);
            }
            return image;
        }
        return IconUtils.iconToImageIcon(icon).getImage();
    }

    static {
        for (int i2 = 20; i2 < 38; ++i2) {
            JideCursors.getPredefinedCursor(i2);
        }
    }
}

