/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.synthetica;

import com.jidesoft.plaf.synthetica.AnimationThreadFactory;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.util.java2d.Synthetica2DUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.plaf.ColorUIResource;

class ImagePainter {
    public static final Logger logger = Logger.getLogger(ImagePainter.class.getName());
    public static final int STRETCHED = 0;
    public static final int TILED = 1;
    private Graphics g;
    private int x;
    private int y;
    private int w;
    private int h;
    private int iw;
    private int ih;
    private int xPolicy;
    private int yPolicy;
    private Image image;
    private Insets sInsets;
    private Insets dInsets;
    private WeakReference weakComponent;
    private AnimationThreadFactory.AnimationThread animationThread;
    private String id;
    private int angle = 0;
    private boolean flipHorizontal;
    private boolean flipVertical;
    private boolean animationEnabled;
    private static long initDuration = -1L;
    private static int initOperations = 0;
    private static long paintDuration = 0L;
    private static int paintOperations = 0;
    private static HashMap imageCache = new HashMap();
    private static boolean debug = SyntheticaLookAndFeel.isSystemPropertySet((String)"synthetica.debug");

    public ImagePainter(JComponent jComponent, int n2, int n3, int n4, int n5, Graphics graphics, int n6, int n7, int n8, int n9, String string, Insets insets, Insets insets2, int n10, int n11) {
        this(jComponent, null, n2, n3, n4, n5, graphics, n6, n7, n8, n9, string, insets, insets2, n10, n11);
    }

    public ImagePainter(JComponent jComponent, String string, int n2, int n3, int n4, int n5, Graphics graphics, int n6, int n7, int n8, int n9, String string2, Insets insets, Insets insets2, int n10, int n11) {
        String[] stringArray;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Image Path: " + string2);
        }
        if (!debug && string2 == null) {
            return;
        }
        if (debug && initDuration == -1L) {
            Frame[] frameArray = Frame.getFrames();
            for (int i2 = 0; i2 < frameArray.length; ++i2) {
                if (!(frameArray[i2] instanceof JFrame)) continue;
                ((JFrame)frameArray[i2]).getRootPane().registerKeyboardAction(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        System.out.println("inits: " + initOperations + " in " + initDuration + " ms");
                        System.out.println("paint: " + paintOperations + " in " + paintDuration + " ms");
                        initDuration = 0L;
                        initOperations = 0;
                        paintDuration = 0L;
                        paintOperations = 0;
                        Frame[] frameArray = Frame.getFrames();
                        for (int i2 = 0; i2 < frameArray.length; ++i2) {
                            Frame frame = frameArray[i2];
                            if (!(frame instanceof JFrame) || ((JFrame)frame).getRootPane() == null) continue;
                            frame.setSize(640, 550);
                            frame.validate();
                            ((JFrame)frame).getRootPane().repaint();
                        }
                    }
                }, "durationAction", KeyStroke.getKeyStroke(123, 10), 1);
            }
        }
        long l2 = System.currentTimeMillis();
        if (string == null) {
            string = "null";
        }
        this.id = string;
        String[] stringArray2 = string2.split(",");
        if (jComponent != null) {
            this.weakComponent = new WeakReference<JComponent>(jComponent);
            if (jComponent.getClientProperty("Synthetica.flipHorizontal") != null && ((Boolean)jComponent.getClientProperty("Synthetica.flipHorizontal")).booleanValue()) {
                this.flipHorizontal = true;
                insets = this.flipLeftRight(insets);
                insets2 = this.flipLeftRight(insets2);
            }
            if (jComponent.getClientProperty("Synthetica.flipVertical") != null && ((Boolean)jComponent.getClientProperty("Synthetica.flipVertical")).booleanValue()) {
                this.flipVertical = true;
                insets = this.flipTopBottom(insets);
                insets2 = this.flipTopBottom(insets2);
            }
        }
        this.animationEnabled = this.isAnimationEnabled(jComponent);
        if (this.animationEnabled && jComponent != null && n3 > 0) {
            stringArray = AnimationThreadFactory.createThread(n3);
            Rectangle rectangle = new Rectangle(n6, n7, n8, n9);
            if (jComponent instanceof JTabbedPane && !string.equals("null")) {
                rectangle = ((JTabbedPane)jComponent).getBoundsAt(Integer.parseInt(string.split("/")[1]));
            }
            stringArray.addComponent(jComponent, this.id, n5, n4, stringArray2, n2, rectangle);
            this.animationThread = stringArray;
        }
        this.g = graphics;
        this.x = n6;
        this.y = n7;
        this.w = n8;
        this.h = n9;
        stringArray = stringArray2;
        int n12 = stringArray2.length;
        for (int i3 = 0; i3 < n12; ++i3) {
            String string3 = stringArray[i3];
            this.image = (Image)imageCache.get(string3);
            if (this.image != null) continue;
            URL uRL = SyntheticaLookAndFeel.class.getResource(string3);
            if (uRL == null) {
                throw new RuntimeException("File not found: " + string3);
            }
            try {
                this.image = this.toCompatibleImage(ImageIO.read(uRL));
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            imageCache.put(string3, this.image);
        }
        this.iw = this.image.getWidth(null);
        this.ih = this.image.getHeight(null);
        this.sInsets = insets;
        this.dInsets = insets2;
        this.xPolicy = n10;
        this.yPolicy = n11;
        if (debug) {
            long l3 = System.currentTimeMillis();
            long l4 = l3 - l2;
            initDuration += l4;
            ++initOperations;
        }
    }

    private Insets flipLeftRight(Insets insets) {
        if (insets == null) {
            return null;
        }
        return new Insets(insets.top, insets.right, insets.bottom, insets.left);
    }

    private Insets flipTopBottom(Insets insets) {
        if (insets == null) {
            return null;
        }
        return new Insets(insets.bottom, insets.left, insets.top, insets.right);
    }

    private boolean isAnimationEnabled(JComponent jComponent) {
        return SyntheticaLookAndFeel.getBoolean((String)"Synthetica.animation.enabled", (Component)jComponent, (boolean)true);
    }

    public ImagePainter(JComponent jComponent, Graphics graphics, int n2, int n3, int n4, int n5, String string, Insets insets, Insets insets2, int n6, int n7) {
        this(jComponent, -1, -1, -1, -1, graphics, n2, n3, n4, n5, string, insets, insets2, n6, n7);
    }

    public ImagePainter(Graphics graphics, int n2, int n3, int n4, int n5, String string, Insets insets, Insets insets2, int n6, int n7) {
        this(null, graphics, n2, n3, n4, n5, string, insets, insets2, n6, n7);
    }

    public ImagePainter(JComponent jComponent, int n2, int n3, int n4, Insets insets, Graphics graphics, int n5, int n6, int n7, int n8, String string, Insets insets2, Insets insets3, int n9, int n10) {
        this(graphics, n5, n6, n7, n8, string, insets2, insets3, n9, n10);
        if (!debug && string == null) {
            return;
        }
        Image image = (Image)imageCache.get(string);
        if (image == null || !(image instanceof BufferedImage)) {
            try {
                image = this.toCompatibleImage(ImageIO.read(SyntheticaLookAndFeel.class.getResource(string)));
                imageCache.put(string, image);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.image = jComponent.createImage(new FilteredImageSource(image.getSource(), new Colorizer(0, n2, n3, n4, image.getWidth(null), image.getHeight(null), insets)));
    }

    public ImagePainter(JComponent jComponent, Graphics graphics, int n2, int n3, int n4, int n5, String string, Insets insets, Insets insets2, Insets insets3, Insets insets4, int n6, int n7) {
        this(graphics, n2, n3, n4, n5, string, insets, insets2, n6, n7);
        String string2 = String.valueOf(string) + "_EXCLUDED_OUTER_INSETS";
        Image image = (Image)imageCache.get(string2);
        if (image == null) {
            int n8 = this.iw - insets.left - insets.right;
            int n9 = this.ih - insets.top - insets.bottom;
            BufferedImage bufferedImage = new BufferedImage(n8, n9, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            this.g = graphics2D;
            this.x = 0;
            this.y = 0;
            this.w = n8;
            this.h = n9;
            this.draw();
            graphics2D.dispose();
            imageCache.put(string2, bufferedImage);
            image = bufferedImage;
            this.g = graphics;
            this.x = n2;
            this.y = n3;
            this.w = n4;
            this.h = n5;
        }
        this.image = image;
        this.iw = image.getWidth(null);
        this.ih = image.getHeight(null);
        this.sInsets = insets3;
        this.dInsets = insets4;
    }

    public ImagePainter(Image image, Graphics graphics, int n2, int n3, int n4, int n5, Insets insets, Insets insets2) {
        this.image = image;
        this.iw = image.getWidth(null);
        this.ih = image.getHeight(null);
        this.g = graphics;
        this.x = n2;
        this.y = n3;
        this.w = n4;
        this.h = n5;
        this.sInsets = insets;
        this.dInsets = insets2;
    }

    public static void clearImageCache() {
        imageCache.clear();
    }

    public void setAngle(int n2) {
        this.angle = n2;
        if (this.animationThread != null && this.weakComponent != null && !(this.weakComponent.get() instanceof JTabbedPane) && n2 != 0) {
            this.animationThread.rotateRepaintRect((JComponent)this.weakComponent.get(), this.id);
        }
    }

    public void draw() {
        this.drawBorder();
        this.drawCenter();
    }

    public void drawBorder() {
        this.drawTopLeft();
        this.drawTopCenter();
        this.drawTopRight();
        this.drawLeft();
        this.drawRight();
        this.drawBottomLeft();
        this.drawBottomCenter();
        this.drawBottomRight();
    }

    public void drawCenter() {
        if (this.animationEnabled && this.weakComponent != null && this.animationThread != null) {
            this.image = (Image)imageCache.get(this.animationThread.getImagePath((JComponent)this.weakComponent.get(), this.id));
        }
        if (this.dInsets == null || this.sInsets == null) {
            return;
        }
        this.drawImage(this.image, this.g, this.x + this.dInsets.left, this.y + this.dInsets.top, this.x + this.w - this.dInsets.right, this.y + this.h - this.dInsets.bottom, this.sInsets.left, this.sInsets.top, this.iw - this.sInsets.right, this.ih - this.sInsets.bottom, this.xPolicy, this.yPolicy);
    }

    public void drawTopLeft() {
        if (this.animationEnabled && this.weakComponent != null && this.animationThread != null) {
            this.image = (Image)imageCache.get(this.animationThread.getImagePath((JComponent)this.weakComponent.get(), this.id));
        }
        this.drawImage(this.image, this.g, this.x, this.y, this.x + this.dInsets.left, Math.min(this.y + this.h - this.dInsets.bottom, this.y + this.dInsets.top), 0, 0, this.sInsets.left, Math.min(this.h - this.sInsets.bottom, this.sInsets.top), 0, 0);
    }

    public void drawTopRight() {
        if (this.animationEnabled && this.weakComponent != null && this.animationThread != null) {
            this.image = (Image)imageCache.get(this.animationThread.getImagePath((JComponent)this.weakComponent.get(), this.id));
        }
        this.drawImage(this.image, this.g, this.x + this.w - this.dInsets.right, this.y, this.x + this.w, Math.min(this.y + this.h - this.dInsets.bottom, this.y + this.dInsets.top), this.iw - this.sInsets.right, 0, this.iw, Math.min(this.h - this.sInsets.bottom, this.sInsets.top), 0, 0);
    }

    public void drawBottomLeft() {
        if (this.animationEnabled && this.weakComponent != null && this.animationThread != null) {
            this.image = (Image)imageCache.get(this.animationThread.getImagePath((JComponent)this.weakComponent.get(), this.id));
        }
        this.drawImage(this.image, this.g, this.x, this.y + this.h - this.dInsets.bottom, this.x + this.dInsets.left, this.y + this.h, 0, this.ih - this.sInsets.bottom, this.sInsets.left, this.ih, 0, 0);
    }

    public void drawBottomRight() {
        if (this.animationEnabled && this.weakComponent != null && this.animationThread != null) {
            this.image = (Image)imageCache.get(this.animationThread.getImagePath((JComponent)this.weakComponent.get(), this.id));
        }
        this.drawImage(this.image, this.g, this.x + this.w - this.dInsets.right, this.y + this.h - this.dInsets.bottom, this.x + this.w, this.y + this.h, this.iw - this.sInsets.right, this.ih - this.sInsets.bottom, this.iw, this.ih, 0, 0);
    }

    public void drawTopCenter() {
        if (this.animationEnabled && this.weakComponent != null && this.animationThread != null) {
            this.image = (Image)imageCache.get(this.animationThread.getImagePath((JComponent)this.weakComponent.get(), this.id));
        }
        this.drawImage(this.image, this.g, this.x + this.dInsets.left, this.y, this.x + this.w - this.dInsets.right, Math.min(this.y + this.h - this.dInsets.bottom, this.y + this.dInsets.top), this.sInsets.left, 0, this.iw - this.sInsets.right, Math.min(this.h - this.sInsets.bottom, this.sInsets.top), this.xPolicy, this.yPolicy);
    }

    public void drawLeft() {
        if (this.animationEnabled && this.weakComponent != null && this.animationThread != null) {
            this.image = (Image)imageCache.get(this.animationThread.getImagePath((JComponent)this.weakComponent.get(), this.id));
        }
        this.drawImage(this.image, this.g, this.x, this.y + this.dInsets.top, this.x + this.dInsets.left, this.y + this.h - this.dInsets.bottom, 0, this.sInsets.top, this.sInsets.left, this.ih - this.sInsets.bottom, this.xPolicy, this.yPolicy);
    }

    public void drawRight() {
        if (this.animationEnabled && this.weakComponent != null && this.animationThread != null) {
            this.image = (Image)imageCache.get(this.animationThread.getImagePath((JComponent)this.weakComponent.get(), this.id));
        }
        this.drawImage(this.image, this.g, this.x + this.w - this.dInsets.right, this.y + this.dInsets.top, this.x + this.w, this.y + this.h - this.dInsets.bottom, this.iw - this.sInsets.right, this.sInsets.top, this.iw, this.ih - this.sInsets.bottom, this.xPolicy, this.yPolicy);
    }

    public void drawBottomCenter() {
        if (this.animationEnabled && this.weakComponent != null && this.animationThread != null) {
            this.image = (Image)imageCache.get(this.animationThread.getImagePath((JComponent)this.weakComponent.get(), this.id));
        }
        this.drawImage(this.image, this.g, this.x + this.dInsets.left, this.y + this.h - this.dInsets.bottom, this.x + this.w - this.dInsets.right, this.y + this.h, this.sInsets.left, this.ih - this.sInsets.bottom, this.iw - this.sInsets.right, this.ih, this.xPolicy, this.yPolicy);
    }

    private void drawImage(Image image, Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        if (image == null) {
            return;
        }
        if (this.angle != 0) {
            this.rotateGraphics(graphics, true);
        }
        if (this.flipHorizontal) {
            image = Synthetica2DUtils.flipHorizontal((Image)image);
        }
        if (this.flipVertical) {
            image = Synthetica2DUtils.flipVertical((Image)image);
        }
        if (this.weakComponent != null) {
            JComponent jComponent = (JComponent)this.weakComponent.get();
            Color color = jComponent.getBackground();
            float f2 = (float)SyntheticaLookAndFeel.getInt((String)"Synthetica.background.alpha", (Component)jComponent, (int)10) / 100.0f;
            if (jComponent.getClientProperty("Synthetica.background") != null || color != null && !(color instanceof ColorUIResource) && !(color instanceof SystemColor)) {
                if (!(image instanceof BufferedImage)) {
                    BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
                    bufferedImage.getGraphics().drawImage(image, 0, 0, null);
                    image = bufferedImage;
                }
                if (jComponent.getClientProperty("Synthetica.background") != null) {
                    color = (Color)jComponent.getClientProperty("Synthetica.background");
                }
                if (jComponent.getClientProperty("Synthetica.background.alpha") != null) {
                    f2 = ((Float)jComponent.getClientProperty("Synthetica.background.alpha")).floatValue();
                }
                image = Synthetica2DUtils.createColorizedImage((BufferedImage)((BufferedImage)image), (Color)color, (float)f2);
            }
        }
        long l2 = System.currentTimeMillis();
        if (n10 == 0 && n11 == 0) {
            graphics.drawImage(image, n2, n3, n4, n5, n6, n7, n8, n9, null);
        } else {
            int n12 = n2;
            int n13 = n8 - n6;
            int n14 = n9 - n7;
            while (n3 < n5) {
                while (n2 < n4) {
                    int n15 = n4;
                    if (n10 == 1) {
                        n15 = Math.min(n4, n2 + n13);
                    }
                    int n16 = n5;
                    if (n11 == 1) {
                        n16 = Math.min(n5, n3 + n14);
                    }
                    int n17 = n10 != 1 ? n8 : Math.min(n8, n6 + (n15 - n2));
                    int n18 = n11 != 1 ? n9 : Math.min(n9, n7 + (n16 - n3));
                    graphics.drawImage(image, n2, n3, n15, n16, n6, n7, n17, n18, null);
                    if (n10 == 0) break;
                    n2 += n13;
                }
                if (n11 == 0) break;
                n2 = n12;
                n3 += n14;
            }
        }
        if (this.angle != 0) {
            this.rotateGraphics(graphics, false);
        }
        long l3 = System.currentTimeMillis();
        long l4 = l3 - l2;
        if (debug && l4 > 100L) {
            System.out.println("Paint performance lack: " + l4 + " ms " + this.findImage(image));
        }
        paintDuration += l4;
        ++paintOperations;
    }

    private void rotateGraphics(Graphics graphics, boolean bl2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (bl2) {
            graphics2D.translate(this.angle <= 0 ? 0 : this.h, this.angle <= 0 ? this.w : 0);
            graphics2D.rotate(Math.toRadians(this.angle), this.x, this.y);
        } else {
            graphics2D.rotate(Math.toRadians(-this.angle), this.x, this.y);
            graphics2D.translate(this.angle <= 0 ? 0 : -this.h, this.angle <= 0 ? -this.w : 0);
        }
    }

    private String findImage(Image image) {
        String string = null;
        Set set = imageCache.entrySet();
        for (Map.Entry entry : set) {
            if (entry.getValue() != image) continue;
            string = (String)entry.getKey();
            break;
        }
        return string;
    }

    private BufferedImage toCompatibleImage(Image image) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(image.getWidth(null), image.getHeight(null), 3);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.drawImage(image, 0, 0, null);
        graphics.dispose();
        return bufferedImage;
    }

    private static class Colorizer
    extends RGBImageFilter {
        private int a;
        private int r;
        private int g;
        private int b;
        private int w;
        private int h;
        private Insets insets;

        @Override
        public int filterRGB(int n2, int n3, int n4) {
            if (n2 < this.insets.left || n2 > this.w - this.insets.right - 1 || n3 < this.insets.top || n3 > this.h - this.insets.bottom - 1) {
                return n4;
            }
            Color color = new Color(n4, true);
            int n5 = Math.min(Math.max(color.getRed() + color.getRed() * this.r / 100, 0), 255);
            int n6 = Math.min(Math.max(color.getGreen() + color.getGreen() * this.g / 100, 0), 255);
            int n7 = Math.min(Math.max(color.getBlue() + color.getBlue() * this.b / 100, 0), 255);
            int n8 = Math.min(Math.max(color.getAlpha() + color.getAlpha() * this.a / 100, 0), 255);
            return new Color(n5, n6, n7, n8).getRGB();
        }

        public Colorizer(int n2, int n3, int n4, int n5, int n6, int n7, Insets insets) {
            this.canFilterIndexColorModel = true;
            this.a = n2;
            this.r = n3;
            this.g = n4;
            this.b = n5;
            this.w = n6;
            this.h = n7;
            this.insets = insets;
        }
    }
}

