/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.swing.JideLabel;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.LabelUI;
import javax.swing.plaf.basic.BasicLabelUI;
import javax.swing.text.View;

public class BasicJideLabelUI
extends BasicLabelUI {
    private static final LabelUI INSTANCE = new BasicJideLabelUI();
    private static Rectangle paintIconR = new Rectangle();
    private static Rectangle paintTextR = new Rectangle();
    private static Rectangle paintViewR = new Rectangle();
    private static Insets paintViewInsets = new Insets(0, 0, 0, 0);

    public static ComponentUI createUI(JComponent jComponent) {
        return INSTANCE;
    }

    @Override
    protected void installDefaults(JLabel jLabel) {
        super.installDefaults(jLabel);
        LookAndFeel.installColorsAndFont(jLabel, "JideLabel.background", "JideLabel.foreground", "JideLabel.font");
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = super.getPreferredSize(jComponent);
        if (JideSwingUtilities.getOrientationOf(jComponent) == 0) {
            return dimension;
        }
        return new Dimension(dimension.height, dimension.width);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        if (JideSwingUtilities.getOrientationOf(jComponent) == 1) {
            boolean bl2 = true;
            if (jComponent instanceof JideLabel) {
                bl2 = ((JideLabel)jComponent).isClockwise();
            }
            this.paintVertically(graphics, jComponent, bl2);
        } else {
            super.paint(graphics, jComponent);
        }
    }

    public void paintVertically(Graphics graphics, JComponent jComponent, boolean bl2) {
        Icon icon;
        JLabel jLabel = (JLabel)jComponent;
        String string = jLabel.getText();
        Icon icon2 = icon = jLabel.isEnabled() ? jLabel.getIcon() : jLabel.getDisabledIcon();
        if (icon == null && string == null) {
            return;
        }
        FontMetrics fontMetrics = jComponent.getFontMetrics(jComponent.getFont());
        paintViewInsets = jComponent.getInsets(paintViewInsets);
        BasicJideLabelUI.paintViewR.x = BasicJideLabelUI.paintViewInsets.left;
        BasicJideLabelUI.paintViewR.y = BasicJideLabelUI.paintViewInsets.top;
        BasicJideLabelUI.paintViewR.height = jComponent.getWidth() - (BasicJideLabelUI.paintViewInsets.left + BasicJideLabelUI.paintViewInsets.right);
        BasicJideLabelUI.paintViewR.width = jComponent.getHeight() - (BasicJideLabelUI.paintViewInsets.top + BasicJideLabelUI.paintViewInsets.bottom);
        BasicJideLabelUI.paintIconR.height = 0;
        BasicJideLabelUI.paintIconR.width = 0;
        BasicJideLabelUI.paintIconR.y = 0;
        BasicJideLabelUI.paintIconR.x = 0;
        BasicJideLabelUI.paintTextR.height = 0;
        BasicJideLabelUI.paintTextR.width = 0;
        BasicJideLabelUI.paintTextR.y = 0;
        BasicJideLabelUI.paintTextR.x = 0;
        String string2 = this.layoutCL(jLabel, fontMetrics, string, icon, paintViewR, paintIconR, paintTextR);
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = graphics2D.getTransform();
        if (bl2) {
            graphics2D.rotate(1.5707963267948966);
            graphics2D.translate(0, -jComponent.getWidth());
        } else {
            graphics2D.rotate(-1.5707963267948966);
            graphics2D.translate(-jComponent.getHeight(), 0);
        }
        if (icon != null) {
            icon.paintIcon(jComponent, graphics, BasicJideLabelUI.paintIconR.x, BasicJideLabelUI.paintIconR.y);
        }
        if (string != null) {
            View view = (View)jComponent.getClientProperty("html");
            if (view != null) {
                view.paint(graphics, paintTextR);
            } else {
                int n2 = BasicJideLabelUI.paintTextR.x;
                int n3 = BasicJideLabelUI.paintTextR.y + fontMetrics.getAscent();
                if (jLabel.isEnabled()) {
                    this.paintEnabledText(jLabel, graphics, string2, n2, n3);
                } else {
                    this.paintDisabledText(jLabel, graphics, string2, n2, n3);
                }
            }
        }
        graphics2D.setTransform(affineTransform);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        if ("orientation" == propertyChangeEvent.getPropertyName()) {
            if (propertyChangeEvent.getSource() instanceof JLabel) {
                JLabel jLabel = (JLabel)propertyChangeEvent.getSource();
                jLabel.revalidate();
            }
        } else if ("clockwise".equals(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getSource() instanceof JLabel) {
            JLabel jLabel = (JLabel)propertyChangeEvent.getSource();
            jLabel.repaint();
        }
    }
}

