/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.aqua;

import com.jidesoft.plaf.aqua.AquaJideUtils;
import com.jidesoft.plaf.basic.BasicJideTabbedPaneUI;
import com.jidesoft.plaf.vsnet.VsnetJideTabbedPaneUI;
import com.jidesoft.swing.TabColorProvider;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class AquaJideTabbedPaneUI
extends VsnetJideTabbedPaneUI {
    private static final Color COLOR1 = new Color(130, 130, 130);
    private static final Color COLOR2 = new Color(86, 86, 86);
    private static final Color COLOR3 = new Color(252, 252, 252);

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaJideTabbedPaneUI();
    }

    @Override
    protected void paintTabBackground(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl2) {
        Color[] colorArray;
        super.paintTabBackground(graphics, n2, n3, n4, n5, n6, n7, bl2);
        if (this._tabPane.getTabColorProvider() != null && this._tabPane.getTabColorProvider().getBackgroundAt(n3) != null) {
            return;
        }
        if (n3 >= 0 && n3 < this._tabPane.getTabCount() && (colorArray = this._tabPane.getComponentAt(n3)) instanceof TabColorProvider && ((TabColorProvider)colorArray).getTabBackground() != null) {
            return;
        }
        if (!bl2) {
            return;
        }
        Color[] colorArray2 = colorArray = AquaJideUtils.isGraphite() ? AquaJideUtils.AQUA_GRAPHITE : AquaJideUtils.AQUA_BLUE;
        if (this.tabRegion != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            switch (n2) {
                case 2: {
                    AquaJideUtils.fillAquaGradientVertical(graphics2D, this.tabRegion, colorArray);
                    break;
                }
                case 4: {
                    AquaJideUtils.fillAquaGradientVertical(graphics2D, this.tabRegion, colorArray);
                    break;
                }
                case 3: {
                    AquaJideUtils.fillAquaGradientHorizontal(graphics2D, this.tabRegion, colorArray);
                    break;
                }
                default: {
                    AquaJideUtils.fillAquaGradientHorizontal(graphics2D, this.tabRegion, colorArray);
                }
            }
        }
    }

    @Override
    protected void paintFocusIndicator(Graphics graphics, int n2, Rectangle[] rectangleArray, int n3, Rectangle rectangle, Rectangle rectangle2, boolean bl2) {
    }

    @Override
    protected boolean isRoundedCorner() {
        return true;
    }

    protected boolean isShading() {
        return true;
    }

    @Override
    protected Color getBorderEdgeColor() {
        return this._shadow;
    }

    @Override
    protected BasicJideTabbedPaneUI.TabCloseButton createNoFocusButton(int n2) {
        return new AquaTabCloseButton(n2);
    }

    @Override
    protected void prepareEditor(BasicJideTabbedPaneUI.TabEditor tabEditor, int n2) {
        tabEditor.setOpaque(true);
        super.prepareEditor(tabEditor, n2);
    }

    public class AquaTabCloseButton
    extends BasicJideTabbedPaneUI.TabCloseButton {
        @Override
        public void updateUI() {
            super.updateUI();
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setFocusPainted(false);
        }

        public AquaTabCloseButton() {
            this(0);
        }

        public AquaTabCloseButton(int n2) {
            super(AquaJideTabbedPaneUI.this);
            this.addMouseMotionListener(this);
            this.addMouseListener(this);
            this.setContentAreaFilled(false);
            this.setType(n2);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(16, 16);
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(5, 5);
        }

        @Override
        public Dimension getMaximumSize() {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            if (!this.isEnabled()) {
                this.setMouseOver(false);
                this.setMousePressed(false);
            }
            AquaJideUtils.antialiasShape(graphics, true);
            Color color = graphics.getColor();
            if (this.isMouseOver() && this.isMousePressed()) {
                graphics.setColor(COLOR1);
                graphics.fillOval(2, 2, this.getWidth() - 4, this.getHeight() - 4);
                graphics.setColor(COLOR2);
            } else if (this.isMouseOver()) {
                graphics.setColor(COLOR1);
                graphics.fillOval(2, 2, this.getWidth() - 4, this.getHeight() - 4);
                graphics.setColor(COLOR3);
            } else {
                graphics.setColor(COLOR1);
            }
            int n2 = this.getWidth() >> 1;
            int n3 = this.getHeight() >> 1;
            switch (this.getType()) {
                case 0: {
                    if (this.isEnabled()) {
                        graphics.drawLine(n2 - 2, n3 - 2, n2 + 2, n3 + 2);
                        graphics.drawLine(n2 - 3, n3 - 2, n2 + 1, n3 + 2);
                        graphics.drawLine(n2 + 2, n3 - 2, n2 - 2, n3 + 2);
                        graphics.drawLine(n2 + 1, n3 - 2, n2 - 3, n3 + 2);
                        break;
                    }
                    graphics.drawLine(n2 - 3, n3 - 3, n2 + 3, n3 + 3);
                    graphics.drawLine(n2 + 3, n3 - 3, n2 - 3, n3 + 3);
                    break;
                }
                case 1: {
                    if (AquaJideTabbedPaneUI.this._tabPane.getTabPlacement() == 1 || AquaJideTabbedPaneUI.this._tabPane.getTabPlacement() == 3) {
                        int n4 = n2 + 2;
                        int n5 = n3;
                        if (this.isEnabled()) {
                            graphics.drawLine(n4 - 3, n5 - 3, n4 - 3, n5 + 3);
                            graphics.drawLine(n4 - 2, n5 - 2, n4 - 2, n5 + 2);
                            graphics.drawLine(n4 - 1, n5 - 1, n4 - 1, n5 + 1);
                            graphics.drawLine(n4, n5, n4, n5);
                            break;
                        }
                        graphics.drawLine(n4 - 3, n5 - 3, n4, n5);
                        graphics.drawLine(n4 - 3, n5 - 3, n4 - 3, n5 + 3);
                        graphics.drawLine(n4 - 3, n5 + 3, n4, n5);
                        break;
                    }
                    int n6 = n2;
                    int n7 = n3 + 2;
                    if (this.isEnabled()) {
                        graphics.drawLine(n6 - 3, n7 - 3, n6 + 3, n7 - 3);
                        graphics.drawLine(n6 - 2, n7 - 2, n6 + 2, n7 - 2);
                        graphics.drawLine(n6 - 1, n7 - 1, n6 + 1, n7 - 1);
                        graphics.drawLine(n6, n7, n6, n7);
                        break;
                    }
                    graphics.drawLine(n6 - 3, n7 - 3, n6, n7);
                    graphics.drawLine(n6 - 3, n7 - 3, n6 + 3, n7 - 3);
                    graphics.drawLine(n6 + 3, n7 - 3, n6, n7);
                    break;
                }
                case 2: {
                    if (AquaJideTabbedPaneUI.this._tabPane.getTabPlacement() == 1 || AquaJideTabbedPaneUI.this._tabPane.getTabPlacement() == 3) {
                        int n8 = n2 - 3;
                        int n9 = n3;
                        if (this.isEnabled()) {
                            graphics.drawLine(n8, n9, n8, n9);
                            graphics.drawLine(n8 + 1, n9 - 1, n8 + 1, n9 + 1);
                            graphics.drawLine(n8 + 2, n9 - 2, n8 + 2, n9 + 2);
                            graphics.drawLine(n8 + 3, n9 - 3, n8 + 3, n9 + 3);
                            break;
                        }
                        graphics.drawLine(n8, n9, n8 + 3, n9 - 3);
                        graphics.drawLine(n8, n9, n8 + 3, n9 + 3);
                        graphics.drawLine(n8 + 3, n9 - 3, n8 + 3, n9 + 3);
                        break;
                    }
                    int n10 = n2;
                    int n11 = n3 - 2;
                    if (this.isEnabled()) {
                        graphics.drawLine(n10, n11, n10, n11);
                        graphics.drawLine(n10 - 1, n11 + 1, n10 + 1, n11 + 1);
                        graphics.drawLine(n10 - 2, n11 + 2, n10 + 2, n11 + 2);
                        graphics.drawLine(n10 - 3, n11 + 3, n10 + 3, n11 + 3);
                        break;
                    }
                    graphics.drawLine(n10, n11, n10 - 3, n11 + 3);
                    graphics.drawLine(n10, n11, n10 + 3, n11 + 3);
                    graphics.drawLine(n10 - 3, n11 + 3, n10 + 3, n11 + 3);
                    break;
                }
                case 5: {
                    int n12 = n2;
                    int n13 = n3 + 2;
                    graphics.drawLine(n12 - 3, n13 - 3, n12 + 3, n13 - 3);
                    graphics.drawLine(n12 - 2, n13 - 2, n12 + 2, n13 - 2);
                    graphics.drawLine(n12 - 1, n13 - 1, n12 + 1, n13 - 1);
                    graphics.drawLine(n12, n13, n12, n13);
                    break;
                }
            }
            graphics.setColor(color);
            AquaJideUtils.antialiasShape(graphics, false);
        }

        @Override
        public boolean isOpaque() {
            return false;
        }
    }
}

