/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.dialog;

import com.jidesoft.dialog.AbstractDialogPage;
import com.jidesoft.dialog.MutableTreeNodeEx;
import com.jidesoft.dialog.TreeIconsFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;

public class DialogPageTreeCellRenderer
extends JLabel
implements TreeCellRenderer {
    private static final long serialVersionUID = 3680042627478398736L;
    private Color _selectedForeground;
    private Color _nonSelectedForeground;
    private Color _selectedBackground;
    private Color _nonSelectedBackground;
    private Color _selectedBorderColor;
    private Icon _selectedIcon;
    private Icon _blankIcon;
    private Icon _openIcon;
    private Icon _closedIcon;
    private Color _defaultTextSelectionColor = UIDefaultsLookup.getColor("Tree.selectionForeground");
    private Color _defaultTextNonSelectionColor = UIDefaultsLookup.getColor("Tree.textForeground");
    private Color _defaultBkSelectionColor = UIDefaultsLookup.getColor("Tree.selectionBackground");
    private Color _defaultBkNonSelectionColor = UIDefaultsLookup.getColor("Tree.textBackground");
    private Color _defaultBorderSelectionColor = UIDefaultsLookup.getColor("Tree.selectionBorderColor");
    private Icon _defaultOpenIcon = UIDefaultsLookup.getIcon("Tree.openIcon");
    private Icon _defaultClosedIcon = UIDefaultsLookup.getIcon("Tree.closedIcon");
    private boolean m_selected;
    private static final Icon SELECTED = TreeIconsFactory.getScaledIcon("icons/tree_selected_b16.png");
    private static final Icon BLANK = TreeIconsFactory.getScaledIcon("icons/tree_blank_16.png");

    public DialogPageTreeCellRenderer() {
        this.setOpaque(false);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl2, boolean bl3, boolean bl4, int n2, boolean bl5) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
        Object object2 = defaultMutableTreeNode.getUserObject();
        if (object2 instanceof Boolean) {
            this.setText("Retrieving data...");
        }
        if (object2 instanceof AbstractDialogPage) {
            AbstractDialogPage abstractDialogPage = (AbstractDialogPage)object2;
            this.setText(abstractDialogPage.getTitle());
        } else {
            this.setText(object2.toString());
            this.setIcon(null);
        }
        this.setFont(jTree.getFont());
        boolean bl6 = jTree.isEnabled();
        boolean bl7 = !(object instanceof MutableTreeNodeEx) || ((MutableTreeNodeEx)object).isEnabled();
        boolean bl8 = bl6 && bl7;
        this.setEnabled(bl8);
        if (!bl8) {
            bl2 = false;
        }
        this.setForeground(bl2 ? this.getSelectedForeground() : this.getNonSelectedForeground());
        this.setBackground(bl2 ? this.getSelectedBackground() : this.getNonSelectedBackground());
        if (bl4) {
            if (bl2) {
                this.setIcon(SELECTED);
            } else {
                this.setIcon(BLANK);
            }
        } else if (bl3) {
            this.setIcon(this.getOpenIcon());
        } else {
            this.setIcon(this.getClosedIcon());
        }
        this.m_selected = bl2;
        this.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        return this;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Color color = this.getBackground();
        Icon icon = this.getIcon();
        graphics.setColor(color);
        int n2 = 0;
        if (icon != null && this.getText() != null) {
            n2 = icon.getIconWidth() + this.getIconTextGap() - 1;
        }
        graphics.fillRect(n2, 0, this.getWidth() - 1 - n2, this.getHeight() - 1);
        if (this.m_selected) {
            graphics.setColor(this.getSelectedBorderColor());
            graphics.drawRect(n2, 0, this.getWidth() - n2 - 1, this.getHeight() - 1);
        }
        super.paintComponent(graphics);
    }

    public Color getSelectedForeground() {
        if (this._selectedForeground == null) {
            if (this._defaultTextSelectionColor == null) {
                this._defaultTextSelectionColor = UIDefaultsLookup.getColor("Tree.selectionForeground");
            }
            return this._defaultTextSelectionColor;
        }
        return this._selectedForeground;
    }

    public void setSelectedForeground(Color color) {
        this._selectedForeground = color;
    }

    public Color getNonSelectedForeground() {
        if (this._nonSelectedForeground == null) {
            if (this._defaultTextNonSelectionColor == null) {
                this._defaultTextNonSelectionColor = UIDefaultsLookup.getColor("Tree.textForeground");
            }
            return this._defaultTextNonSelectionColor;
        }
        return this._nonSelectedForeground;
    }

    public void setNonSelectedForeground(Color color) {
        this._nonSelectedForeground = color;
    }

    public Color getSelectedBackground() {
        if (this._selectedBackground == null) {
            if (this._defaultBkSelectionColor == null) {
                this._defaultBkSelectionColor = UIDefaultsLookup.getColor("Tree.selectionBackground");
            }
            return this._defaultBkSelectionColor;
        }
        return this._selectedBackground;
    }

    public void setSelectedBackground(Color color) {
        this._selectedBackground = color;
    }

    public Color getNonSelectedBackground() {
        if (this._nonSelectedBackground == null) {
            if (this._defaultBkNonSelectionColor == null) {
                this._defaultBkNonSelectionColor = UIDefaultsLookup.getColor("Tree.textBackground");
            }
            return this._defaultBkNonSelectionColor;
        }
        return this._nonSelectedBackground;
    }

    public void setNonSelectedBackground(Color color) {
        this._nonSelectedBackground = color;
    }

    public Color getSelectedBorderColor() {
        if (this._selectedBorderColor == null) {
            if (this._defaultBorderSelectionColor == null) {
                this._defaultBorderSelectionColor = UIDefaultsLookup.getColor("Tree.selectionBorderColor");
            }
            return this._defaultBorderSelectionColor;
        }
        return this._selectedBorderColor;
    }

    public void setSelectedBorderColor(Color color) {
        this._selectedBorderColor = color;
    }

    public Icon getSelectedIcon() {
        if (this._selectedIcon == null) {
            return SELECTED;
        }
        return this._selectedIcon;
    }

    public void setSelectedIcon(Icon icon) {
        this._selectedIcon = icon;
    }

    public Icon getBlankIcon() {
        if (this._blankIcon == null) {
            return BLANK;
        }
        return this._blankIcon;
    }

    public void setBlankIcon(Icon icon) {
        this._blankIcon = icon;
    }

    public Icon getOpenIcon() {
        if (this._openIcon == null) {
            if (this._defaultOpenIcon == null) {
                this._defaultOpenIcon = UIDefaultsLookup.getIcon("Tree.openIcon");
            }
            return this._defaultOpenIcon;
        }
        return this._openIcon;
    }

    public void setOpenIcon(Icon icon) {
        this._openIcon = icon;
    }

    public Icon getClosedIcon() {
        if (this._closedIcon == null) {
            if (this._defaultClosedIcon == null) {
                this._defaultClosedIcon = UIDefaultsLookup.getIcon("Tree.closedIcon");
            }
            return this._defaultClosedIcon;
        }
        return this._closedIcon;
    }

    public void setClosedIcon(Icon icon) {
        this._closedIcon = icon;
    }
}

