/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.aws.lw.client.xml;

import com.github.davidmoten.aws.lw.client.internal.util.Preconditions;
import com.github.davidmoten.aws.lw.client.xml.XmlParseException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;

public final class XmlElement {
    private List<XmlElement> children;
    private Map<String, String> attributes;
    private String name;
    private String content;
    private static final Map<String, char[]> ENTITIES = XmlElement.createEntities();
    private int lineNr;
    private final boolean ignoreLeadingAndTrailingWhitespace;
    private char charReadTooMuch;
    private Reader reader;
    private int parserLineNr;

    private XmlElement(boolean ignoreLeadingAndTrailingWhitespace) {
        this.ignoreLeadingAndTrailingWhitespace = ignoreLeadingAndTrailingWhitespace;
        this.name = null;
        this.content = "";
        this.attributes = new HashMap<String, String>();
        this.children = new ArrayList<XmlElement>();
        this.lineNr = 0;
    }

    public void addChild(XmlElement child) {
        this.children.add(child);
    }

    public int countChildren() {
        return this.children.size();
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public Set<String> attributeNames() {
        return this.attributes.keySet();
    }

    public List<XmlElement> children() {
        return this.children;
    }

    public List<XmlElement> childrenWithName(String name) {
        return this.children.stream().filter(x -> name.equals(x.name())).collect(Collectors.toList());
    }

    public XmlElement firstChild() {
        return this.children.get(0);
    }

    public XmlElement child(int index) {
        return this.children.get(index);
    }

    public XmlElement child(String ... names) {
        XmlElement x = this;
        XmlElement y = null;
        for (String name : names) {
            for (XmlElement child : x.children) {
                if (!child.name().equals(name)) continue;
                y = child;
            }
            if (y == null) {
                throw new NoSuchElementException("child not found with name: " + name);
            }
            x = y;
        }
        return y;
    }

    public String content(String ... names) {
        return this.child(names).content();
    }

    public String content() {
        return this.content;
    }

    public int lineNumber() {
        return this.lineNr;
    }

    public String attribute(String name) {
        return this.attribute(name, null);
    }

    public String attribute(String name, String defaultValue) {
        Preconditions.checkNotNull(name);
        return this.attributes.getOrDefault(name, defaultValue);
    }

    public String name() {
        return this.name;
    }

    public static XmlElement parse(Reader reader) throws XmlParseException, IOException {
        return XmlElement.parse(reader, true);
    }

    public static XmlElement parse(Reader reader, boolean ignoreLeadingAndTrailingWhitespace) throws IOException, XmlParseException {
        Preconditions.checkNotNull(reader);
        XmlElement x = new XmlElement(ignoreLeadingAndTrailingWhitespace);
        x.parseFromReader(reader);
        return x;
    }

    private void parseFromReader(Reader reader) throws IOException, XmlParseException {
        char ch;
        Preconditions.checkNotNull(reader);
        this.name = null;
        this.content = "";
        this.attributes = new HashMap<String, String>();
        this.children = new ArrayList<XmlElement>();
        this.charReadTooMuch = '\u0000';
        this.reader = reader;
        this.parserLineNr = 1;
        while (true) {
            if ((ch = this.scanWhitespace()) != '<') {
                throw this.createUnexpectedInputException("<");
            }
            ch = this.readChar();
            if (ch != '!' && ch != '?') break;
            this.skipSpecialTag(0);
        }
        this.unreadChar(ch);
        this.scanElement(this);
    }

    public static XmlElement parse(String string) throws XmlParseException {
        return XmlElement.parse(string, true);
    }

    public static XmlElement parse(String string, boolean ignoreLeadingAndTrailingWhitespace) throws XmlParseException {
        Preconditions.checkNotNull(string);
        return XmlElement.parseUnchecked(new StringReader(string), ignoreLeadingAndTrailingWhitespace);
    }

    static XmlElement parseUnchecked(Reader reader, boolean ignoreLeadingAndTrailingWhitespace) throws XmlParseException {
        try {
            return XmlElement.parse(reader, ignoreLeadingAndTrailingWhitespace);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private XmlElement createAnotherElement() {
        return new XmlElement(this.ignoreLeadingAndTrailingWhitespace);
    }

    public String toString() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);
        this.writeUnchecked(writer);
        return new String(out.toByteArray(), StandardCharsets.UTF_8);
    }

    void writeUnchecked(Writer writer) {
        try {
            this.write(writer);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    public void write(Writer writer) throws IOException {
        Preconditions.checkNotNull(writer);
        Preconditions.checkNotNull(this.name);
        Preconditions.checkNotNull(this.content);
        writer.write(60);
        writer.write(this.name);
        if (!this.attributes.isEmpty()) {
            Enumeration<String> en = Collections.enumeration(this.attributes.keySet());
            while (en.hasMoreElements()) {
                writer.write(32);
                String key = en.nextElement();
                String value = this.attributes.get(key);
                writer.write(key);
                writer.write(61);
                writer.write(34);
                XmlElement.writeEncoded(writer, value);
                writer.write(34);
            }
        }
        if (!this.content.isEmpty()) {
            writer.write(62);
            XmlElement.writeEncoded(writer, this.content);
            writer.write(60);
            writer.write(47);
            writer.write(this.name);
            writer.write(62);
        } else if (this.children.isEmpty()) {
            writer.write(47);
            writer.write(62);
        } else {
            writer.write(62);
            for (XmlElement child : this.children) {
                child.write(writer);
            }
            writer.write(60);
            writer.write(47);
            writer.write(this.name);
            writer.write(62);
        }
    }

    private static void writeEncoded(Writer writer, String str) throws IOException {
        block7: for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '<': {
                    writer.write(38);
                    writer.write(108);
                    writer.write(116);
                    writer.write(59);
                    continue block7;
                }
                case '>': {
                    writer.write(38);
                    writer.write(103);
                    writer.write(116);
                    writer.write(59);
                    continue block7;
                }
                case '&': {
                    writer.write(38);
                    writer.write(97);
                    writer.write(109);
                    writer.write(112);
                    writer.write(59);
                    continue block7;
                }
                case '\"': {
                    writer.write(38);
                    writer.write(113);
                    writer.write(117);
                    writer.write(111);
                    writer.write(116);
                    writer.write(59);
                    continue block7;
                }
                case '\'': {
                    writer.write(38);
                    writer.write(97);
                    writer.write(112);
                    writer.write(111);
                    writer.write(115);
                    writer.write(59);
                    continue block7;
                }
                default: {
                    char unicode = ch;
                    if (unicode < ' ' || unicode > '~') {
                        writer.write(38);
                        writer.write(35);
                        writer.write(120);
                        writer.write(Integer.toString(unicode, 16));
                        writer.write(59);
                        continue block7;
                    }
                    writer.write(ch);
                }
            }
        }
    }

    private void scanIdentifier(StringBuilder result) throws IOException {
        while (true) {
            char ch;
            if (!XmlElement.isValidIdentifierCharacter(ch = this.readChar())) {
                this.unreadChar(ch);
                return;
            }
            result.append(ch);
        }
    }

    static boolean isValidIdentifierCharacter(char ch) {
        return ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9' || ch == '_' || ch == '.' || ch == ':' || ch == '-' || ch > '~';
    }

    private char scanWhitespace() throws IOException {
        char ch;
        block3: while (true) {
            ch = this.readChar();
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
            }
            break;
        }
        return ch;
    }

    private char scanWhitespace(StringBuilder result) throws IOException {
        char ch;
        block4: while (true) {
            ch = this.readChar();
            switch (ch) {
                case '\t': 
                case '\n': 
                case ' ': {
                    result.append(ch);
                }
                case '\r': {
                    continue block4;
                }
            }
            break;
        }
        return ch;
    }

    private void scanString(StringBuilder string) throws IOException {
        char delimiter = this.readChar();
        if (delimiter != '\'' && delimiter != '\"') {
            throw this.createUnexpectedInputException("' or \"");
        }
        char ch;
        while ((ch = this.readChar()) != delimiter) {
            if (ch == '&') {
                this.resolveEntity(string);
                continue;
            }
            string.append(ch);
        }
        return;
    }

    private void scanPCData(StringBuilder data) throws IOException {
        while (true) {
            char ch;
            if ((ch = this.readChar()) == '<') {
                ch = this.readChar();
                if (ch == '!') {
                    this.checkCDATA(data);
                    continue;
                }
                this.unreadChar(ch);
                return;
            }
            if (ch == '&') {
                this.resolveEntity(data);
                continue;
            }
            data.append(ch);
        }
    }

    private boolean checkCDATA(StringBuilder buf) throws IOException {
        char ch = this.readChar();
        if (ch != '[') {
            this.unreadChar(ch);
            this.skipSpecialTag(0);
            return false;
        }
        if (!this.checkLiteral("CDATA[")) {
            this.skipSpecialTag(1);
            return false;
        }
        int delimiterCharsSkipped = 0;
        block4: while (delimiterCharsSkipped < 3) {
            int i;
            ch = this.readChar();
            switch (ch) {
                case ']': {
                    if (delimiterCharsSkipped < 2) {
                        ++delimiterCharsSkipped;
                        continue block4;
                    }
                    buf.append(']');
                    buf.append(']');
                    delimiterCharsSkipped = 0;
                    continue block4;
                }
                case '>': {
                    if (delimiterCharsSkipped < 2) {
                        for (i = 0; i < delimiterCharsSkipped; ++i) {
                            buf.append(']');
                        }
                        delimiterCharsSkipped = 0;
                        buf.append('>');
                        continue block4;
                    }
                    delimiterCharsSkipped = 3;
                    continue block4;
                }
            }
            for (i = 0; i < delimiterCharsSkipped; ++i) {
                buf.append(']');
            }
            buf.append(ch);
            delimiterCharsSkipped = 0;
        }
        return true;
    }

    private void skipComment() throws IOException {
        int dashesToRead = 2;
        while (dashesToRead > 0) {
            char ch = this.readChar();
            if (ch == '-') {
                --dashesToRead;
                continue;
            }
            dashesToRead = 2;
        }
        if (this.readChar() != '>') {
            throw this.createUnexpectedInputException(">");
        }
    }

    private void skipSpecialTag(int bracketLevel) throws IOException {
        char ch;
        int tagLevel = 1;
        char stringDelimiter = '\u0000';
        if (bracketLevel == 0) {
            ch = this.readChar();
            if (ch == '[') {
                ++bracketLevel;
            } else if (ch == '-') {
                ch = this.readChar();
                if (ch == '[') {
                    ++bracketLevel;
                } else if (ch == ']') {
                    --bracketLevel;
                } else if (ch == '-') {
                    this.skipComment();
                    return;
                }
            }
        }
        while (tagLevel > 0) {
            ch = this.readChar();
            if (stringDelimiter == '\u0000') {
                if (ch == '\"' || ch == '\'') {
                    stringDelimiter = ch;
                } else if (bracketLevel <= 0) {
                    if (ch == '<') {
                        ++tagLevel;
                    } else if (ch == '>') {
                        --tagLevel;
                    }
                }
                if (ch == '[') {
                    ++bracketLevel;
                    continue;
                }
                if (ch != ']') continue;
                --bracketLevel;
                continue;
            }
            if (ch != stringDelimiter) continue;
            stringDelimiter = '\u0000';
        }
    }

    private boolean checkLiteral(String literal) throws IOException {
        int length = literal.length();
        for (int i = 0; i < length; ++i) {
            if (this.readChar() == literal.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private char readChar() throws IOException {
        if (this.charReadTooMuch != '\u0000') {
            char ch = this.charReadTooMuch;
            this.charReadTooMuch = '\u0000';
            return ch;
        }
        int i = this.reader.read();
        if (i < 0) {
            throw this.createExceptionUnexpectedEndOfData();
        }
        if (i == 10) {
            ++this.parserLineNr;
            return '\n';
        }
        return (char)i;
    }

    private void scanElement(XmlElement elt) throws IOException {
        char ch;
        String name;
        StringBuilder buf;
        block22: {
            buf = new StringBuilder();
            this.scanIdentifier(buf);
            elt.name = name = buf.toString();
            ch = this.scanWhitespace();
            while (ch != '>' && ch != '/') {
                buf.setLength(0);
                this.unreadChar(ch);
                this.scanIdentifier(buf);
                String key = buf.toString();
                ch = this.scanWhitespace();
                if (ch != '=') {
                    throw this.createUnexpectedInputException("=");
                }
                this.unreadChar(this.scanWhitespace());
                buf.setLength(0);
                this.scanString(buf);
                elt.attributes.put(key, buf.toString());
                ch = this.scanWhitespace();
            }
            if (ch == '/') {
                ch = this.readChar();
                if (ch != '>') {
                    throw this.createUnexpectedInputException(">");
                }
                return;
            }
            buf.setLength(0);
            ch = this.scanWhitespace(buf);
            if (ch != '<') {
                this.unreadChar(ch);
                this.scanPCData(buf);
            } else {
                while ((ch = this.readChar()) == '!') {
                    if (this.checkCDATA(buf)) {
                        this.scanPCData(buf);
                    } else {
                        ch = this.scanWhitespace(buf);
                        if (ch == '<') continue;
                        this.unreadChar(ch);
                        this.scanPCData(buf);
                    }
                    break block22;
                }
                if (ch != '/' || this.ignoreLeadingAndTrailingWhitespace) {
                    buf.setLength(0);
                }
                if (ch == '/') {
                    this.unreadChar(ch);
                }
            }
        }
        if (buf.length() == 0) {
            while (ch != '/') {
                if (ch == '!') {
                    ch = this.readChar();
                    if (ch != '-') {
                        throw this.createUnexpectedInputException("Comment or Element");
                    }
                    ch = this.readChar();
                    if (ch != '-') {
                        throw this.createUnexpectedInputException("Comment or Element");
                    }
                    this.skipComment();
                } else {
                    this.unreadChar(ch);
                    XmlElement child = this.createAnotherElement();
                    this.scanElement(child);
                    elt.addChild(child);
                }
                ch = this.scanWhitespace();
                if (ch != '<') {
                    throw this.createUnexpectedInputException("<");
                }
                ch = this.readChar();
            }
            this.unreadChar(ch);
        } else {
            elt.content = this.ignoreLeadingAndTrailingWhitespace ? buf.toString().trim() : buf.toString();
        }
        ch = this.readChar();
        if (ch != '/') {
            throw this.createUnexpectedInputException("/");
        }
        this.unreadChar(this.scanWhitespace());
        if (!this.checkLiteral(name)) {
            throw this.createUnexpectedInputException(name);
        }
        if (this.scanWhitespace() != '>') {
            throw this.createUnexpectedInputException(">");
        }
    }

    private void resolveEntity(StringBuilder buf) throws IOException {
        char ch = '\u0000';
        StringBuilder keyBuf = new StringBuilder();
        while ((ch = this.readChar()) != ';') {
            keyBuf.append(ch);
        }
        String key = keyBuf.toString();
        if (key.charAt(0) == '#') {
            try {
                ch = key.charAt(1) == 'x' ? (char)Integer.parseInt(key.substring(2), 16) : (char)Integer.parseInt(key.substring(1), 10);
            }
            catch (NumberFormatException e) {
                throw this.createExceptionUnknownEntity(key);
            }
            buf.append(ch);
        } else {
            char[] value = ENTITIES.get(key);
            if (value == null) {
                throw this.createExceptionUnknownEntity(key);
            }
            buf.append(value);
        }
    }

    private void unreadChar(char ch) {
        this.charReadTooMuch = ch;
    }

    private XmlParseException createExceptionUnexpectedEndOfData() {
        String msg = "Unexpected end of data reached";
        return new XmlParseException(this.name(), this.parserLineNr, msg);
    }

    private XmlParseException createUnexpectedInputException(String charSet) {
        String msg = "Expected: " + charSet;
        return new XmlParseException(this.name(), this.parserLineNr, msg);
    }

    private XmlParseException createExceptionUnknownEntity(String name) {
        String msg = "Unknown or invalid entity: &" + name + ";";
        return new XmlParseException(this.name(), this.parserLineNr, msg);
    }

    private static Map<String, char[]> createEntities() {
        HashMap<String, char[]> map = new HashMap<String, char[]>();
        map.put("amp", new char[]{'&'});
        map.put("quot", new char[]{'\"'});
        map.put("apos", new char[]{'\''});
        map.put("lt", new char[]{'<'});
        map.put("gt", new char[]{'>'});
        return map;
    }
}

