/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.win32;

import com.install4j.api.actions.InstallAction;
import com.install4j.api.windows.RegistryRoot;
import com.install4j.api.windows.WinRegistry;
import com.install4j.runtime.beans.actions.registry.SetRegistryValueAction;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.ContextInt;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.platform.win32.Misc;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public class EnvVars {
    public static final String KEYNAME_GLOBAL = "SYSTEM\\CurrentControlSet\\Control\\Session Manager\\Environment";
    public static final String KEYNAME_USER = "Environment";
    public static final String AUTOEXEC_BAT = "c:\\autoexec.bat";

    public static void setWinNT(String key, String value, boolean userSpecific) throws IOException {
        EnvVars.setWinNT(key, value, userSpecific, false, false);
    }

    public static String getWinNT(String key, boolean userSpecific) throws IOException {
        RegistryRoot registryRoot;
        String keyName;
        if (HelperCommunication.getInstance().isElevatedHelper() && userSpecific) {
            return EnvVars.getWinNTUnelevated(key);
        }
        if (userSpecific) {
            keyName = KEYNAME_USER;
            registryRoot = RegistryRoot.HKEY_CURRENT_USER;
        } else {
            keyName = KEYNAME_GLOBAL;
            registryRoot = RegistryRoot.HKEY_LOCAL_MACHINE;
        }
        Object previousValue = WinRegistry.getValue(registryRoot, keyName, key);
        if (previousValue != null) {
            return previousValue.toString();
        }
        return null;
    }

    private static String getWinNTUnelevated(String key) {
        return HelperCommunication.getInstance().fetchString(ExecutionContext.UNELEVATED, context -> EnvVars.getWinNT(key, true));
    }

    public static List<InstallAction> set(String key, String value, boolean userSpecific, boolean append, boolean prepend) throws IOException {
        return EnvVars.setWinNT(key, value, userSpecific, append, prepend);
    }

    public static List<InstallAction> setWinNT(String key, String value, boolean userSpecific, boolean append, boolean prepend) throws IOException {
        SetRegistryValueAction action;
        RegistryRoot registryRoot;
        String keyName;
        if (HelperCommunication.getInstance().isElevatedHelper() && userSpecific) {
            return EnvVars.setWinNTUnelevated(key, value, append, prepend);
        }
        ContextInt context = ContextImpl.getSingleContextInt();
        if (userSpecific) {
            keyName = KEYNAME_USER;
            registryRoot = RegistryRoot.HKEY_CURRENT_USER;
        } else {
            keyName = KEYNAME_GLOBAL;
            registryRoot = RegistryRoot.HKEY_LOCAL_MACHINE;
        }
        ArrayList<InstallAction> rollbackActions = new ArrayList<InstallAction>();
        Object previousValue = WinRegistry.getValue(registryRoot, keyName, key);
        if (previousValue != null && value != null && !previousValue.toString().isEmpty()) {
            String previousString = previousValue.toString();
            String previousStringLC = previousString.toLowerCase(Locale.ENGLISH);
            String valueLC = value.toLowerCase(Locale.ENGLISH);
            if ((append || prepend) && (Objects.equals(previousStringLC, valueLC) || previousStringLC.startsWith(valueLC + ";") || previousStringLC.endsWith(";" + valueLC) || previousStringLC.contains(";" + valueLC + ";"))) {
                return rollbackActions;
            }
            if (append) {
                value = previousString + ";" + value;
            } else if (prepend) {
                value = value + ";" + previousString;
            }
        }
        if ((action = new SetRegistryValueAction(registryRoot, keyName, key, value, true)).execute(context)) {
            rollbackActions.add(action);
        }
        Misc.broadcastSettingChange();
        if (rollbackActions.isEmpty()) {
            throw new IOException("Could not access key");
        }
        return rollbackActions;
    }

    private static List<InstallAction> setWinNTUnelevated(String key, String value, boolean append, boolean prepend) {
        return HelperCommunication.getInstance().fetchObject(ExecutionContext.UNELEVATED, context -> EnvVars.setWinNT(key, value, true, append, prepend));
    }
}

