/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.registry;

import com.install4j.runtime.installer.helper.PreferencesUtil;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.registry.RegistryInterface;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.prefs.Preferences;

public class PreferencesRegistry
implements RegistryInterface {
    private static final String PATH_NAME = "/com/install4j/installations";

    @Override
    public void setValue(String name, String value) {
        PreferencesRegistry.setValueInt(name, value);
    }

    private static void setValueInt(String name, String value) {
        if (!PreferencesUtil.isDisableSystemRoot()) {
            Preferences node = Preferences.systemRoot().node(PATH_NAME);
            try {
                node.put(name, value);
                node.flush();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        HelperCommunication.getInstance().runAction(ExecutionContext.UNELEVATED, context -> {
            Preferences node = Preferences.userRoot().node(PATH_NAME);
            try {
                node.put(name, value);
                node.flush();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
    }

    @Override
    public String getValue(String name, boolean preferAllUsers) {
        Collection<Preferences> roots = PreferencesUtil.isDisableSystemRoot() ? Collections.singleton(Preferences.userRoot()) : (preferAllUsers ? Arrays.asList(Preferences.systemRoot(), Preferences.userRoot()) : Arrays.asList(Preferences.userRoot(), Preferences.systemRoot()));
        for (Preferences root : roots) {
            Preferences node = root.node(PATH_NAME);
            String ret = node.get(name, null);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    @Override
    public String getOtherBitnessValue(String valueName) {
        return null;
    }

    @Override
    public void deleteValue(String name) {
        PreferencesRegistry.deleteValueInt(name);
    }

    @Override
    public void sync() {
        try {
            if (!PreferencesUtil.isDisableSystemRoot()) {
                Preferences node = Preferences.systemRoot().node(PATH_NAME);
                try {
                    node.sync();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            HelperCommunication.getInstance().runAction(ExecutionContext.UNELEVATED, context -> {
                Preferences node = Preferences.userRoot().node(PATH_NAME);
                try {
                    node.sync();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static void deleteValueInt(String name) {
        if (!PreferencesUtil.isDisableSystemRoot()) {
            Preferences node = Preferences.systemRoot().node(PATH_NAME);
            node.remove(name);
            try {
                node.flush();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        HelperCommunication.getInstance().runAction(ExecutionContext.UNELEVATED, context -> {
            Preferences node = Preferences.userRoot().node(PATH_NAME);
            node.remove(name);
            try {
                node.flush();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
    }
}

