/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.formcomponents.AbstractFormComponent;
import com.install4j.api.formcomponents.FormComponent;
import com.install4j.api.formcomponents.FormEnvironment;
import com.install4j.api.formcomponents.LayoutGroup;
import com.install4j.runtime.beans.formcomponents.CoupledComponentsHolder;
import com.install4j.runtime.installer.helper.Logger;
import java.awt.EventQueue;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;

public class CoupledComponentsUtil {
    private static LinkedList<FormComponent> couplingStack = new LinkedList();

    public static void migrateCoupledIds(CoupledComponentsHolder couplesComponentsHolder, Map<String, String> oldItToNewId) {
        ListIterator<String> it = couplesComponentsHolder.getCoupledComponentIds().listIterator();
        while (it.hasNext()) {
            String oldId = it.next();
            String newId = oldItToNewId.get(oldId);
            if (newId == null) {
                it.remove();
                continue;
            }
            it.set(newId);
        }
    }

    public static void enableCoupledComponents(CoupledComponentsHolder coupledComponentsHolder) {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(() -> CoupledComponentsUtil.enableCoupledComponentsUnguarded(coupledComponentsHolder));
        } else {
            CoupledComponentsUtil.enableCoupledComponentsUnguarded(coupledComponentsHolder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void enableCoupledComponentsUnguarded(CoupledComponentsHolder coupledComponentsHolder) {
        AbstractFormComponent coupledComponentsHolderComponent = (AbstractFormComponent)((Object)coupledComponentsHolder);
        if (couplingStack.contains(coupledComponentsHolderComponent)) {
            CoupledComponentsUtil.reportCyclicCoupling(coupledComponentsHolderComponent);
        } else {
            couplingStack.push(coupledComponentsHolderComponent);
            try {
                Boolean enabled = coupledComponentsHolder.isEnableCoupledComponents();
                if (enabled == null) {
                    return;
                }
                if (!coupledComponentsHolder.isEnabled()) {
                    enabled = Boolean.FALSE;
                } else if (coupledComponentsHolder.isInverseCoupling()) {
                    enabled = enabled != false ? Boolean.FALSE : Boolean.TRUE;
                }
                for (String id : coupledComponentsHolder.getCoupledComponentIds()) {
                    FormEnvironment formEnvironment = coupledComponentsHolderComponent.getFormEnvironment();
                    FormComponent formComponent = formEnvironment.getFormComponentById(id);
                    if (formComponent != null) {
                        formComponent.setEnabled(enabled);
                        continue;
                    }
                    LayoutGroup layoutGroup = formEnvironment.getLayoutGroupById(id);
                    if (layoutGroup == null) continue;
                    layoutGroup.setEnabled(enabled);
                }
            }
            finally {
                couplingStack.pop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reportCyclicCoupling(AbstractFormComponent coupledComponentsHolderComponent) {
        couplingStack.push(coupledComponentsHolderComponent);
        try {
            FormEnvironment formEnvironment = coupledComponentsHolderComponent.getFormEnvironment();
            StringBuilder message = new StringBuilder();
            message.append("Cyclic form component coupling has been detected: [");
            boolean first = true;
            for (FormComponent formComponent : couplingStack) {
                if (first) {
                    first = false;
                } else {
                    message.append(", ");
                }
                message.append("ID ").append(formEnvironment.getId(formComponent));
            }
            message.append(", ...]");
            Logger.getInstance().log(null, message.toString(), false);
        }
        finally {
            couplingStack.pop();
        }
    }
}

