package com.install4j.api.context;

/**
 * Exception that is thrown if a method is called that is not supported for elevated actions.
 * Actions are elevated if their "Action elevation" type results to "Elevate to maximum available privileges" and
 * the "Request privileges" action has started an elevated helper process.
 * <p>
 * This exception is always declared in method signatures in the API.
 * </p>
 *
 * @author ej-technologies GmbH
 */
public class NotSupportedInElevationException extends RuntimeException {
    public NotSupportedInElevationException() {
        super("The method is not available in the elevated helper process");
    }
}
