package com.install4j.api.beaninfo;

import com.install4j.api.actions.Action;
import com.install4j.api.beans.ActionList;

import java.util.List;

/**
 * Validates actions if the validation depends on a containing {@link ActionList} property.
 * The implementing class is stored in the  {@link ActionBeanInfo#ATTRIBUTE_ACTION_VALIDATOR} value of an
 * action bean descriptor.
 * <p>With an action validator, you can check at design-time if the values of the bean properties are valid
 * and notify the user if this is not the case. This only differs from a {@link BeanValidator} in that you are
 * also supplied with a list of action keys that were configured for an {@link ActionList} property that contains
 * the validated action.
 * @see BeanInitializer
 */
public interface ActionValidator {
    /**
     * Called by the install4j GUI at design-time to check the validity of the bean properties.
     * This method is called repeatedly when the user switches between different actions as well
     * as by the compiler.
     * @param action the action that should be validated
     * @param actionKeys the action keys configured for the {@link ActionList} property by calling
     *                   {@link ActionListPropertyDescriptor#setActionKeys(String[])}
     * @throws BeanValidationException Throw this exception if the bean properties are not valid
     */
    void validateAction(Action action, List<String> actionKeys) throws BeanValidationException;
}
