/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.customizers.programgroup;

import com.ejt.internal.gui.fl;
import com.ejt.internal.gui.s;
import com.ejt.internal.gui.w.i;
import com.install4j.c.d.b.d.p;
import com.install4j.c.d.b.m;
import com.install4j.runtime.beans.customizers.programgroup.ProgramGroupDefinitionTree;
import com.install4j.runtime.beans.customizers.programgroup.ProgramGroupEntryDialog;
import com.install4j.runtime.beans.screens.components.ProgramGroupFileConfig;
import com.install4j.runtime.filechooser.FileSystemChooserType;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;

public class ProgramGroupFileDialog
extends ProgramGroupEntryDialog<ProgramGroupFileConfig> {
    public static final String TARGET_FILE_TEXT_FIELD_NAME = "targetFileTextField";
    public static final String ARGUMENTS_TEXT_FIELD_NAME = "argumentsTextField";
    public static final String RUN_AS_ADMINISTRATOR_CHECKBOX_NAME = "runAsAdministratorCheckbox";
    private String[] ALL_SUFFIXES = new String[]{"*"};
    private JTextField txtTarget;
    private JTextField txtArguments;
    private JCheckBox chkRunAsAdministrator;

    public ProgramGroupFileDialog(ProgramGroupDefinitionTree programGroupDefinitionTree) {
        super(programGroupDefinitionTree);
    }

    @Override
    protected String getTitleText() {
        return "Edit Start Menu File Link";
    }

    @Override
    protected void setupControls() {
        super.setupControls();
        this.txtTarget = new i();
        this.txtTarget.setName(TARGET_FILE_TEXT_FIELD_NAME);
        this.txtArguments = new i();
        this.txtArguments.setName(ARGUMENTS_TEXT_FIELD_NAME);
        this.chkRunAsAdministrator = new JCheckBox("Run as administrator");
        this.chkRunAsAdministrator.setName(RUN_AS_ADMINISTRATOR_CHECKBOX_NAME);
    }

    @Override
    protected JComponent createCenterPanel() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("insets 0, wrap", "[][fill, grow]", "[][][]para[][][]unrel"));
        jPanel.add((Component)new fl("Mandatory settings"), "spanx, growx");
        jPanel.add(new JLabel("Display name:"));
        jPanel.add(this.wrapTextField(this.getNameTextField()));
        jPanel.add(new JLabel("Target file:"));
        jPanel.add(this.createFileChooserButton(this.txtTarget, new TargetFileChooserProvider()));
        jPanel.add((Component)new fl("Optional settings"), "spanx, growx");
        jPanel.add(new JLabel("Display icon:"));
        jPanel.add(this.createFileChooserButton(this.getIconTextField(), new ProgramGroupEntryDialog.IconFileChooserProvider()));
        jPanel.add(new JLabel("Arguments:"));
        jPanel.add(this.wrapTextField(this.txtArguments));
        jPanel.add((Component)this.chkRunAsAdministrator, "spanx");
        return jPanel;
    }

    @Override
    public void setConfig(ProgramGroupFileConfig programGroupFileConfig, p p2) {
        super.setConfig(programGroupFileConfig, p2);
        this.txtTarget.setText(this.fileToString(programGroupFileConfig.getTarget()));
        this.txtArguments.setText(programGroupFileConfig.getArguments());
        this.chkRunAsAdministrator.setSelected(programGroupFileConfig.isRunAsAdministrator());
    }

    @Override
    protected boolean validateInput() {
        return super.validateInput() && !this.checkEmpty(this.txtTarget, "target file");
    }

    @Override
    protected void saveConfig(ProgramGroupFileConfig programGroupFileConfig) {
        super.saveConfig(programGroupFileConfig);
        this.checkModified(this.txtTarget, programGroupFileConfig.getTarget());
        this.checkModified(this.txtArguments, programGroupFileConfig.getArguments());
        this.checkModified(this.chkRunAsAdministrator, programGroupFileConfig.isRunAsAdministrator());
        programGroupFileConfig.setTarget(this.stringToFile(this.txtTarget.getText()));
        programGroupFileConfig.setArguments(this.txtArguments.getText().trim());
        programGroupFileConfig.setRunAsAdministrator(this.chkRunAsAdministrator.isSelected());
    }

    private class TargetFileChooserProvider
    implements m {
        private TargetFileChooserProvider() {
        }

        @Override
        public File chooseFile(ActionEvent actionEvent) {
            return this.chooseFile(actionEvent, FileSystemChooserType.FILES);
        }

        @Override
        public File newFile(ActionEvent actionEvent) {
            throw new UnsupportedOperationException();
        }

        @Override
        public File chooseFile(ActionEvent actionEvent, FileSystemChooserType fileSystemChooserType) {
            return switch (fileSystemChooserType) {
                default -> throw new MatchException(null, null);
                case FileSystemChooserType.FILES -> s.b(ProgramGroupFileDialog.this, null, "Choose start menu entry", ProgramGroupFileDialog.this.ALL_SUFFIXES, "All files", ProgramGroupFileDialog.this.getDefinitionTree().getCustomizer().getFrame().d(false), null);
                case FileSystemChooserType.DIRECTORIES -> s.a(ProgramGroupFileDialog.this, null, "Choose start menu entry", ProgramGroupFileDialog.this.getDefinitionTree().getCustomizer().getFrame().e(false));
            };
        }

        @Override
        public boolean isDirectoryOrFile(ActionEvent actionEvent) {
            return true;
        }
    }
}

