/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.aws.lw.client;

import com.github.davidmoten.aws.lw.client.BaseUrlFactory;
import com.github.davidmoten.aws.lw.client.Client;
import com.github.davidmoten.aws.lw.client.HttpMethod;
import com.github.davidmoten.aws.lw.client.RequestHelper;
import com.github.davidmoten.aws.lw.client.Response;
import com.github.davidmoten.aws.lw.client.ResponseInputStream;
import com.github.davidmoten.aws.lw.client.ServiceException;
import com.github.davidmoten.aws.lw.client.internal.Retries;
import com.github.davidmoten.aws.lw.client.internal.util.Preconditions;
import com.github.davidmoten.aws.lw.client.internal.util.Util;
import com.github.davidmoten.aws.lw.client.xml.XmlElement;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public final class Request {
    private final Client client;
    private Optional<String> region;
    private String url;
    private HttpMethod method = HttpMethod.GET;
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private byte[] requestBody;
    private int connectTimeoutMs;
    private int readTimeoutMs;
    private int attributeNumber = 1;
    private Retries<ResponseInputStream> retries;
    private String attributePrefix = "Attribute";
    private String[] pathSegments;
    private final List<NameValue> queries = new ArrayList<NameValue>();
    private boolean signPayload = true;

    Request(Client client, String url, String ... pathSegments) {
        this.client = client;
        this.url = url;
        this.pathSegments = pathSegments;
        this.region = client.region();
        this.connectTimeoutMs = client.connectTimeoutMs();
        this.readTimeoutMs = client.readTimeoutMs();
        this.retries = client.retries().copy();
    }

    public Request method(HttpMethod method) {
        Preconditions.checkNotNull(method);
        this.method = method;
        return this;
    }

    public Request query(String name, String value) {
        Preconditions.checkNotNull(name);
        this.queries.add(new NameValue(name, value));
        return this;
    }

    public Request query(String name) {
        return this.query(name, null);
    }

    public Request attributePrefix(String attributePrefix) {
        this.attributePrefix = attributePrefix;
        this.attributeNumber = 1;
        return this;
    }

    public Request attribute(String name, String value) {
        int i = this.attributeNumber++;
        return this.query(this.attributePrefix + "." + i + ".Name", name).query(this.attributePrefix + "." + i + ".Value", value);
    }

    public Request header(String name, String value) {
        Preconditions.checkNotNull(name);
        Preconditions.checkNotNull(value);
        RequestHelper.put(this.headers, name, value);
        return this;
    }

    public Request signPayload(boolean signPayload) {
        this.signPayload = signPayload;
        return this;
    }

    public Request unsignedPayload() {
        return this.signPayload(false);
    }

    public Request metadata(String key, String value) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(value);
        return this.header("x-amz-meta-" + Util.canonicalMetadataKey(key), value);
    }

    public Request requestBody(byte[] requestBody) {
        Preconditions.checkNotNull(requestBody);
        this.requestBody = requestBody;
        return this;
    }

    public Request requestBody(String requestBody) {
        Preconditions.checkNotNull(requestBody);
        return this.requestBody(requestBody.getBytes(StandardCharsets.UTF_8));
    }

    public Request region(String region) {
        Preconditions.checkNotNull(region);
        this.region = Optional.of(region);
        return this;
    }

    public Request connectTimeout(long duration, TimeUnit unit) {
        Preconditions.checkArgument(duration >= 0L, "duration cannot be negative");
        Preconditions.checkNotNull(unit, "unit cannot be null");
        this.connectTimeoutMs = (int)unit.toMillis(duration);
        return this;
    }

    public Request readTimeout(long duration, TimeUnit unit) {
        Preconditions.checkArgument(duration >= 0L, "duration cannot be negative");
        Preconditions.checkNotNull(unit, "unit cannot be null");
        this.readTimeoutMs = (int)unit.toMillis(duration);
        return this;
    }

    public Request retryInitialInterval(long duration, TimeUnit unit) {
        Preconditions.checkArgument(duration >= 0L, "duration cannot be negative");
        Preconditions.checkNotNull(unit, "unit cannot be null");
        this.retries = this.retries.withInitialIntervalMs(unit.toMillis(duration));
        return this;
    }

    public Request retryMaxAttempts(int maxAttempts) {
        Preconditions.checkArgument(maxAttempts >= 0, "retryMaxAttempts cannot be negative");
        this.retries = this.retries.withMaxAttempts(maxAttempts);
        return this;
    }

    public Request retryJitter(double jitter) {
        Preconditions.checkArgument(jitter >= 0.0 && jitter <= 1.0, "jitter must be between 0 and 1");
        this.retries = this.retries.withJitter(jitter);
        return this;
    }

    public Request retryBackoffFactor(double factor) {
        Preconditions.checkArgument(factor >= 0.0, "retryBackoffFactor cannot be negative");
        this.retries = this.retries.withBackoffFactor(factor);
        return this;
    }

    public Request retryMaxInterval(long duration, TimeUnit unit) {
        Preconditions.checkArgument(duration >= 0L, "duration cannot be negative");
        Preconditions.checkNotNull(unit, "unit cannot be null");
        this.retries = this.retries.withMaxIntervalMs(unit.toMillis(duration));
        return this;
    }

    public ResponseInputStream responseInputStream() {
        String u = Request.calculateUrl(this.url, this.client.serviceName(), this.region, this.queries, Arrays.asList(this.pathSegments), this.client.baseUrlFactory());
        return this.retries.call(() -> RequestHelper.request(this.client.clock(), this.client.httpClient(), u, this.method, RequestHelper.combineHeaders(this.headers), this.requestBody, this.client.serviceName(), this.region, this.client.credentials(), this.connectTimeoutMs, this.readTimeoutMs, this.signPayload));
    }

    public Response response() {
        ResponseInputStream r = this.responseInputStream();
        byte[] bytes = Request.hasBody(r) ? Util.readBytesAndClose(r) : new byte[]{};
        return new Response(r.headers(), bytes, r.statusCode());
    }

    public Response responseExpectStatusCode(int expectedStatusCode) {
        Response r = this.response();
        if (r.statusCode() == expectedStatusCode) {
            return r;
        }
        throw new ServiceException(r.statusCode(), r.contentUtf8());
    }

    static boolean hasBody(ResponseInputStream r) {
        return r.header("Content-Length").isPresent() || r.header("Transfer-Encoding").orElse("").equalsIgnoreCase("chunked");
    }

    private static String calculateUrl(String url, String serviceName, Optional<String> region, List<NameValue> queries, List<String> pathSegments, BaseUrlFactory baseUrlFactory) {
        String u = url;
        if (u == null) {
            String baseUrl = baseUrlFactory.create(serviceName, region);
            Preconditions.checkNotNull(baseUrl, "baseUrl cannot be null");
            u = Request.trimAndEnsureHasTrailingSlash(baseUrl) + pathSegments.stream().map(x -> Request.trimAndRemoveLeadingAndTrailingSlashes(x)).collect(Collectors.joining("/"));
        }
        for (NameValue nv : queries) {
            if (!u.contains("?")) {
                u = u + "?";
            }
            if (!u.endsWith("?")) {
                u = u + "&";
            }
            if (nv.value != null) {
                u = u + Util.urlEncode(nv.name, false) + "=" + Util.urlEncode(nv.value, false);
                continue;
            }
            u = u + Util.urlEncode(nv.name, false);
        }
        return u;
    }

    static String trimAndEnsureHasTrailingSlash(String s) {
        String r = s.trim();
        if (r.endsWith("/")) {
            return r;
        }
        return r + "/";
    }

    public byte[] responseAsBytes() {
        Response r = this.response();
        Optional<? extends RuntimeException> exception = this.client.exceptionFactory().create(r);
        if (!exception.isPresent()) {
            return r.content();
        }
        throw exception.get();
    }

    public boolean exists() {
        return this.response().exists();
    }

    public void execute() {
        this.responseAsBytes();
    }

    public String responseAsUtf8() {
        return new String(this.responseAsBytes(), StandardCharsets.UTF_8);
    }

    public XmlElement responseAsXml() {
        return XmlElement.parse(this.responseAsUtf8());
    }

    public String presignedUrl(long expiryDuration, TimeUnit unit) {
        String u = Request.calculateUrl(this.url, this.client.serviceName(), this.region, this.queries, Arrays.asList(this.pathSegments), this.client.baseUrlFactory());
        return RequestHelper.presignedUrl(this.client.clock(), u, this.method.toString(), RequestHelper.combineHeaders(this.headers), this.requestBody, this.client.serviceName(), this.region, this.client.credentials(), this.connectTimeoutMs, this.readTimeoutMs, unit.toSeconds(expiryDuration), this.signPayload);
    }

    static String trimAndRemoveLeadingAndTrailingSlashes(String s) {
        Preconditions.checkNotNull(s);
        s = s.trim();
        if (s.startsWith("/")) {
            s = s.substring(1);
        }
        if (s.endsWith("/")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    private static final class NameValue {
        final String name;
        final String value;

        NameValue(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

