/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.ResizableMouseInputAdapter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.event.MouseInputListener;

public class Resizable {
    public static final int NONE = 0;
    public static final int UPPER_LEFT = 1;
    public static final int UPPER = 2;
    public static final int UPPER_RIGHT = 4;
    public static final int RIGHT = 8;
    public static final int LOWER_RIGHT = 16;
    public static final int LOWER = 32;
    public static final int LOWER_LEFT = 64;
    public static final int LEFT = 128;
    public static final int ALL = 255;
    private int _resizableCorners = 255;
    private int _resizeCornerSize = 16;
    public static final String PROPERTY_RESIZABLE_CORNERS = "resizableCorner";
    public static final String PROPERTY_RESIZE_CORNER_SIZE = "resizeCornerSize";
    protected final JComponent _component;
    private Insets _resizeInsets;
    private MouseInputListener _mouseInputAdapter;
    private int _snapGridSize = 1;
    private boolean _topLevel;

    public Resizable(JComponent jComponent) {
        this._component = jComponent;
        this.installListeners();
    }

    public int getResizableCorners() {
        return this._resizableCorners;
    }

    public void setResizableCorners(int n2) {
        if (this._resizableCorners != n2) {
            int n3 = this._resizableCorners;
            this._resizableCorners = n2;
            this._component.firePropertyChange(PROPERTY_RESIZABLE_CORNERS, n3, this._resizableCorners);
        }
    }

    public int getResizeCornerSize() {
        return this._resizeCornerSize;
    }

    public void setResizeCornerSize(int n2) {
        if (this._resizeCornerSize != n2) {
            int n3 = this._resizeCornerSize;
            this._resizeCornerSize = n2;
            this._component.firePropertyChange(PROPERTY_RESIZE_CORNER_SIZE, n3, this._resizeCornerSize);
        }
    }

    protected void installListeners() {
        this._mouseInputAdapter = this.createMouseInputListener();
        this._component.addMouseListener(this._mouseInputAdapter);
        this._component.addMouseMotionListener(this._mouseInputAdapter);
    }

    public void uninstallListeners() {
        this._component.removeMouseListener(this._mouseInputAdapter);
        this._component.removeMouseMotionListener(this._mouseInputAdapter);
        this._mouseInputAdapter = null;
    }

    protected MouseInputListener createMouseInputListener() {
        return new ResizableMouseInputAdapter(this);
    }

    public MouseInputListener getMouseInputAdapter() {
        return this._mouseInputAdapter;
    }

    public void beginResizing(int n2) {
    }

    public void resizing(int n2, int n3, int n4, int n5, int n6) {
        Dimension dimension = this._component.getMinimumSize();
        Dimension dimension2 = this._component.getMaximumSize();
        if (n5 < dimension.width) {
            n5 = dimension.width;
        }
        if (n6 < dimension.height) {
            n5 = dimension.height;
        }
        if (n5 > dimension2.width) {
            n5 = dimension2.width;
        }
        if (n6 > dimension2.height) {
            n6 = dimension2.height;
        }
        this._component.setPreferredSize(new Dimension(n5, n6));
        this._component.getParent().doLayout();
    }

    public void endResizing(int n2) {
    }

    public boolean isTopLevel() {
        return this._topLevel;
    }

    public void setTopLevel(boolean bl2) {
        this._topLevel = bl2;
    }

    public JComponent getComponent() {
        return this._component;
    }

    public Insets getResizeInsets() {
        if (this._resizeInsets != null) {
            return this._resizeInsets;
        }
        return this.getComponent().getInsets();
    }

    public void setResizeInsets(Insets insets) {
        this._resizeInsets = insets;
    }

    public int getSnapGridSize() {
        return this._snapGridSize;
    }

    public void setSnapGridSize(int n2) {
        this._snapGridSize = n2;
    }

    public static class ResizeCorner
    extends JComponent {
        static final int SIZE = 16;
        private int _corner = 16;

        public ResizeCorner() {
        }

        public ResizeCorner(int n2) {
            this._corner = n2;
        }

        public int getCorner() {
            return this._corner;
        }

        public void setCorner(int n2) {
            this._corner = n2;
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(16, 16);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            int n2 = Math.min(this.getWidth(), this.getHeight());
            int n3 = Math.min(n2 / 4, 4);
            Color color = graphics.getColor();
            int n4 = this.getCorner();
            boolean bl2 = this.getComponentOrientation().isLeftToRight();
            switch (n4) {
                case 16: {
                    int n5;
                    graphics.setColor(UIDefaultsLookup.getColor("controlLtHighlight"));
                    int n6 = 0;
                    for (n5 = 0; n5 < n3; ++n5) {
                        n6 += 4;
                        if (bl2) {
                            graphics.drawLine(n2, n2 - n6, n2 - n6, n2);
                            continue;
                        }
                        graphics.drawLine(0, n6, n2 - n6, n2);
                    }
                    graphics.setColor(UIDefaultsLookup.getColor("controlShadow"));
                    n6 = 0;
                    for (n5 = 0; n5 < n3; ++n5) {
                        n6 += 4;
                        if (bl2) {
                            graphics.drawLine(n2, n2 - n6 + 1, n2 - n6 + 1, n2);
                            graphics.drawLine(n2, n2 - n6 + 2, n2 - n6 + 2, n2);
                            continue;
                        }
                        graphics.drawLine(0, n6 + 1, n2 - n6 - 1, n2);
                        graphics.drawLine(0, n6 + 2, n2 - n6 - 2, n2);
                    }
                    break;
                }
                case 4: {
                    int n7;
                    graphics.setColor(UIDefaultsLookup.getColor("controlLtHighlight"));
                    int n8 = 0;
                    for (n7 = 0; n7 < n3; ++n7) {
                        n8 += 4;
                        if (bl2) {
                            graphics.drawLine(n2 - n8, 0, n2, n8);
                            continue;
                        }
                        graphics.drawLine(n8, 0, n2, n2 - n8);
                    }
                    graphics.setColor(UIDefaultsLookup.getColor("controlShadow"));
                    n8 = 0;
                    for (n7 = 0; n7 < n3; ++n7) {
                        n8 += 4;
                        if (bl2) {
                            graphics.drawLine(n2 - n8 + 1, 0, n2, n8 - 1);
                            graphics.drawLine(n2 - n8 + 2, 0, n2, n8 - 2);
                            continue;
                        }
                        graphics.drawLine(n8 + 1, 0, n2, n2 - n8 - 1);
                        graphics.drawLine(n8 + 2, 0, n2, n2 - n8 - 2);
                    }
                    break;
                }
            }
            graphics.setColor(color);
        }
    }
}

