/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.range;

import com.jidesoft.range.AbstractRange;
import com.jidesoft.range.Range;

public class BooleanRange
extends AbstractRange<Boolean> {
    private Boolean _lower = false;
    private Boolean _upper = true;

    public BooleanRange(boolean bl2, boolean bl3) {
        this.adjust(bl2, bl3);
    }

    @Override
    public Range<Boolean> createIntermediate(Range<Boolean> range, double d2) {
        return null;
    }

    @Override
    public Boolean lower() {
        return this._lower;
    }

    @Override
    public Boolean upper() {
        return this._upper;
    }

    @Override
    public void adjust(Boolean bl2, Boolean bl3) {
        this.setMin(bl2);
        this.setMax(bl3);
    }

    protected void setMin(boolean bl2) {
        boolean bl3 = this._lower;
        this._lower = bl2;
        this.firePropertyChange("min", bl3, this._lower);
    }

    protected void setMax(boolean bl2) {
        boolean bl3 = this._upper;
        this._upper = bl2;
        this.firePropertyChange("max", bl3, this._upper);
    }

    @Override
    public double minimum() {
        throw new UnsupportedOperationException("minimum() is not implemented in StringRange");
    }

    @Override
    public double maximum() {
        throw new UnsupportedOperationException("maximum() is not implemented in StringRange");
    }

    @Override
    public double size() {
        return this._lower.compareTo(this._upper);
    }

    @Override
    public boolean contains(Boolean bl2) {
        if (bl2 == null) {
            return false;
        }
        return bl2.compareTo(this.lower()) >= 0 && bl2.compareTo(this.upper()) <= 0;
    }

    public String toString() {
        return "BooleanRange{lower='" + this._lower + "', upper='" + this._upper + "'}";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BooleanRange)) {
            return false;
        }
        BooleanRange booleanRange = (BooleanRange)object;
        if (this._lower != null ? !this._lower.equals(booleanRange._lower) : booleanRange._lower != null) {
            return false;
        }
        return !(this._upper != null ? !this._upper.equals(booleanRange._upper) : booleanRange._upper != null);
    }

    public int hashCode() {
        int n2 = this._lower != null ? this._lower.hashCode() : 0;
        n2 = 31 * n2 + (this._upper != null ? this._upper.hashCode() : 0);
        return n2;
    }
}

