/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.BasicJideButtonListener;
import com.jidesoft.plaf.basic.BasicJideComboBoxUI;
import com.jidesoft.plaf.basic.ThemePainter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.CellRendererPane;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;

public class BasicJideComboBoxButton
extends JButton {
    protected JComboBox _comboBox;
    protected JList _listBox;
    protected CellRendererPane _rendererPane;
    protected Icon _comboIcon;
    protected boolean _iconOnly = false;

    public final JComboBox getComboBox() {
        return this._comboBox;
    }

    public final void setComboBox(JComboBox jComboBox) {
        this._comboBox = jComboBox;
    }

    public final Icon getComboIcon() {
        return this._comboIcon;
    }

    public final void setComboIcon(Icon icon) {
        this._comboIcon = icon;
    }

    public final boolean isIconOnly() {
        return this._iconOnly;
    }

    public final void setIconOnly(boolean bl2) {
        this._iconOnly = bl2;
    }

    public BasicJideComboBoxButton() {
        super("");
        this.addMouseListener(new BasicJideButtonListener(this));
        DefaultButtonModel defaultButtonModel = new DefaultButtonModel(){
            private static final long serialVersionUID = -5866286842846125926L;

            @Override
            public void setArmed(boolean bl2) {
                super.setArmed(this.isPressed() || bl2);
            }
        };
        this.setModel(defaultButtonModel);
        this.customizeButton();
    }

    public BasicJideComboBoxButton(JComboBox jComboBox, Icon icon, CellRendererPane cellRendererPane, JList jList) {
        this();
        this._comboBox = jComboBox;
        this._comboIcon = icon;
        this._rendererPane = cellRendererPane;
        this._listBox = jList;
        this.setEnabled(this._comboBox.isEnabled());
    }

    protected void customizeButton() {
        this.setFocusable(false);
        this.setBorderPainted(false);
        this.setRequestFocusEnabled(false);
    }

    public BasicJideComboBoxButton(JComboBox jComboBox, Icon icon, boolean bl2, CellRendererPane cellRendererPane, JList jList) {
        this(jComboBox, icon, cellRendererPane, jList);
        this._iconOnly = bl2;
    }

    @Override
    public boolean isFocusTraversable() {
        return false;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Color color = graphics.getColor();
        Object object = UIDefaultsLookup.get("Theme.painter");
        if (!(object instanceof ThemePainter)) {
            return;
        }
        ThemePainter themePainter = (ThemePainter)object;
        if (this.getModel().isSelected() || this.getModel().isPressed() || this._comboBox.isPopupVisible()) {
            themePainter.paintButtonBackground(this, graphics, new Rectangle(0, 0, this.getWidth(), this.getHeight()), 0, 1, false);
        } else if (this.getModel().isRollover() || ((BasicJideComboBoxUI)this._comboBox.getUI()).isRollOver()) {
            themePainter.paintButtonBackground(this, graphics, new Rectangle(0, 0, this.getWidth(), this.getHeight()), 0, 2, false);
        } else {
            themePainter.paintButtonBackground(this, graphics, new Rectangle(0, 0, this.getWidth(), this.getHeight()), 0, 0, false);
        }
        if (((BasicJideComboBoxUI)this._comboBox.getUI()).isRollOver() || this._comboBox.isPopupVisible()) {
            graphics.setColor(themePainter.getMenuItemBorderColor());
            graphics.drawLine(0, 0, 0, this.getHeight());
        }
        this.paintIcon(graphics);
        graphics.setColor(color);
    }

    protected void paintIcon(Graphics graphics) {
        Insets insets = this.getInsets();
        int n2 = this.getWidth() - (insets.left + insets.right);
        int n3 = this.getHeight() - (insets.top + insets.bottom);
        if (n3 <= 0 || n2 <= 0) {
            return;
        }
        int n4 = insets.left;
        int n5 = insets.top;
        int n6 = n5 + (n3 - 1);
        if (this._comboIcon != null) {
            int n7;
            int n8;
            int n9 = this._comboIcon.getIconWidth();
            int n10 = this._comboIcon.getIconHeight();
            if (this._iconOnly) {
                n8 = this.getWidth() / 2 - n9 / 2;
                n7 = this.getHeight() / 2 - n10 / 2 - 1;
            } else {
                n8 = n4;
                n7 = n5 + (n6 - n5) / 2 - n10 / 2;
            }
            this._comboIcon.paintIcon(this, graphics, n8, n7);
        }
    }
}

