/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.aqua;

import com.jidesoft.plaf.aqua.XMLElement;
import com.jidesoft.utils.Base64;
import com.jidesoft.utils.SecurityUtils;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

class BinaryPListParser {
    private int refCount;
    private int offsetCount;
    private int objectCount;
    private int topLevelOffset;
    private ArrayList objectTable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLElement parse(File file) throws IOException {
        byte[] byArray = null;
        try (RandomAccessFile randomAccessFile = null;){
            randomAccessFile = new RandomAccessFile(file, "r");
            int n2 = randomAccessFile.readInt();
            int n3 = randomAccessFile.readInt();
            if (n2 != 1651534953 || n3 != 1936994352) {
                throw new IOException("parseHeader: File does not start with 'bplist00' magic.");
            }
            randomAccessFile.seek(randomAccessFile.length() - 32L);
            this.offsetCount = (int)randomAccessFile.readLong();
            this.refCount = (int)randomAccessFile.readLong();
            this.objectCount = (int)randomAccessFile.readLong();
            this.topLevelOffset = (int)randomAccessFile.readLong();
            byArray = new byte[this.topLevelOffset - 8];
            randomAccessFile.seek(8L);
            randomAccessFile.readFully(byArray);
        }
        this.objectTable = new ArrayList();
        try (FilterInputStream filterInputStream = null;){
            filterInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            this.parseObjectTable((DataInputStream)filterInputStream);
        }
        XMLElement xMLElement = new XMLElement(new HashMap(), false, false);
        xMLElement.setName("plist");
        xMLElement.setAttribute("version", "1.0");
        this.convertObjectTableToXML(xMLElement, this.objectTable.get(0));
        return xMLElement;
    }

    private void convertObjectTableToXML(XMLElement xMLElement, Object object) {
        XMLElement xMLElement2 = xMLElement.createAnotherElement();
        if (object instanceof BPLDict) {
            BPLDict bPLDict = (BPLDict)object;
            xMLElement2.setName("dict");
            for (int i2 = 0; i2 < bPLDict.keyref.length; ++i2) {
                XMLElement xMLElement3 = xMLElement.createAnotherElement();
                xMLElement3.setName("key");
                xMLElement3.setContent(bPLDict.getKey(i2));
                xMLElement2.addChild(xMLElement3);
                this.convertObjectTableToXML(xMLElement2, bPLDict.getValue(i2));
            }
        } else if (object instanceof BPLArray) {
            BPLArray bPLArray = (BPLArray)object;
            xMLElement2.setName("array");
            for (int i3 = 0; i3 < bPLArray.objref.length; ++i3) {
                this.convertObjectTableToXML(xMLElement2, bPLArray.getValue(i3));
            }
        } else if (object instanceof String) {
            xMLElement2.setName("string");
            xMLElement2.setContent((String)object);
        } else if (object instanceof Integer) {
            xMLElement2.setName("integer");
            xMLElement2.setContent(object.toString());
        } else if (object instanceof Long) {
            xMLElement2.setName("integer");
            xMLElement2.setContent(object.toString());
        } else if (object instanceof Float) {
            xMLElement2.setName("real");
            xMLElement2.setContent(object.toString());
        } else if (object instanceof Double) {
            xMLElement2.setName("real");
            xMLElement2.setContent(object.toString());
        } else if (object instanceof Boolean) {
            xMLElement2.setName("boolean");
            xMLElement2.setContent(object.toString());
        } else if (object instanceof byte[]) {
            xMLElement2.setName("data");
            xMLElement2.setContent(Base64.encodeBytes((byte[])object));
        } else if (object instanceof Date) {
            xMLElement2.setName("date");
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            xMLElement2.setContent(simpleDateFormat.format((Date)object));
        } else {
            xMLElement2.setName("unsupported");
            xMLElement2.setContent(object.toString());
        }
        xMLElement.addChild(xMLElement2);
    }

    private void parseObjectTable(DataInputStream dataInputStream) throws IOException {
        int n2;
        while ((n2 = dataInputStream.read()) != -1) {
            switch ((n2 & 0xF0) >> 4) {
                case 0: {
                    this.parsePrimitive(dataInputStream, n2 & 0xF);
                    break;
                }
                case 1: {
                    int n3 = 1 << (n2 & 0xF);
                    this.parseInt(dataInputStream, n3);
                    break;
                }
                case 2: {
                    int n3 = 1 << (n2 & 0xF);
                    this.parseReal(dataInputStream, n3);
                    break;
                }
                case 3: {
                    if ((n2 & 0xF) != 3) {
                        throw new IOException("parseObjectTable: illegal marker " + Integer.toBinaryString(n2));
                    }
                    this.parseDate(dataInputStream);
                    break;
                }
                case 4: {
                    int n3 = n2 & 0xF;
                    if (n3 == 15) {
                        n3 = this.readCount(dataInputStream);
                    }
                    this.parseData(dataInputStream, n3);
                    break;
                }
                case 5: {
                    int n3 = n2 & 0xF;
                    if (n3 == 15) {
                        n3 = this.readCount(dataInputStream);
                    }
                    this.parseAsciiString(dataInputStream, n3);
                    break;
                }
                case 6: {
                    int n3 = n2 & 0xF;
                    if (n3 == 15) {
                        n3 = this.readCount(dataInputStream);
                    }
                    this.parseUnicodeString(dataInputStream, n3);
                    break;
                }
                case 7: {
                    System.out.println("parseObjectTable: illegal marker " + Integer.toBinaryString(n2));
                    return;
                }
                case 8: {
                    int n3 = (n2 & 0xF) + 1;
                    System.out.println("uid " + n3);
                    break;
                }
                case 9: {
                    throw new IOException("parseObjectTable: illegal marker " + Integer.toBinaryString(n2));
                }
                case 10: {
                    int n3 = n2 & 0xF;
                    if (n3 == 15) {
                        n3 = this.readCount(dataInputStream);
                    }
                    if (this.refCount > 255) {
                        this.parseShortArray(dataInputStream, n3);
                        break;
                    }
                    this.parseByteArray(dataInputStream, n3);
                    break;
                }
                case 11: {
                    throw new IOException("parseObjectTable: illegal marker " + Integer.toBinaryString(n2));
                }
                case 12: {
                    throw new IOException("parseObjectTable: illegal marker " + Integer.toBinaryString(n2));
                }
                case 13: {
                    int n3 = n2 & 0xF;
                    if (n3 == 15) {
                        n3 = this.readCount(dataInputStream);
                    }
                    if (this.refCount > 256) {
                        this.parseShortDict(dataInputStream, n3);
                        break;
                    }
                    this.parseByteDict(dataInputStream, n3);
                    break;
                }
                case 14: {
                    throw new IOException("parseObjectTable: illegal marker " + Integer.toBinaryString(n2));
                }
                case 15: {
                    throw new IOException("parseObjectTable: illegal marker " + Integer.toBinaryString(n2));
                }
            }
        }
    }

    private int readCount(DataInputStream dataInputStream) throws IOException {
        int n2 = dataInputStream.read();
        if (n2 == -1) {
            throw new IOException("variableLengthInt: Illegal EOF in marker");
        }
        if ((n2 & 0xF0) >> 4 != 1) {
            throw new IOException("variableLengthInt: Illegal marker " + Integer.toBinaryString(n2));
        }
        int n3 = 1 << (n2 & 0xF);
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n5 = dataInputStream.read();
            if (n5 == -1) {
                throw new IOException("variableLengthInt: Illegal EOF in value");
            }
            n4 = n4 << 8 | n5;
        }
        return n4;
    }

    private void parsePrimitive(DataInputStream dataInputStream, int n2) throws IOException {
        switch (n2) {
            case 0: {
                this.objectTable.add(null);
                break;
            }
            case 8: {
                this.objectTable.add(Boolean.FALSE);
                break;
            }
            case 9: {
                this.objectTable.add(Boolean.TRUE);
                break;
            }
            case 15: {
                break;
            }
            default: {
                throw new IOException("parsePrimitive: illegal primitive " + Integer.toBinaryString(n2));
            }
        }
    }

    private void parseByteArray(DataInputStream dataInputStream, int n2) throws IOException {
        BPLArray bPLArray = new BPLArray();
        bPLArray.objectTable = this.objectTable;
        bPLArray.objref = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            bPLArray.objref[i2] = dataInputStream.readByte() & 0xFF;
            if (bPLArray.objref[i2] != -1) continue;
            throw new IOException("parseByteArray: illegal EOF in objref*");
        }
        this.objectTable.add(bPLArray);
    }

    private void parseShortArray(DataInputStream dataInputStream, int n2) throws IOException {
        BPLArray bPLArray = new BPLArray();
        bPLArray.objectTable = this.objectTable;
        bPLArray.objref = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            bPLArray.objref[i2] = dataInputStream.readShort() & 0xFFFF;
            if (bPLArray.objref[i2] != -1) continue;
            throw new IOException("parseShortArray: illegal EOF in objref*");
        }
        this.objectTable.add(bPLArray);
    }

    private void parseData(DataInputStream dataInputStream, int n2) throws IOException {
        byte[] byArray = new byte[n2];
        dataInputStream.readFully(byArray);
        this.objectTable.add(byArray);
    }

    private void parseByteDict(DataInputStream dataInputStream, int n2) throws IOException {
        int n3;
        BPLDict bPLDict = new BPLDict();
        bPLDict.objectTable = this.objectTable;
        bPLDict.keyref = new int[n2];
        bPLDict.objref = new int[n2];
        for (n3 = 0; n3 < n2; ++n3) {
            bPLDict.keyref[n3] = dataInputStream.readByte() & 0xFF;
        }
        for (n3 = 0; n3 < n2; ++n3) {
            bPLDict.objref[n3] = dataInputStream.readByte() & 0xFF;
        }
        this.objectTable.add(bPLDict);
    }

    private void parseShortDict(DataInputStream dataInputStream, int n2) throws IOException {
        int n3;
        BPLDict bPLDict = new BPLDict();
        bPLDict.objectTable = this.objectTable;
        bPLDict.keyref = new int[n2];
        bPLDict.objref = new int[n2];
        for (n3 = 0; n3 < n2; ++n3) {
            bPLDict.keyref[n3] = dataInputStream.readShort() & 0xFFFF;
        }
        for (n3 = 0; n3 < n2; ++n3) {
            bPLDict.objref[n3] = dataInputStream.readShort() & 0xFFFF;
        }
        this.objectTable.add(bPLDict);
    }

    private void parseAsciiString(DataInputStream dataInputStream, int n2) throws IOException {
        byte[] byArray = new byte[n2];
        dataInputStream.readFully(byArray);
        String string = new String(byArray, "ASCII");
        this.objectTable.add(string);
    }

    private void parseInt(DataInputStream dataInputStream, int n2) throws IOException {
        if (n2 > 8) {
            throw new IOException("parseInt: unsupported byte count:" + n2);
        }
        long l2 = 0L;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = dataInputStream.read();
            if (n3 == -1) {
                throw new IOException("parseInt: Illegal EOF in value");
            }
            l2 = l2 << 8 | (long)n3;
        }
        this.objectTable.add(l2);
    }

    private void parseReal(DataInputStream dataInputStream, int n2) throws IOException {
        switch (n2) {
            case 4: {
                this.objectTable.add(Float.valueOf(dataInputStream.readFloat()));
                break;
            }
            case 8: {
                this.objectTable.add(dataInputStream.readDouble());
                break;
            }
            default: {
                throw new IOException("parseReal: unsupported byte count:" + n2);
            }
        }
    }

    private void parseDate(DataInputStream dataInputStream) throws IOException {
        double d2 = dataInputStream.readDouble();
        this.objectTable.add(new Date());
    }

    private void parseUnicodeString(DataInputStream dataInputStream, int n2) throws IOException {
        char[] cArray = new char[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            cArray[i2] = dataInputStream.readChar();
        }
        String string = new String(cArray);
        this.objectTable.add(string);
    }

    public static void main(String[] stringArray) {
        try {
            File[] fileArray = new File(SecurityUtils.getProperty("user.home", ""), "Library/Preferences").listFiles();
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                String string = fileArray[i2].getName();
                if (fileArray[i2].isDirectory() || !string.endsWith(".plist") || string.endsWith("internetconfig.plist")) continue;
                try {
                    System.out.println(fileArray[i2]);
                    BinaryPListParser binaryPListParser = new BinaryPListParser();
                    XMLElement xMLElement = binaryPListParser.parse(fileArray[i2]);
                    System.out.println(xMLElement);
                    continue;
                }
                catch (IOException iOException) {
                    if (iOException.getMessage() != null && (iOException.getMessage().startsWith("parseHeader") || iOException.getMessage().startsWith("parseTrailer"))) {
                        System.out.println(iOException);
                        continue;
                    }
                    throw iOException;
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private static class BPLDict {
        ArrayList objectTable;
        int[] keyref;
        int[] objref;

        private BPLDict() {
        }

        public String getKey(int n2) {
            return this.objectTable.get(this.keyref[n2]).toString();
        }

        public Object getValue(int n2) {
            return this.objectTable.get(this.objref[n2]);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("BPLDict{");
            for (int i2 = 0; i2 < this.keyref.length; ++i2) {
                if (i2 > 0) {
                    stringBuffer.append(',');
                }
                if (this.keyref[i2] < 0 || this.keyref[i2] >= this.objectTable.size()) {
                    stringBuffer.append("#" + this.keyref[i2]);
                } else if (this.objectTable.get(this.keyref[i2]) == this) {
                    stringBuffer.append("*" + this.keyref[i2]);
                } else {
                    stringBuffer.append(this.objectTable.get(this.keyref[i2]));
                }
                stringBuffer.append(":");
                if (this.objref[i2] < 0 || this.objref[i2] >= this.objectTable.size()) {
                    stringBuffer.append("#" + this.objref[i2]);
                    continue;
                }
                if (this.objectTable.get(this.objref[i2]) == this) {
                    stringBuffer.append("*" + this.objref[i2]);
                    continue;
                }
                stringBuffer.append(this.objectTable.get(this.objref[i2]));
            }
            stringBuffer.append('}');
            return stringBuffer.toString();
        }
    }

    private static class BPLArray {
        ArrayList objectTable;
        int[] objref;

        private BPLArray() {
        }

        public Object getValue(int n2) {
            return this.objectTable.get(this.objref[n2]);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("Array{");
            for (int i2 = 0; i2 < this.objref.length; ++i2) {
                if (i2 > 0) {
                    stringBuffer.append(',');
                }
                if (this.objectTable.size() > this.objref[i2] && this.objectTable.get(this.objref[i2]) != this) {
                    stringBuffer.append(this.objectTable.get(this.objref[i2]));
                    continue;
                }
                stringBuffer.append("*" + this.objref[i2]);
            }
            stringBuffer.append('}');
            return stringBuffer.toString();
        }
    }
}

