/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper;

import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.XmlHelper;
import com.install4j.runtime.installer.platform.macos.PlistHelper;
import com.install4j.runtime.installer.platform.unix.Execution;
import java.io.File;

public class AppleScriptHelper {
    public static boolean executeScript(String script, boolean resetTcc) {
        try {
            boolean success;
            StringBuffer output = new StringBuffer();
            StringBuffer error = new StringBuffer();
            boolean bl = success = Execution.executeWithReturnCode(new String[]{"/usr/bin/osascript", "-s", "s", "-e", script}, output, error, true) == 0;
            if (!success) {
                String identifier;
                File infoPlistFile;
                Logger.getInstance().info(null, "osascript error: " + error);
                if (resetTcc && InstallerVariables.MODULE_NAME != null && InstallerVariables.MODULE_NAME.endsWith(".app") && error.toString().contains("-1743") && (infoPlistFile = new File(InstallerVariables.MODULE_NAME, "Contents/Info.plist")).isFile() && (identifier = XmlHelper.getTextValue(PlistHelper.findValue(PlistHelper.getFirstChild(XmlHelper.parseFile(infoPlistFile).getDocumentElement(), "dict"), "CFBundleIdentifier"))) != null && !identifier.isEmpty()) {
                    Logger.getInstance().info(null, "resetting TCC for AppleEvents of " + identifier);
                    int resetResult = Execution.executeWithReturnCode(new String[]{"/usr/bin/tccutil", "reset", "AppleEvents", identifier}, new StringBuffer(), true);
                    if (resetResult != 0) {
                        Logger.getInstance().info(null, "tccutil reset AppleEvents " + identifier + " returned " + resetResult);
                    } else {
                        return AppleScriptHelper.executeScript(script, false);
                    }
                }
            }
            return success;
        }
        catch (Exception e) {
            Logger.getInstance().log(e);
            return false;
        }
    }
}

