/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.config;

import com.install4j.runtime.installer.config.AbstractConfig;
import com.install4j.runtime.launcher.MacLauncher;
import java.io.File;
import java.util.Objects;
import org.w3c.dom.Element;

public class MacSpecificConfig
extends AbstractConfig {
    private final String runtimeDirParent;
    private final boolean singleBundle;
    private String singleBundleLauncherId = "";
    private String singleBundleLauncherPath;
    private final File singleBundleDirectory = MacLauncher.getSingleBundleDirectory();

    public MacSpecificConfig() {
        this.singleBundle = this.singleBundleDirectory != null;
        this.runtimeDirParent = this.singleBundleDirectory == null ? "" : this.singleBundleDirectory.getName() + "/" + "Contents/Resources/app" + "/";
    }

    public String getRuntimeDirParent() {
        return this.runtimeDirParent;
    }

    public boolean isSingleBundle() {
        return this.singleBundle;
    }

    public String getSingleBundleLauncherId() {
        return this.singleBundleLauncherId;
    }

    @Override
    protected void read(Element element) {
        this.singleBundleLauncherId = MacSpecificConfig.readAttribute(element, "singleBundleLauncherId", this.singleBundleLauncherId);
        this.singleBundleLauncherPath = MacSpecificConfig.readAttribute(element, "singleBundleLauncherPath", this.singleBundleLauncherPath);
    }

    public String replaceSingleBundleLauncher(String fileName) {
        if (this.singleBundleDirectory != null && Objects.equals(this.singleBundleLauncherPath, fileName)) {
            return this.singleBundleDirectory.getName();
        }
        return fileName;
    }
}

