/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures.constants;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gjt.jclasslib.io.DataInput;
import org.gjt.jclasslib.io.DataOutput;
import org.gjt.jclasslib.structures.AbstractConstant;
import org.gjt.jclasslib.structures.ClassFile;
import org.gjt.jclasslib.structures.ConstantType;
import org.gjt.jclasslib.structures.constants.ConstantUtf8Info;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0014J\u0010\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020'H\u0014J\u0013\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010-H\u0096\u0002J\b\u0010.\u001a\u00020\u0007H\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000bR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0016R\u0011\u0010\u001f\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001cR\u0014\u0010(\u001a\u00020\u00148TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0016\u00a8\u0006/"}, d2={"Lorg/gjt/jclasslib/structures/constants/ConstantNameAndTypeInfo;", "Lorg/gjt/jclasslib/structures/AbstractConstant;", "classFile", "Lorg/gjt/jclasslib/structures/ClassFile;", "<init>", "(Lorg/gjt/jclasslib/structures/ClassFile;)V", "nameIndex", "", "getNameIndex", "()I", "setNameIndex", "(I)V", "descriptorIndex", "getDescriptorIndex", "setDescriptorIndex", "constantType", "Lorg/gjt/jclasslib/structures/ConstantType;", "getConstantType", "()Lorg/gjt/jclasslib/structures/ConstantType;", "verbose", "", "getVerbose", "()Ljava/lang/String;", "name", "getName", "nameConstant", "Lorg/gjt/jclasslib/structures/constants/ConstantUtf8Info;", "getNameConstant", "()Lorg/gjt/jclasslib/structures/constants/ConstantUtf8Info;", "descriptor", "getDescriptor", "descriptorConstant", "getDescriptorConstant", "readData", "", "input", "Lorg/gjt/jclasslib/io/DataInput;", "writeData", "output", "Lorg/gjt/jclasslib/io/DataOutput;", "debugInfo", "getDebugInfo", "equals", "", "other", "", "hashCode", "data"})
public final class ConstantNameAndTypeInfo
extends AbstractConstant {
    private int nameIndex;
    private int descriptorIndex;

    public ConstantNameAndTypeInfo(@NotNull ClassFile classFile) {
        Intrinsics.checkNotNullParameter((Object)classFile, (String)"classFile");
        super(classFile);
    }

    public final int getNameIndex() {
        return this.nameIndex;
    }

    public final void setNameIndex(int n) {
        this.nameIndex = n;
    }

    public final int getDescriptorIndex() {
        return this.descriptorIndex;
    }

    public final void setDescriptorIndex(int n) {
        this.descriptorIndex = n;
    }

    @Override
    @NotNull
    public ConstantType getConstantType() {
        return ConstantType.NAME_AND_TYPE;
    }

    @Override
    @NotNull
    public String getVerbose() {
        return this.getName() + " : " + this.getDescriptor();
    }

    @NotNull
    public final String getName() {
        return this.getNameConstant().getString();
    }

    @NotNull
    public final ConstantUtf8Info getNameConstant() {
        return this.getClassFile().getConstantPoolUtf8Entry(this.nameIndex);
    }

    @NotNull
    public final String getDescriptor() {
        return this.getDescriptorConstant().getString();
    }

    @NotNull
    public final ConstantUtf8Info getDescriptorConstant() {
        return this.getClassFile().getConstantPoolUtf8Entry(this.descriptorIndex);
    }

    @Override
    protected void readData(@NotNull DataInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.nameIndex = input.readUnsignedShort();
        this.descriptorIndex = input.readUnsignedShort();
    }

    @Override
    protected void writeData(@NotNull DataOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        output.writeByte(ConstantType.NAME_AND_TYPE.getTag());
        output.writeShort(this.nameIndex);
        output.writeShort(this.descriptorIndex);
    }

    @Override
    @NotNull
    protected String getDebugInfo() {
        return "with nameIndex " + this.nameIndex + " and descriptorIndex " + this.descriptorIndex;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (!(other instanceof ConstantNameAndTypeInfo)) {
            return false;
        }
        return super.equals(other) && ((ConstantNameAndTypeInfo)other).nameIndex == this.nameIndex && ((ConstantNameAndTypeInfo)other).descriptorIndex == this.descriptorIndex;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.nameIndex ^ this.descriptorIndex;
    }
}

