/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.io;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0002\u001a\u0018\u0010\n\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0002\u001a\u0018\u0010\f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0002\u001a1\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u00022!\u0010\u0010\u001a\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\u000f0\u0011\u001aF\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u000226\u0010\u0010\u001a2\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0017\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000f0\u0016\u001a\u0010\u0010\u0018\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0002H\u0002\"\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"modulesRootsCache", "", "Ljava/io/File;", "Ljava/nio/file/Path;", "CLASS_FILE_SUFFIX", "", "getJrtInputStream", "Ljava/io/InputStream;", "fileName", "jreHome", "findClassWithModuleNameInJrt", "moduleNameAndClassName", "findClassInJrt", "className", "forEachClassInJrt", "", "block", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "path", "forEachClassNameInJrt", "Lkotlin/Function2;", "moduleName", "getModulesRoot", "data"})
@SourceDebugExtension(value={"SMAP\nJimage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Jimage.kt\norg/gjt/jclasslib/io/JimageKt\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,78:1\n381#2,7:79\n*S KotlinDebug\n*F\n+ 1 Jimage.kt\norg/gjt/jclasslib/io/JimageKt\n*L\n75#1:79,7\n*E\n"})
public final class JimageKt {
    @NotNull
    private static final Map<File, Path> modulesRootsCache = new LinkedHashMap();
    @NotNull
    private static final String CLASS_FILE_SUFFIX = ".class";

    @NotNull
    public static final InputStream getJrtInputStream(@NotNull String fileName, @NotNull File jreHome) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)jreHome, (String)"jreHome");
        InputStream inputStream = Files.newInputStream(JimageKt.getModulesRoot(jreHome).resolve(fileName), new OpenOption[0]);
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        return inputStream;
    }

    @Nullable
    public static final Path findClassWithModuleNameInJrt(@NotNull String moduleNameAndClassName, @NotNull File jreHome) {
        Intrinsics.checkNotNullParameter((Object)moduleNameAndClassName, (String)"moduleNameAndClassName");
        Intrinsics.checkNotNullParameter((Object)jreHome, (String)"jreHome");
        return JimageKt.getModulesRoot(jreHome).resolve(moduleNameAndClassName + CLASS_FILE_SUFFIX);
    }

    @Nullable
    public static final Path findClassInJrt(@NotNull String className, @NotNull File jreHome) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)jreHome, (String)"jreHome");
        String fileName = StringsKt.replace$default((String)className, (char)'.', (char)'/', (boolean)false, (int)4, null) + CLASS_FILE_SUFFIX;
        Iterator<Path> iterator = Files.newDirectoryStream(JimageKt.getModulesRoot(jreHome)).iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<Path> iterator2 = iterator;
        while (iterator2.hasNext()) {
            Path module = iterator2.next();
            Path path = module.resolve(fileName);
            if (!Files.exists(path, new LinkOption[0])) continue;
            return path;
        }
        return null;
    }

    public static final void forEachClassInJrt(@NotNull File jreHome, @NotNull Function1<? super Path, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)jreHome, (String)"jreHome");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Files.walk(JimageKt.getModulesRoot(jreHome), new FileVisitOption[0]).forEach(arg_0 -> JimageKt.forEachClassInJrt$lambda$1(arg_0 -> JimageKt.forEachClassInJrt$lambda$0(block, arg_0), arg_0));
    }

    public static final void forEachClassNameInJrt(@NotNull File jreHome, @NotNull Function2<? super String, ? super String, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)jreHome, (String)"jreHome");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        JimageKt.forEachClassInJrt(jreHome, (Function1<? super Path, Unit>)((Function1)arg_0 -> JimageKt.forEachClassNameInJrt$lambda$2(block, arg_0)));
    }

    private static final Path getModulesRoot(File jreHome) {
        Path path;
        Map<File, Path> $this$getOrPut$iv = modulesRootsCache;
        boolean $i$f$getOrPut = false;
        Path value$iv = $this$getOrPut$iv.get(jreHome);
        if (value$iv == null) {
            boolean bl = false;
            Path path2 = FileSystems.newFileSystem(new URI("jrt:/"), MapsKt.mapOf((Pair)TuplesKt.to((Object)"java.home", (Object)jreHome.getPath()))).getPath("/modules", new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getPath(...)");
            Path answer$iv = path2;
            $this$getOrPut$iv.put(jreHome, answer$iv);
            path = answer$iv;
        } else {
            path = value$iv;
        }
        return path;
    }

    private static final Unit forEachClassInJrt$lambda$0(Function1 $block, Path path) {
        if (path.getNameCount() > 2 && !Files.isDirectory(path, new LinkOption[0])) {
            String string = ((Object)path).toString().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            if (StringsKt.endsWith$default((String)string, (String)CLASS_FILE_SUFFIX, (boolean)false, (int)2, null)) {
                Intrinsics.checkNotNull((Object)path);
                $block.invoke((Object)path);
            }
        }
        return Unit.INSTANCE;
    }

    private static final void forEachClassInJrt$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit forEachClassNameInJrt$lambda$2(Function2 $block, Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        $block.invoke((Object)((Object)path.getName(1)).toString(), (Object)((Object)path.subpath(2, path.getNameCount())).toString());
        return Unit.INSTANCE;
    }
}

