/*
 * Decompiled with CFR 0.152.
 */
package org.pkcs11.jacknji11;

import java.util.Map;
import org.pkcs11.jacknji11.Buf;
import org.pkcs11.jacknji11.C;
import org.pkcs11.jacknji11.CK_VERSION;

public class CK_TOKEN_INFO {
    public static final long CKF_RNG = 1L;
    public static final long CKF_WRITE_PROTECTED = 2L;
    public static final long CKF_LOGIN_REQUIRED = 4L;
    public static final long CKF_USER_PIN_INITIALIZED = 8L;
    public static final long CKF_RESTORE_KEY_NOT_NEEDED = 32L;
    public static final long CKF_CLOCK_ON_TOKEN = 64L;
    public static final long CKF_PROTECTED_AUTHENTICATION_PATH = 256L;
    public static final long CKF_DUAL_CRYPTO_OPERATIONS = 512L;
    public static final long CKF_TOKEN_INITIALIZED = 1024L;
    public static final long CKF_SECONDARY_AUTHENTICATION = 2048L;
    public static final long CKF_USER_PIN_COUNT_LOW = 65536L;
    public static final long CKF_USER_PIN_FINAL_TRY = 131072L;
    public static final long CKF_USER_PIN_LOCKED = 262144L;
    public static final long CKF_USER_PIN_TO_BE_CHANGED = 524288L;
    public static final long CKF_SO_PIN_COUNT_LOW = 0x100000L;
    public static final long CKF_SO_PIN_FINAL_TRY = 0x200000L;
    public static final long CKF_SO_PIN_LOCKED = 0x400000L;
    public static final long CKF_SO_PIN_TO_BE_CHANGED = 0x800000L;
    private static final Map<Long, String> L2S = C.createL2SMap(CK_TOKEN_INFO.class);
    public byte[] label = new byte[32];
    public byte[] manufacturerID = new byte[32];
    public byte[] model = new byte[16];
    public byte[] serialNumber = new byte[16];
    public long flags;
    public long ulMaxSessionCount;
    public long ulSessionCount;
    public long ulMaxRwSessionCount;
    public long ulRwSessionCount;
    public long ulMaxPinLen;
    public long ulMinPinLen;
    public long ulTotalPublicMemory;
    public long ulFreePublicMemory;
    public long ulTotalPrivateMemory;
    public long ulFreePrivateMemory;
    public CK_VERSION hardwareVersion = new CK_VERSION();
    public CK_VERSION firmwareVersion = new CK_VERSION();
    public byte[] utcTime = new byte[16];

    public static final String L2S(long ckf) {
        return C.l2s(L2S, "CKF", ckf);
    }

    public static String f2s(long flags) {
        return C.f2s(L2S, flags);
    }

    public boolean isFlagSet(long CKF_FLAG) {
        return (this.flags & CKF_FLAG) != 0L;
    }

    public String toString() {
        return String.format("(\n  label=%s\n  manufacturerID=%s\n  model=%s\n  serialNumber=%s\n  flags=0x%08x{%s}\n  maxSessionCount=%d\n  sessionCount=%d\n  maxRwSessionCount=%d\n  rwSessionCount=%d\n  maxPinLen=%d\n  minPinLen=%d\n  totalPublicMemory=%d\n  freePublicMemory=%d\n  totalPrivateMemory=%d\n  freePrivateMemory=%d\n  hardwareVersion=%d.%d\n  firmwareVersion=%d.%d\n  utcTime=%s\n)", Buf.escstr(this.label), Buf.escstr(this.manufacturerID), Buf.escstr(this.model), Buf.escstr(this.serialNumber), this.flags, CK_TOKEN_INFO.f2s(this.flags), this.ulMaxSessionCount, this.ulSessionCount, this.ulMaxRwSessionCount, this.ulRwSessionCount, this.ulMaxPinLen, this.ulMinPinLen, this.ulTotalPublicMemory, this.ulFreePublicMemory, this.ulTotalPrivateMemory, this.ulFreePrivateMemory, this.hardwareVersion.major & 0xFF, this.hardwareVersion.minor & 0xFF, this.firmwareVersion.major & 0xFF, this.firmwareVersion.minor & 0xFF, Buf.escstr(this.utcTime));
    }
}

