package com.install4j.api.context;

/**
 * This interface provides information about file sets.
 * File sets are configured on the "Define Distribution Tree" tab
 * in the install4j IDE.
 * <p>Objects of this type are returned by {@link Context#getFileSets()} and {@link Context#getFileSetById(String)}
 *
 * @author ej-technologies GmbH
 */
public interface FileSetSetup {
    /**
     * Returns whether the file set is selected for installation. By default, all file sets will be installed.
     *
     * @return {@code true} or {@code false}.
     */
    boolean isSelected();

    /**
     * Sets whether the file set should be installed or not. This method only has an effect
     * when called before the "Install files" action.
     *
     * @param selected the new selection state
     */
    void setSelected(boolean selected);

    /**
     * Returns the name of this file set. This is the name that you have
     * specified in the install4j IDE.
     *
     * @return the name
     */
    String getName();

    /**
     * The ID of the file set. You can display component IDs in the install4j IDE.
     *
     * @return the ID
     */
    String getId();
}
