package com.install4j.api.beaninfo;

import com.install4j.api.beans.Bean;

import java.util.List;

/**
 * Interface for controlling insertion and reordering of beans at design-time. The
 * {@link Install4JBeanInfo#ATTRIBUTE_SEQUENCE_VALIDATOR} value of a bean descriptor expects an instance of
 * this class.
 */
public interface SequenceValidator {
    /**
     * When a bean is inserted the first time at design-time, this method will be called to
     * determine the insertion index. If this method returns -1, the bean will be inserted in its default position.
     * This method is not called for existing bean instances that are loaded from a project.
     * @param bean the bean that is being inserted
     * @param beans the list of existing beans into which the bean is to be inserted
     * @return the insertion index into the list
     */
    int getInsertIndex(Bean bean, List<Bean> beans);

    /**
     * When a bean is moved in the list of beans, this method is called to check whether the move is valid.
     * This method is called symmetrically for both beans whose location is to be swapped.
     * This means that the user might actually be moving the {@code possibleBarrierBean} instead of the {@code movedBean}.
     * @param movedBean the bean that is being moved. This is always an instance of the bean with the BeanInfo class that contains this sequence validator.
     * @param possibleBarrierBean the other bean whose location is about to be swapped with the {@code movedBean}.
     * @return whether the move is valid. If you return {@code false} an error message will be displayed by the install4j GUI.
     */
    boolean isBarrier(Bean movedBean, Bean possibleBarrierBean);
}
