package com.install4j.api;

import java.io.*;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * Support class for old-style enums that work with Java 1.4 and are serializable.
 * <p>This class is no longer needed since install4j 6 where the minimum Java version for the runtime
 * is higher than 1.5 and enums can always be used.
 * @author ej-technologies GmbH
 */
public abstract class SerializableEnum implements Serializable {

    private static Map<Identifier, Object> identifierToInstance = Collections.synchronizedMap(new HashMap<>());
    private static Map<String, MutableInt> classNameToLastId = Collections.synchronizedMap(new HashMap<>());

    private int id;

    protected SerializableEnum() {
        String className = getClass().getName();
        MutableInt mutableInt = classNameToLastId.computeIfAbsent(className, k -> new MutableInt());
        id = ++mutableInt.val;
        identifierToInstance.put(new Identifier(className, id), this);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(id);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        id = in.readInt();
    }

    protected Object readResolve() throws ObjectStreamException {
        Object singleInstance = identifierToInstance.get(new Identifier(getClass().getName(), id));
        if (singleInstance == null) {
            throw new InvalidObjectException("unknown id " + id + " for class " + getClass().getName());
        }
        return singleInstance;
    }

    private static class Identifier {
        private String className;
        private int id;

        private Identifier(String className, int id) {
            this.className = className;
            this.id = id;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            Identifier that = (Identifier) o;

            if (id != that.id) return false;
            if (!Objects.equals(className, that.className)) return false;

            return true;
        }

        @Override
        public int hashCode() {
            int result = className.hashCode();
            result = 31 * result + id;
            return result;
        }
    }

    private static class MutableInt {
        int val;
    }
}
