/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import java.awt.Color;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.swing.UIDefaults;
import javax.swing.plaf.ColorUIResource;

public class SwingLazyValue
implements UIDefaults.LazyValue {
    private String className;
    private String methodName;
    private Object[] args;

    public SwingLazyValue(String string) {
        this(string, (String)null);
    }

    public SwingLazyValue(String string, String string2) {
        this(string, string2, null);
    }

    public SwingLazyValue(String string, Object[] objectArray) {
        this(string, null, objectArray);
    }

    public SwingLazyValue(String string, String string2, Object[] objectArray) {
        this.className = string;
        this.methodName = string2;
        if (objectArray != null) {
            this.args = (Object[])objectArray.clone();
        }
    }

    @Override
    public Object createValue(UIDefaults uIDefaults) {
        try {
            Class<?> clazz = Class.forName(this.className, true, null);
            if (this.methodName != null) {
                Class[] classArray = this.getClassArray(this.args);
                Method method = clazz.getMethod(this.methodName, classArray);
                return method.invoke(clazz, this.args);
            }
            Class[] classArray = this.getClassArray(this.args);
            Constructor<?> constructor = clazz.getConstructor(classArray);
            return constructor.newInstance(this.args);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Class[] getClassArray(Object[] objectArray) {
        Class[] classArray = null;
        if (objectArray != null) {
            classArray = new Class[objectArray.length];
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                classArray[i2] = objectArray[i2] instanceof Integer ? Integer.TYPE : (objectArray[i2] instanceof Boolean ? Boolean.TYPE : (objectArray[i2] instanceof ColorUIResource ? Color.class : objectArray[i2].getClass()));
            }
        }
        return classArray;
    }
}

