/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.SimpleScrollPane;
import com.jidesoft.utils.PortingUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.PopupMenuUI;

public class JidePopupMenu
extends JPopupMenu
implements Scrollable {
    private static final String uiClassID = "JidePopupMenuUI";
    private static final String uiClassIDAlternative = "PopupMenuUI";
    private boolean _useLightWeightPopup;
    private int _visibleMenuItemCount;

    public JidePopupMenu() {
        this.setupPopupMenu();
    }

    public JidePopupMenu(String string) {
        super(string);
        this.setupPopupMenu();
    }

    @Override
    public String getUIClassID() {
        return UIDefaultsLookup.getBoolean("JidePopupMenu.uiExtensionDisabled") ? uiClassIDAlternative : uiClassID;
    }

    private void setupPopupMenu() {
        this.addPopupMenuListener(new ToolTipSwitchPopupMenuListener());
    }

    @Override
    public void updateUI() {
        if (UIDefaultsLookup.get(this.getUIClassID()) == null) {
            LookAndFeelFactory.installJideExtension();
        }
        this.setUI((PopupMenuUI)UIManager.getUI(this));
    }

    @Override
    public void show(Component component, int n2, int n3) {
        Point point = this.getPopupMenuOrigin(component, n2, n3);
        super.show(component, point.x, point.y);
    }

    protected Point getPopupMenuOrigin(Component component, int n2, int n3) {
        Dimension dimension = this.getPreferredScrollableViewportSize();
        Point point = new Point(n2, n3);
        SwingUtilities.convertPointToScreen(point, component);
        Rectangle rectangle = PortingUtils.ensureOnScreen(new Rectangle(point, dimension));
        point = rectangle.getLocation();
        SwingUtilities.convertPointFromScreen(point, component);
        return point;
    }

    @Override
    public void setLocation(int n2, int n3) {
        if (this.isVisible() && n3 <= 0) {
            this.move(n2, n3);
        } else {
            super.setLocation(n2, n3);
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        Dimension dimension = this.getPreferredSize();
        Dimension dimension2 = PortingUtils.getLocalScreenSize(this);
        Container container = SwingUtilities.getAncestorOfClass(SimpleScrollPane.class, this);
        if (container instanceof SimpleScrollPane) {
            int n2;
            SimpleScrollPane simpleScrollPane = (SimpleScrollPane)container;
            int n3 = dimension2.height;
            if (this.getVisibleMenuItemCount() > 0 && n3 > (n2 = this.getVisibleMenuItemCount() * this.getScrollableUnitIncrement(null, 0, 0))) {
                n3 = n2;
            }
            dimension.height = Math.min(dimension.height, n3 - simpleScrollPane.getScrollUpButton().getPreferredSize().height - simpleScrollPane.getScrollDownButton().getPreferredSize().height);
        }
        return dimension;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n2, int n3) {
        return new JMenuItem((String)"ABC").getPreferredSize().height;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rectangle, int n2, int n3) {
        return new JMenuItem((String)"ABC").getPreferredSize().height * 5;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public int getVisibleMenuItemCount() {
        return this._visibleMenuItemCount;
    }

    public void setVisibleMenuItemCount(int n2) {
        if (this._visibleMenuItemCount != n2) {
            int n3 = this._visibleMenuItemCount;
            this._visibleMenuItemCount = n2;
            this.firePropertyChange("visibleMenuCount", n3, n2);
        }
    }

    private class ToolTipSwitchPopupMenuListener
    implements PopupMenuListener {
        private ToolTipSwitchPopupMenuListener() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            JidePopupMenu.this._useLightWeightPopup = ToolTipManager.sharedInstance().isLightWeightPopupEnabled();
            ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            ToolTipManager.sharedInstance().setLightWeightPopupEnabled(JidePopupMenu.this._useLightWeightPopup);
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            ToolTipManager.sharedInstance().setLightWeightPopupEnabled(JidePopupMenu.this._useLightWeightPopup);
        }
    }
}

