/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.windows;

import com.jidesoft.plaf.windows.TMSchema;
import com.jidesoft.plaf.windows.XPStyle;
import com.jidesoft.swing.TristateButtonModel;
import com.jidesoft.swing.TristateCheckBox;
import com.jidesoft.utils.SystemInfo;
import java.awt.Component;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;

public class WindowsIconFactory {
    private static Icon checkBoxIcon;

    public static Icon getCheckBoxIcon() {
        if (checkBoxIcon == null) {
            checkBoxIcon = new CheckBoxIcon();
        }
        return checkBoxIcon;
    }

    private static class CheckBoxIcon
    implements Icon,
    Serializable,
    UIResource {
        static final int csize = 13;
        static int cw = -1;
        static int ch = -1;

        private CheckBoxIcon() {
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            JCheckBox jCheckBox = (JCheckBox)component;
            ButtonModel buttonModel = jCheckBox.getModel();
            if (!SystemInfo.isJdk17Above()) {
                TMSchema.State state;
                XPStyle xPStyle = XPStyle.getXP();
                if (buttonModel instanceof TristateButtonModel && ((TristateButtonModel)buttonModel).isMixed()) {
                    state = TMSchema.State.MIXEDNORMAL;
                    if (!buttonModel.isEnabled()) {
                        state = TMSchema.State.MIXEDDISABLED;
                    } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                        state = TMSchema.State.MIXEDPRESSED;
                    } else if (buttonModel.isRollover()) {
                        state = TMSchema.State.MIXEDHOT;
                    }
                } else if (buttonModel.isSelected()) {
                    state = TMSchema.State.CHECKEDNORMAL;
                    if (!buttonModel.isEnabled()) {
                        state = TMSchema.State.CHECKEDDISABLED;
                    } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                        state = TMSchema.State.CHECKEDPRESSED;
                    } else if (buttonModel.isRollover()) {
                        state = TMSchema.State.CHECKEDHOT;
                    }
                } else {
                    state = TMSchema.State.UNCHECKEDNORMAL;
                    if (!buttonModel.isEnabled()) {
                        state = TMSchema.State.UNCHECKEDDISABLED;
                    } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                        state = TMSchema.State.UNCHECKEDPRESSED;
                    } else if (buttonModel.isRollover()) {
                        state = TMSchema.State.UNCHECKEDHOT;
                    }
                }
                TMSchema.Part part = TMSchema.Part.BP_CHECKBOX;
                xPStyle.getSkin(component, part).paintSkin(graphics, n2, n3, state);
            } else {
                if (!jCheckBox.isBorderPaintedFlat()) {
                    graphics.setColor(UIManager.getColor("CheckBox.shadow"));
                    graphics.drawLine(n2, n3, n2 + 11, n3);
                    graphics.drawLine(n2, n3 + 1, n2, n3 + 11);
                    graphics.setColor(UIManager.getColor("CheckBox.highlight"));
                    graphics.drawLine(n2 + 12, n3, n2 + 12, n3 + 12);
                    graphics.drawLine(n2, n3 + 12, n2 + 11, n3 + 12);
                    graphics.setColor(UIManager.getColor("CheckBox.darkShadow"));
                    graphics.drawLine(n2 + 1, n3 + 1, n2 + 10, n3 + 1);
                    graphics.drawLine(n2 + 1, n3 + 2, n2 + 1, n3 + 10);
                    graphics.setColor(UIManager.getColor("CheckBox.light"));
                    graphics.drawLine(n2 + 1, n3 + 11, n2 + 11, n3 + 11);
                    graphics.drawLine(n2 + 11, n3 + 1, n2 + 11, n3 + 10);
                    if (buttonModel.isPressed() && buttonModel.isArmed() || !buttonModel.isEnabled()) {
                        graphics.setColor(UIManager.getColor("CheckBox.background"));
                    } else {
                        graphics.setColor(UIManager.getColor("CheckBox.interiorBackground"));
                    }
                    graphics.fillRect(n2 + 2, n3 + 2, 9, 9);
                } else {
                    graphics.setColor(UIManager.getColor("CheckBox.shadow"));
                    graphics.drawRect(n2 + 1, n3 + 1, 10, 10);
                    if (buttonModel.isPressed() && buttonModel.isArmed() || !buttonModel.isEnabled()) {
                        graphics.setColor(UIManager.getColor("CheckBox.background"));
                    } else {
                        graphics.setColor(UIManager.getColor("CheckBox.interiorBackground"));
                    }
                    graphics.fillRect(n2 + 2, n3 + 2, 9, 9);
                }
                if (buttonModel.isEnabled()) {
                    graphics.setColor(UIManager.getColor("CheckBox.foreground"));
                } else {
                    graphics.setColor(UIManager.getColor("CheckBox.shadow"));
                }
                if (component instanceof TristateCheckBox && ((TristateCheckBox)component).getModel() instanceof TristateButtonModel && ((TristateButtonModel)((TristateCheckBox)component).getModel()).isMixed()) {
                    this.drawSquare(component, graphics, n2, n3);
                } else if (buttonModel.isSelected()) {
                    graphics.drawLine(n2 + 9, n3 + 3, n2 + 9, n3 + 3);
                    graphics.drawLine(n2 + 8, n3 + 4, n2 + 9, n3 + 4);
                    graphics.drawLine(n2 + 7, n3 + 5, n2 + 9, n3 + 5);
                    graphics.drawLine(n2 + 6, n3 + 6, n2 + 8, n3 + 6);
                    graphics.drawLine(n2 + 3, n3 + 7, n2 + 7, n3 + 7);
                    graphics.drawLine(n2 + 4, n3 + 8, n2 + 6, n3 + 8);
                    graphics.drawLine(n2 + 5, n3 + 9, n2 + 5, n3 + 9);
                    graphics.drawLine(n2 + 3, n3 + 5, n2 + 3, n3 + 5);
                    graphics.drawLine(n2 + 3, n3 + 6, n2 + 4, n3 + 6);
                }
            }
        }

        protected void drawSquare(Component component, Graphics graphics, int n2, int n3) {
            int n4 = this.getIconWidth();
            int n5 = this.getIconHeight();
            int n6 = n4 / 3;
            graphics.fillRect(n2 + n6, n3 + n6, n4 - n6 * 2, n5 - n6 * 2);
        }

        @Override
        public int getIconWidth() {
            if (!SystemInfo.isJdk17Above()) {
                XPStyle xPStyle = XPStyle.getXP();
                if (xPStyle != null) {
                    if (cw == -1) {
                        cw = xPStyle.getSkin(null, TMSchema.Part.BP_CHECKBOX).getWidth();
                    }
                    return cw;
                }
                return 13;
            }
            return 13;
        }

        @Override
        public int getIconHeight() {
            if (!SystemInfo.isJdk17Above()) {
                XPStyle xPStyle = XPStyle.getXP();
                if (xPStyle != null) {
                    if (ch == -1) {
                        ch = xPStyle.getSkin(null, TMSchema.Part.BP_CHECKBOX).getHeight();
                    }
                    return ch;
                }
                return 13;
            }
            return 13;
        }
    }
}

