/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.converter;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverter;
import com.jidesoft.converter.Resource;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.ResourceBundle;

public class QuarterNameConverter
implements ObjectConverter {
    public static ConverterContext CONTEXT = new ConverterContext("QuarterName");
    private static String _quarterNamePattern;

    @Override
    public String toString(Object object, ConverterContext converterContext) {
        if (object == null || !(object instanceof Number)) {
            return "";
        }
        int n2 = ((Number)object).intValue();
        if (n2 >= 0 && n2 < 4) {
            return MessageFormat.format(this.getQuarterNamePattern(), n2 + 1);
        }
        return "";
    }

    @Override
    public boolean supportToString(Object object, ConverterContext converterContext) {
        return true;
    }

    @Override
    public Object fromString(String string, ConverterContext converterContext) {
        String string2 = this.getQuarterNamePattern();
        try {
            Object[] objectArray = new MessageFormat(string2).parse(string);
            if (objectArray.length > 0) {
                return Integer.parseInt("" + objectArray[0]) - 1;
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return 0;
    }

    @Override
    public boolean supportFromString(String string, ConverterContext converterContext) {
        return true;
    }

    public String getQuarterNamePattern() {
        if (_quarterNamePattern == null) {
            return this.getResourceString("Quarter.quarter");
        }
        return _quarterNamePattern;
    }

    public void setQuarterNamePattern(String string) {
        _quarterNamePattern = string;
    }

    protected String getResourceString(String string) {
        ResourceBundle resourceBundle = Resource.getResourceBundle(Locale.getDefault());
        return resourceBundle.getString(string);
    }
}

