/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.ChartType;
import com.jidesoft.chart.Drawable;
import com.jidesoft.chart.Frontable;
import com.jidesoft.chart.LegendItem;
import com.jidesoft.chart.Orientation;
import com.jidesoft.chart.PointLegendItem;
import com.jidesoft.chart.a;
import com.jidesoft.chart.l;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.style.ChartStyle;
import com.jidesoft.chart.util.Named;
import com.jidesoft.range.Category;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class Legend
extends JPanel
implements Drawable,
Frontable {
    private static final long serialVersionUID = 3209957448711005879L;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int LEADING = 3;
    public static final int RIGHT = 2;
    public static final int TRAILING = 4;
    public static final String PROPERTY_GENERATE_FROM_POINTS = "GenerateFromPoints";
    public static final String PROPERTY_TITLE = "title";
    public static final String PROPERTY_TITLE_COLOR = "titleColor";
    public static final String PROPERTY_COLUMNS = "columns";
    public static final String PROPERTY_KEY_LABEL_GAP = "keyLabelGap";
    public static final String PROPERTY_LABEL_COLOR = "labelColor";
    public static final String PROPERTY_LEGEND_BACKGROUND = "legendBackground";
    public static final String PROPERTY_ORDER_REVERSED = "order reversed";
    public static final String PROPERTY_AT_FRONT = "At Front";
    public static final String PROPERTY_TITLE_LABEL = "Title Label";
    public static final String PROPERTY_ROLLOVER_MODEL = "Rollover Model";
    private static final Logger a = Logger.getLogger(Legend.class.getName());
    private GridBagLayout b;
    private int c;
    private List<WeakReference<Chart>> d;
    private Set<ChartModel> e;
    private Set<Chartable> f;
    private List<ChartModel> g;
    private List<LegendItem> h;
    private String i;
    private JLabel j;
    private Color k;
    private Color l;
    private long m;
    private PropertyChangeListener n;
    private boolean o;
    private boolean p;
    private Border q;
    private Paint r;
    private boolean s;
    private ChartModel t;
    private int u;

    public Legend() {
        this(null, 1);
    }

    public Legend(boolean bl2, int n2) {
        this(null, 0);
        if (bl2) {
            this.setLayout(new a(n2));
        }
    }

    public Legend(Chart chart) {
        this(chart, 1);
    }

    public Legend(Chart chart, boolean bl2) {
        this(chart, 0);
        if (bl2) {
            this.setLayout(new a());
        }
    }

    public Legend(Chart chart, boolean bl2, int n2) {
        this(chart, 0);
        if (bl2) {
            this.setLayout(new a(n2));
        }
    }

    public Legend(Chart chart, int n2) {
        block3: {
            Legend legend;
            block2: {
                this.b = new GridBagLayout();
                this.c = 1;
                this.d = new ArrayList<WeakReference<Chart>>();
                this.e = new HashSet<ChartModel>();
                Chart[] chartArray = Orientation.b();
                this.f = new HashSet<Chartable>();
                this.g = new ArrayList<ChartModel>();
                this.h = new ArrayList<LegendItem>();
                this.j = null;
                this.k = null;
                this.l = null;
                this.o = false;
                this.p = false;
                this.q = null;
                this.r = null;
                this.s = true;
                this.u = 0;
                this.c = n2;
                this.setLayout(this.b);
                this.setBorder(BorderFactory.createLineBorder(Color.gray));
                legend = this;
                if (chartArray == null) break block2;
                legend.n = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        block4: {
                            block3: {
                                boolean bl2;
                                block2: {
                                    Chart[] chartArray = Orientation.b();
                                    String string = propertyChangeEvent.getPropertyName();
                                    bl2 = "Model".equals(string);
                                    if (chartArray == null) break block2;
                                    if (bl2) break block3;
                                    bl2 = "ChartStyle".equals(string);
                                }
                                if (!bl2) break block4;
                            }
                            Legend.this.updateLegend();
                        }
                    }
                };
                if (chart == null) break block3;
                legend = this;
            }
            legend.addChart(chart);
        }
        b b2 = new b(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                block8: {
                    Object Source;
                    block9: {
                        Component component;
                        Chart[] chartArray;
                        block7: {
                            boolean bl2;
                            Component component2;
                            block6: {
                                Point point = mouseEvent.getPoint();
                                component2 = Legend.this.getComponentAt(point);
                                chartArray = Orientation.b();
                                Component component3 = component2;
                                if (chartArray != null) {
                                    if (component3 == null) {
                                        return;
                                    }
                                    component3 = component2;
                                }
                                bl2 = component3 instanceof JLabel;
                                if (chartArray == null) break block6;
                                if (bl2) {
                                    component2 = ((JLabel)component2).getLabelFor();
                                }
                                component = component2;
                                if (chartArray == null) break block7;
                                bl2 = component instanceof LegendItem;
                            }
                            if (!bl2) break block8;
                            component = component2;
                        }
                        LegendItem legendItem = (LegendItem)((Object)component);
                        Source = legendItem.getSource();
                        if (chartArray == null) break block9;
                        if (!(Source instanceof ChartModel)) break block8;
                        Source = legendItem.getSource();
                    }
                    ChartModel chartModel = (ChartModel)Source;
                    Legend.this.a(chartModel);
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                Legend.this.a(null);
            }
        };
        this.addMouseListener(b2);
        this.addMouseMotionListener(b2);
    }

    public int getKeyLabelGap() {
        return this.u;
    }

    public void setKeyLabelGap(int n2) {
        int n3 = this.u;
        this.u = n2;
        this.firePropertyChange(PROPERTY_KEY_LABEL_GAP, n3, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Paint getLegendBackground() {
        Paint paint;
        Chart[] chartArray = Orientation.b();
        Legend legend = this;
        if (chartArray != null) {
            if (legend.r == null) {
                paint = this.getBackground();
                return paint;
            }
            legend = this;
        }
        paint = legend.r;
        return paint;
    }

    public void setLegendBackground(Paint paint) {
        Paint paint2 = this.r;
        this.r = paint;
        this.repaint();
        this.firePropertyChange(PROPERTY_LEGEND_BACKGROUND, paint2, paint);
    }

    public Color getLabelColor() {
        return this.k;
    }

    public void setLabelColor(Color color) {
        Color color2 = this.k;
        this.k = color;
        this.updateLegend();
        this.firePropertyChange(PROPERTY_LABEL_COLOR, color2, color);
    }

    public Color getTitleColor() {
        return this.l;
    }

    public void setTitleColor(Color color) {
        Color color2 = this.l;
        this.l = color;
        Chart[] chartArray = Orientation.b();
        Legend legend = this;
        if (chartArray != null) {
            if (legend.j != null) {
                this.j.setForeground(color);
            }
            this.updateLegend();
            legend = this;
        }
        legend.firePropertyChange(PROPERTY_TITLE_COLOR, color2, color);
    }

    private void a(ChartModel chartModel) {
        ChartModel chartModel2 = this.t;
        this.t = chartModel;
        this.firePropertyChange(PROPERTY_ROLLOVER_MODEL, chartModel2, chartModel);
    }

    public void addExcludedModels(ChartModel ... chartModelArray) {
        Collections.addAll(this.e, chartModelArray);
        this.updateLegend();
    }

    public void removeExcludedModels(ChartModel ... chartModelArray) {
        block2: {
            ChartModel[] chartModelArray2 = chartModelArray;
            int n2 = chartModelArray2.length;
            Chart[] chartArray = Orientation.b();
            for (int i2 = 0; i2 < n2; ++i2) {
                ChartModel chartModel = chartModelArray2[i2];
                this.e.remove(chartModel);
                if (chartArray != null) {
                    if (chartArray != null) continue;
                }
                break block2;
            }
            this.updateLegend();
        }
    }

    public void clearExcludedModels() {
        this.e.clear();
        this.updateLegend();
    }

    public Legend addIncludedModel(ChartModel chartModel) {
        this.g.add(chartModel);
        this.updateLegend();
        return this;
    }

    public Legend removeIncludedModel(ChartModel chartModel) {
        this.g.remove(chartModel);
        this.updateLegend();
        return this;
    }

    public Legend addLegendItem(LegendItem legendItem) {
        this.h.add(legendItem);
        this.updateLegend();
        return this;
    }

    public Legend removeLegendItem(LegendItem legendItem) {
        this.h.remove(legendItem);
        this.updateLegend();
        return this;
    }

    public void addExcludedPoints(Chartable ... chartableArray) {
        Collections.addAll(this.f, chartableArray);
        this.updateLegend();
    }

    public void removeExcludedPoints(Chartable ... chartableArray) {
        block2: {
            Chartable[] chartableArray2 = chartableArray;
            int n2 = chartableArray2.length;
            Chart[] chartArray = Orientation.b();
            for (int i2 = 0; i2 < n2; ++i2) {
                Chartable chartable = chartableArray2[i2];
                this.f.remove(chartable);
                if (chartArray != null) {
                    if (chartArray != null) continue;
                }
                break block2;
            }
            this.updateLegend();
        }
    }

    public void clearExcludedPoints() {
        this.f.clear();
    }

    @Override
    public void setBorder(Border border) {
        this.q = border;
        this.updateLegend();
    }

    public void addChart(Chart chart) {
        WeakReference<Chart> weakReference = new WeakReference<Chart>(chart);
        this.d.add(weakReference);
        chart.addPropertyChangeListener(this.n);
        this.updateLegend();
    }

    public void removeChart(Chart chart) {
        Chart chart2;
        block3: {
            Chart[] chartArray = Orientation.b();
            for (int i2 = this.d.size() - 1; i2 >= 0; --i2) {
                Chart chart3;
                WeakReference<Chart> weakReference = this.d.get(i2);
                chart2 = chart3 = (Chart)weakReference.get();
                if (chartArray != null) {
                    Object object;
                    if (chartArray == null) continue;
                    if (chart2 != null) {
                        object = chart;
                        if (chartArray == null || !object.equals(chart3)) continue;
                    }
                    object = this.d.remove(i2);
                    if (chartArray != null) continue;
                }
                break block3;
            }
            chart2 = chart;
        }
        chart2.removePropertyChangeListener(this.n);
    }

    public void setColumns(int n2) {
        int n3 = this.c;
        this.c = n2;
        this.updateLegend();
        this.firePropertyChange(PROPERTY_COLUMNS, n3, n2);
    }

    public void clear() {
        this.d.clear();
    }

    public String getTitle() {
        return this.i;
    }

    public void setTitle(String string) {
        String string2;
        block7: {
            Chart[] chartArray;
            block6: {
                block5: {
                    chartArray = Orientation.b();
                    string2 = this.i;
                    if (chartArray == null) break block5;
                    if (string != null) break block6;
                    this.j = null;
                }
                if (chartArray != null) break block7;
            }
            Legend legend = this;
            if (chartArray != null) {
                if (legend.j == null) {
                    this.j = this.createLegendTitle(string);
                }
                legend = this;
            }
            legend.i = string;
        }
        this.firePropertyChange(PROPERTY_TITLE, string2, string);
        this.updateLegend();
    }

    public JLabel getTitleLabel() {
        return this.j;
    }

    public void setTitleLabel(JLabel jLabel) {
        JLabel jLabel2 = this.j;
        this.j = jLabel;
        this.firePropertyChange(PROPERTY_TITLE_LABEL, jLabel2, jLabel);
    }

    public boolean isGenerateFromPoints() {
        return this.o;
    }

    public void setGenerateFromPoints(boolean bl2) {
        boolean bl3 = this.o;
        this.o = bl2;
        this.updateLegend();
        this.firePropertyChange(PROPERTY_GENERATE_FROM_POINTS, bl3, bl2);
    }

    public boolean isOrderReversed() {
        return this.p;
    }

    public void setOrderReversed(boolean bl2) {
        boolean bl3 = this.p;
        this.p = bl2;
        this.updateLegend();
        this.firePropertyChange(PROPERTY_ORDER_REVERSED, bl3, bl2);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.updateLegend();
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    protected void updateLegend() {
        block37: {
            block29: {
                block28: {
                    this.removeAll();
                    v0 = Orientation.b();
                    super.setBorder(null);
                    var1_1 = v0;
                    v1 = this;
                    if (var1_1 != null) {
                        if (v1.j != null) {
                            var2_2 = new GridBagConstraints(0, 0, this.c, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0);
                            this.add((Component)this.j, var2_2);
                        }
                        v1 = this;
                    }
                    if (v1.d == null) {
                        return;
                    }
                    var2_2 = new ArrayList<E>();
                    for (Object var4_4 : this.d) {
                        block31: {
                            block27: {
                                block34: {
                                    block32: {
                                        block33: {
                                            block30: {
                                                v2 /* !! */  = var4_4;
                                                if (var1_1 == null) ** GOTO lbl21
                                                if (v2 /* !! */  == null) {
                                                    v3 = null;
                                                } else {
                                                    v2 /* !! */  = var4_4.get();
lbl21:
                                                    // 2 sources

                                                    v3 = (Chart)v2 /* !! */ ;
                                                }
                                                var5_6 = v3;
                                                v4 = var5_6;
                                                if (var1_1 == null) break block30;
                                                if (v4 == null) break block31;
                                                v4 = var5_6;
                                            }
                                            var6_8 = v4.getChartType();
                                            if (var1_1 == null) break block32;
                                            if (var6_8 == ChartType.PIE) break block33;
                                            v5 = this.o;
                                            if (var1_1 == null) break block32;
                                            if (!v5) break block34;
                                        }
                                        v5 = var2_2.addAll(this.a((Chart)var5_6));
                                    }
                                    if (var1_1 != null) break block31;
                                }
                                var7_9 = new ArrayList<ChartModel>(var5_6.getModels());
                                for (ChartModel var9_11 : this.g) {
                                    var7_9.add((ChartModel)var9_11);
                                    if (var1_1 != null) {
                                        if (var1_1 != null) continue;
                                    }
                                    break block27;
                                }
                                v6 = this.isOrderReversed();
                                if (var1_1 == null) break block31;
                                if (v6) {
                                    Collections.reverse(var7_9);
                                }
                            }
                            v6 = var2_2.addAll(this.a((Chart)var5_6, (List<ChartModel>)var7_9));
                        }
                        if (var1_1 != null) continue;
                    }
                    var3_3 = new ArrayList<LegendItem>(this.h);
                    if (this.isOrderReversed()) {
                        Collections.reverse(var3_3);
                    }
                    var4_4 = var3_3.iterator();
                    while (var4_4.hasNext()) {
                        var5_6 = (LegendItem)var4_4.next();
                        v7 = var2_2.add(this.createLegendPair((LegendItem)var5_6, this.createLegendLabel(var5_6.getLabel())));
                        if (var1_1 != null) {
                            if (var1_1 != null) continue;
                        }
                        break block28;
                    }
                    v7 = 0;
                }
                var4_5 = v7;
                var5_7 = 1;
                var6_8 = var2_2.iterator();
                while (var6_8.hasNext()) {
                    block36: {
                        block35: {
                            var7_9 = (l)var6_8.next();
                            var8_10 = new GridBagConstraints(var4_5, var5_7, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 2, 0, 2), 10, 0);
                            this.add((Component)var7_9, var8_10);
                            ++var4_5;
                            v8 = this.c;
                            if (var1_1 == null) break block29;
                            if (var1_1 == null) break block35;
                            if (v8 <= 0) break block36;
                            v9 = var4_5;
                        }
                        if (var1_1 != null && v9 >= this.c) {
                            ++var5_7;
                            v9 = var4_5 = 0;
                        }
                    }
                    if (var1_1 != null) continue;
                }
                v10 = this;
                if (var1_1 == null) break block37;
                v8 = v10.getComponentCount();
            }
            if (v8 > 0) {
                super.setBorder(this.q);
            }
            v10 = this;
        }
        v10.m = System.currentTimeMillis();
    }

    private List<l> a(Chart chart) {
        int n2;
        ArrayList<l> arrayList = new ArrayList<l>();
        ChartModel chartModel = chart.getModel();
        Chart[] chartArray = Orientation.b();
        int n3 = 0;
        int n4 = 1;
        int n5 = this.isOrderReversed();
        if (chartArray != null) {
            if (n5 != 0) {
                n3 = chartModel.getPointCount() - 1;
                n4 = -1;
            }
            n5 = n2 = n3;
        }
        while (n2 >= 0 && chartModel != null && n2 < chartModel.getPointCount()) {
            Chartable chartable = chartModel.getPoint(n2);
            LegendItem legendItem = this.createPointLegendItem(chartable, chartModel, chart);
            JLabel jLabel = this.createLegendLabel(chartable);
            l l2 = this.createLegendPair(legendItem, jLabel);
            arrayList.add(l2);
            n2 += n4;
            if (chartArray != null) continue;
        }
        return arrayList;
    }

    protected LegendItem createPointLegendItem(Chartable chartable, ChartModel chartModel, Chart chart) {
        return new PointLegendItem(chartable, chartModel, chart);
    }

    private List<l> a(Chart chart, List<ChartModel> list) {
        ArrayList<l> arrayList = new ArrayList<l>();
        Iterator<ChartModel> iterator = list.iterator();
        Chart[] chartArray = Orientation.b();
        while (iterator.hasNext()) {
            block4: {
                Legend legend;
                ChartModel chartModel;
                block3: {
                    chartModel = iterator.next();
                    legend = this;
                    if (chartArray == null) break block3;
                    if (legend.e.contains(chartModel)) break block4;
                    legend = this;
                }
                LegendItem legendItem = legend.createModelLegendItem(chartModel, chart);
                JComponent jComponent = this.createLegendLabel(chartModel);
                l l2 = this.createLegendPair(legendItem, jComponent);
                arrayList.add(l2);
            }
            if (chartArray != null) continue;
        }
        return arrayList;
    }

    protected LegendItem createModelLegendItem(ChartModel chartModel, Chart chart) {
        return new d(chartModel, chart);
    }

    protected LegendItem createModelLegendItem(ChartModel chartModel, Chart chart, ChartStyle chartStyle) {
        return new d(chartModel, chart, chartStyle);
    }

    protected l createLegendPair(LegendItem legendItem, JComponent jComponent) {
        return new l(this, legendItem, jComponent);
    }

    /*
     * Unable to fully structure code
     */
    protected JLabel createLegendLabel(Chartable var1_1) {
        block10: {
            block9: {
                var2_2 = Orientation.b();
                v0 = var1_1;
                if (var2_2 != null) {
                    if (v0 instanceof Named) {
                        v0 = var1_1;
                        if (var2_2 != null) {
                            var3_3 = ((Named)v0).getName();
                            if (var3_3 != null) {
                                return new JLabel((String)var3_3);
                            } else {
                                ** GOTO lbl-1000
                            }
                        }
                    } else lbl-1000:
                    // 3 sources

                    {
                        v0 = var1_1;
                    }
                }
                var3_3 = v0.getX();
                var4_4 = Double.toString(var3_3.position());
                v1 = var3_3;
                if (var2_2 == null) break block9;
                if (!(v1 instanceof Category)) break block10;
                v1 = var3_3;
            }
            var5_5 = (Category)v1;
            var4_4 = var5_5.getName();
        }
        return new JLabel(var4_4);
    }

    protected JComponent createLegendLabel(ChartModel chartModel) {
        return this.createLegendLabel(chartModel.getName());
    }

    protected JComponent createLegendLabel(String string) {
        Chart[] chartArray = Orientation.b();
        JLabel jLabel = new JLabel(string, 2);
        if (chartArray != null) {
            if (this.k != null) {
                jLabel.setForeground(this.k);
            }
            jLabel.setFont(this.getFont());
        }
        return jLabel;
    }

    protected JLabel createLegendTitle(String string) {
        Chart[] chartArray = Orientation.b();
        JLabel jLabel = new JLabel(string, 0);
        if (chartArray != null) {
            if (this.l != null) {
                jLabel.setForeground(this.l);
            }
            jLabel.setFont(this.getFont());
        }
        return jLabel;
    }

    @Override
    public boolean isAtFront() {
        return this.s;
    }

    @Override
    public void setAtFront(boolean bl2) {
        boolean bl3 = this.s;
        this.s = bl2;
        this.firePropertyChange(PROPERTY_AT_FRONT, bl3, bl2);
    }

    @Override
    public void draw(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        this.validate();
        this.doLayout();
        this.setSize(this.getPreferredSize());
        int n2 = this.getX();
        int n3 = this.getY();
        graphics.translate(n2, n3);
        this.print(graphics);
        graphics.translate(-n2, -n3);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void paintComponent(Graphics var1_1) {
        block6: {
            block5: {
                var2_2 = Orientation.b();
                v0 = this;
                if (var2_2 == null) break block5;
                if (v0.isOpaque()) break block6;
                v0 = this;
            }
            super.paintComponent(var1_1);
            return;
        }
        var3_3 = (Graphics2D)var1_1;
        v1 = this;
        if (var2_2 == null) ** GOTO lbl17
        if (v1.r == null) {
            v2 = this.getBackground();
        } else {
            v1 = this;
lbl17:
            // 2 sources

            v2 = v1.r;
        }
        var4_4 = v2;
        var5_5 = this.getWidth();
        var6_6 = this.getHeight();
        var3_3.setPaint(var4_4);
        var3_3.fillRect(0, 0, var5_5, var6_6);
        this.setOpaque(false);
        super.paintComponent(var1_1);
        this.setOpaque(true);
    }

    static class d
    extends JComponent
    implements LegendItem<ChartModel, ChartModel> {
        private static final long serialVersionUID = 8445473530598990518L;
        private ChartModel a;
        private Chart b;
        private ChartStyle c;

        public d(ChartModel chartModel, Chart chart) {
            this(chartModel, chart, chart.getStyle(chartModel));
        }

        public d(ChartModel chartModel, Chart chart, ChartStyle chartStyle) {
            Chart[] chartArray = Orientation.b();
            this.setOpaque(false);
            this.a = chartModel;
            Chart[] chartArray2 = chartArray;
            this.b = chart;
            if (chartArray2 != null) {
                if (chartStyle == null) {
                    chartStyle = ChartStyle.DEFAULT_STYLE;
                }
                this.c = chartStyle;
            }
            int n2 = 1 + Math.max(20, chartStyle.getPointSize());
            int n3 = 1 + Math.max(30, chartStyle.getPointSize());
            Dimension dimension = new Dimension(n3, n2);
            this.setMinimumSize(dimension);
            this.setSize(dimension);
            this.setPreferredSize(dimension);
        }

        @Override
        public Component getComponent() {
            return this;
        }

        @Override
        public String getLabel() {
            return this.a.getName();
        }

        @Override
        public ChartModel getSource() {
            return this.a;
        }

        @Override
        public ChartModel getItem() {
            return this.a;
        }

        @Override
        public void paintComponent(Graphics graphics) {
            Graphics2D graphics2D;
            block14: {
                d d2;
                Object object;
                int n2;
                int n3;
                block13: {
                    boolean bl2;
                    block12: {
                        Chart[] chartArray;
                        block9: {
                            block10: {
                                block11: {
                                    graphics2D = (Graphics2D)graphics.create();
                                    Chart[] chartArray2 = Orientation.b();
                                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                                    chartArray = chartArray2;
                                    Dimension dimension = this.getSize();
                                    n3 = dimension.height;
                                    n2 = dimension.width;
                                    ChartStyle chartStyle = this.c;
                                    if (chartArray != null) {
                                        if (chartStyle == null) {
                                            return;
                                        }
                                        chartStyle = this.c;
                                    }
                                    bl2 = chartStyle.isLinesVisible();
                                    if (chartArray == null) break block9;
                                    if (!bl2) break block10;
                                    object = this.b.getLineRenderer(this.a);
                                    if (this.c.getLineFill() == null) break block11;
                                    int[] nArray = new int[]{5, 5 + (n2 - 10) / 2, n2 - 5};
                                    int[] nArray2 = new int[]{3 * n3 / 4, (int)Math.round((double)n3 / 2.0) - 1, 3 * n3 / 4};
                                    object.renderLine(graphics2D, null, nArray, nArray2, this.c);
                                    if (chartArray != null) break block10;
                                }
                                object.renderLine(graphics2D, null, new int[]{5, n2 - 5}, new int[]{n3 / 2, n3 / 2}, this.c);
                            }
                            bl2 = this.c.isPointsVisible();
                        }
                        if (chartArray == null) break block12;
                        if (bl2) {
                            object = this.b.getPointRenderer(this.a);
                            object.renderPoint(graphics2D, this.b, this.a, null, false, false, false, n2 / 2, n3 / 2);
                        }
                        d2 = this;
                        if (chartArray == null) break block13;
                        bl2 = d2.c.isBarsVisible();
                    }
                    if (!bl2) break block14;
                    d2 = this;
                }
                object = d2.b.getBarRenderer(this.a);
                object.renderBar(graphics2D, this.b, this.a, null, false, false, false, 5, n3 / 4, n2 - 10, n3 / 2);
            }
            graphics2D.dispose();
        }
    }

    class b
    implements MouseListener,
    MouseMotionListener {
        b() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }
}

