/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.screens;

import com.install4j.api.beaninfo.BeanInitializer;
import com.install4j.api.beaninfo.BeanValidationException;
import com.install4j.api.beaninfo.BeanValidator;
import com.install4j.api.beaninfo.Install4JPropertyDescriptor;
import com.install4j.api.beans.Bean;
import com.install4j.runtime.beans.BeanInfo;
import com.install4j.runtime.beans.actions.desktop.CreateDefaultStartMenuEntriesAction;
import com.install4j.runtime.beans.common.BeanInfoUtil;
import com.install4j.runtime.beans.common.CategoryUtil;
import com.install4j.runtime.beans.screens.InstallationScreen;
import com.install4j.runtime.beans.screens.ScreenSorter;
import com.install4j.runtime.beans.screens.StandardProgramGroupScreen;
import com.install4j.runtime.beans.screens.SystemScreenBeanInfo;

@BeanInfo
public class StandardProgramGroupScreenBeanInfo
extends SystemScreenBeanInfo
implements BeanInitializer,
BeanValidator {
    public static final String NAME = "Create program group";
    private static final Class<StandardProgramGroupScreen> BEAN_CLASS = StandardProgramGroupScreen.class;
    private static final String PROPERTY_ALLOW_USER_CHANGE_ENABLED = "allowUserChangeEnabled";
    private static final String PROPERTY_ALLOW_USER_CHANGE_ALL_USERS = "allowUserChangeAllUsers";
    private static final String PROPERTY_PROGRAM_GROUP_ENABLED = "programGroupEnabled";
    private static final String PROPERTY_PROGRAM_GROUP_NAME = "programGroupName";
    private static final String PROPERTY_ALL_USERS = "allUsers";
    private static final String PROPERTY_SHOW_WARNING_IF_EXISTS = "showWarningIfExists";
    private static final String PROPERTY_UNIX_SYMLINKS = "unixSymlinks";
    private static final String PROPERTY_LINK_DIRECTORY = "linkDirectory";

    public StandardProgramGroupScreenBeanInfo() {
        super(NAME, "A screen that allows the user to select the default program group. Under Windows, this screen sets installer variables that influence \"Create program group\" and \"Create start menu entry\" entry actions. Under Unix, the screen asks the user whether and where symbolic links to launchers should be created. Under macOS, the screen is not shown.", "Standard screens", false, false, ScreenSorter.getSortKey(BEAN_CLASS), BEAN_CLASS);
        this.addPropertyDescriptor(CategoryUtil.categoryWindows(Install4JPropertyDescriptor.create((String)PROPERTY_PROGRAM_GROUP_NAME, (Class)this.getBeanClass(), (String)"Program group name", (String)"The default value for the program group where entries for all relevant launchers (those with \"menu integration\" enabled) will be created. If the \"Create program group\" screen is present, the user can change this selection. If you leave this property empty, the links will be created at the top level. The user selection will be saved to the variable <tt>sys.programGroupName</tt>.")));
        this.addPropertyDescriptor(CategoryUtil.categoryUnix(Install4JPropertyDescriptor.create((String)PROPERTY_UNIX_SYMLINKS, (Class)this.getBeanClass(), (String)"Create symlinks", (String)"If symbolic links for all relevant launchers (those with \"menu integration\" enabled) should be created on UNIX. If this property is deselected, the variable <tt>sys.programGroupDisabled</tt> will be set to <tt>Boolean.TRUE</tt> in Linux/Unix installers.")));
        this.addPropertyDescriptor(BeanInfoUtil.reparent(PROPERTY_UNIX_SYMLINKS, Install4JPropertyDescriptor.create((String)PROPERTY_LINK_DIRECTORY, (Class)this.getBeanClass(), (String)"Directory for links", (String)"The default value for the directory in which links for all relevant launchers (those with \"menu integration\" enabled) will be created on UNIX. The user selection will be saved to the variable <tt>sys.symlinkDir</tt>.")));
        this.addPropertyDescriptor(CategoryUtil.categoryGeneral(Install4JPropertyDescriptor.create((String)PROPERTY_ALLOW_USER_CHANGE_ENABLED, (Class)this.getBeanClass(), (String)"User can disable creation", (String)"If the user can disable all program group actions that rely on a default program group, such as the \"Create default start menu entries\". If the user disables program group creation, the variable <tt>sys.programGroupDisabled</tt> will be set to <tt>Boolean.TRUE</tt>.")));
        this.addPropertyDescriptor(BeanInfoUtil.reparent(PROPERTY_ALLOW_USER_CHANGE_ENABLED, Install4JPropertyDescriptor.create((String)PROPERTY_PROGRAM_GROUP_ENABLED, (Class)this.getBeanClass(), (String)"Initially enabled", (String)"If the checkbox for enabling program group or launcher link creation should be selected by default.")));
        this.addPropertyDescriptor(CategoryUtil.categoryWindows(Install4JPropertyDescriptor.create((String)PROPERTY_ALLOW_USER_CHANGE_ALL_USERS, (Class)this.getBeanClass(), (String)"User can change \"all users\"", (String)"If the user can override the default value of the \"Create for all users\" property in the \"Create default start menu entries\" action. The user selection will be saved to the variable <tt>sys.programGroupAllUsers</tt>.")));
        this.addPropertyDescriptor(BeanInfoUtil.reparent(PROPERTY_ALLOW_USER_CHANGE_ALL_USERS, Install4JPropertyDescriptor.create((String)PROPERTY_ALL_USERS, (Class)this.getBeanClass(), (String)"Initially selected", (String)"If the \"Create for all users\" check box be selected by default.")));
        this.addPropertyDescriptor(CategoryUtil.categoryWindows(Install4JPropertyDescriptor.create((String)PROPERTY_SHOW_WARNING_IF_EXISTS, (Class)this.getBeanClass(), (String)"Show warning if program group exists", (String)"If selected, a warning will be shown if the selected program group already exists.")));
        this.setAssociatedAction(CreateDefaultStartMenuEntriesAction.class.getName(), InstallationScreen.class.getName());
        this.onlyIfNotStreamlined();
    }

    public void initializeBean(Bean bean) {
        ((StandardProgramGroupScreen)bean).setProgramGroupName("${compiler:sys.fullName}");
    }

    public void validateBean(Bean bean) throws BeanValidationException {
        if (((StandardProgramGroupScreen)bean).isUnixSymlinks()) {
            this.checkNotEmpty(PROPERTY_LINK_DIRECTORY, bean);
        }
    }
}

