/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.screens;

import com.install4j.api.beaninfo.BeanInitializer;
import com.install4j.api.beaninfo.CustomizerPlacement;
import com.install4j.api.beaninfo.Install4JBeanInfo;
import com.install4j.api.beaninfo.Install4JPropertyDescriptor;
import com.install4j.api.beans.Bean;
import com.install4j.config.a.g;
import com.install4j.config.a.h;
import com.install4j.runtime.beans.BeanInfo;
import com.install4j.runtime.beans.common.BeanInfoUtil;
import com.install4j.runtime.beans.common.DescriptionUtil;
import com.install4j.runtime.beans.customizers.installationtype.InstallationTypeCustomizer;
import com.install4j.runtime.beans.screens.InstallationTypeScreen;
import com.install4j.runtime.beans.screens.ScreenSorter;
import com.install4j.runtime.beans.screens.SystemScreenBeanInfo;
import com.install4j.runtime.beans.screens.installationtype.ComponentsSelectionType;
import com.install4j.runtime.beans.screens.installationtype.InstallationTypeConfig;
import com.install4j.runtime.installer.frontend.Messages;
import java.util.List;

@BeanInfo
public class InstallationTypeScreenBeanInfo
extends SystemScreenBeanInfo
implements BeanInitializer,
h {
    private static final Class<InstallationTypeScreen> BEAN_CLASS = InstallationTypeScreen.class;
    private static final String PROPERTY_INSTALLATION_TYPE_CONFIGS = "installationTypeConfigs";
    private g beanConfig;

    public InstallationTypeScreenBeanInfo() {
        super("Installation type", "A screen that displays a list of installation types that correspond to configurable set of installation components. The default types \"Full\",\"Standard\" and \"Customize\" are provided by default, with localized names and descriptions. Installation components are configured in the install4j IDE on the \"Files->Installation Components\" step<p> The \"Installation components\" screen may be hidden by this screen, depending on the installation type selected by the user. This screen will not be shown if no installation components are defined.</p>", "Standard screens", false, false, ScreenSorter.getSortKey(BEAN_CLASS), BEAN_CLASS, InstallationTypeCustomizer.class);
        BeanInfoUtil.addExtraHelp((Install4JBeanInfo)this, "<p>You can choose for each installation type if it should be customizable or not. If the installation type that is selected by the user is customizable, the \"Installation components\" screen will be shown if present, otherwise that screen will be skipped. This condition can also be checked by inspecting the boolean value of the installer variable <tt>sys.preventComponentCustomization</tt>.</p>");
        this.setCustomizerPlacement(CustomizerPlacement.BEFORE_PROPERTIES);
        DescriptionUtil.initBean((Install4JBeanInfo)this);
        this.addPropertyDescriptor(Install4JPropertyDescriptor.create((String)PROPERTY_INSTALLATION_TYPE_CONFIGS, (Class)this.getBeanClass(), (String)"", (String)""));
        this.onlyIfNotStreamlined();
    }

    public void initializeBean(Bean bean) {
        List<InstallationTypeConfig> list = this.getInstallationTypeConfigs(bean);
        list.add(this.createAllConfig());
        list.add(this.createStandardConfig());
        list.add(this.createCustomConfig());
    }

    @Override
    public void setBeanConfig(g g2) {
        this.beanConfig = g2;
    }

    private List<InstallationTypeConfig> getInstallationTypeConfigs(Bean bean) {
        InstallationTypeScreen installationTypeScreen = (InstallationTypeScreen)bean;
        return installationTypeScreen.getInstallationTypeConfigs();
    }

    private InstallationTypeConfig createAllConfig() {
        InstallationTypeConfig installationTypeConfig = this.createInstallationTypeConfig();
        installationTypeConfig.setName("${i18n:" + Messages.keyWithoutLeadingDot((String)".FullInstallation") + "}");
        installationTypeConfig.setDescription("${i18n:" + Messages.keyWithoutLeadingDot((String)".FullInstallationDescription") + "}");
        installationTypeConfig.setComponentsSelectionType(ComponentsSelectionType.ALL);
        installationTypeConfig.setUserCanCustomize(false);
        return installationTypeConfig;
    }

    private InstallationTypeConfig createStandardConfig() {
        InstallationTypeConfig installationTypeConfig = this.createInstallationTypeConfig();
        installationTypeConfig.setName("${i18n:" + Messages.keyWithoutLeadingDot((String)".StandardInstallation") + "}");
        installationTypeConfig.setDescription("${i18n:" + Messages.keyWithoutLeadingDot((String)".StandardInstallationDescription") + "}");
        installationTypeConfig.setComponentsSelectionType(ComponentsSelectionType.DEFAULT);
        installationTypeConfig.setUserCanCustomize(false);
        return installationTypeConfig;
    }

    private InstallationTypeConfig createCustomConfig() {
        InstallationTypeConfig installationTypeConfig = this.createInstallationTypeConfig();
        installationTypeConfig.setName("${i18n:" + Messages.keyWithoutLeadingDot((String)".CustomInstallation") + "}");
        installationTypeConfig.setDescription("${i18n:" + Messages.keyWithoutLeadingDot((String)".CustomInstallationDescription") + "}");
        installationTypeConfig.setComponentsSelectionType(ComponentsSelectionType.DEFAULT);
        installationTypeConfig.setUserCanCustomize(true);
        return installationTypeConfig;
    }

    private InstallationTypeConfig createInstallationTypeConfig() {
        InstallationTypeConfig installationTypeConfig = new InstallationTypeConfig();
        installationTypeConfig.setId(String.valueOf(this.beanConfig.p().t()));
        return installationTypeConfig;
    }
}

