/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.registry;

import com.install4j.api.beaninfo.BeanValidationException;
import com.install4j.api.beaninfo.BeanValidator;
import com.install4j.api.beaninfo.Install4JPropertyDescriptor;
import com.install4j.api.beans.Bean;
import com.install4j.runtime.beans.BeanInfo;
import com.install4j.runtime.beans.actions.registry.AbstractRegistryActionBeanInfo;
import com.install4j.runtime.beans.actions.registry.ReadRegistryValueAction;
import com.install4j.runtime.beans.common.BeanInfoUtil;

@BeanInfo
public class ReadRegistryValueActionBeanInfo
extends AbstractRegistryActionBeanInfo
implements BeanValidator {
    private static final String PROPERTY_REGISTRY_ROOT = "registryRoot";
    private static final String PROPERTY_KEY_NAME = "keyName";
    private static final String PROPERTY_VALUE_NAME = "valueName";
    private static final String PROPERTY_USE_DEFAULT = "useDefault";
    private static final String PROPERTY_DEFAULT_VALUE = "defaultValue";
    private static final String PROPERTY_VARIABLE_NAME = "variableName";

    public ReadRegistryValueActionBeanInfo() {
        super("Read a value from the Windows registry", "Read a value from the Windows registry and save it to an installer variable. The type of the value depends on the type in the registry, it will be an instance of one of the following classes: <tt>String, Integer, String[], byte[], WinRegistry.ExpandString</tt>.", "Windows registry", true, false, ReadRegistryValueAction.class);
        this.addPropertyDescriptor(Install4JPropertyDescriptor.create((String)PROPERTY_REGISTRY_ROOT, (Class)this.getBeanClass(), (String)"Registry root", (String)"The Windows registry root where the key is located."));
        this.addPropertyDescriptor(Install4JPropertyDescriptor.create((String)PROPERTY_KEY_NAME, (Class)this.getBeanClass(), (String)"Key name", (String)"The name of the registry key where the value is located without a leading backslash."));
        this.addPropertyDescriptor(Install4JPropertyDescriptor.create((String)PROPERTY_VALUE_NAME, (Class)this.getBeanClass(), (String)"Value name", (String)"The name of the registry value whose string content should be read."));
        this.addPropertyDescriptor(Install4JPropertyDescriptor.create((String)PROPERTY_USE_DEFAULT, (Class)this.getBeanClass(), (String)"Use a default value", (String)"If selected, a default value will be saved to the variable if the key cannot be found in the registry. Otherwise, a missing registry value will result in the failure of the action and the variable will not be set."));
        this.addPropertyDescriptor(BeanInfoUtil.reparent(PROPERTY_USE_DEFAULT, Install4JPropertyDescriptor.create((String)PROPERTY_DEFAULT_VALUE, (Class)this.getBeanClass(), (String)"Default value", (String)"The default value that will be used if the value cannot be found in the registry.")));
        this.addPropertyDescriptor(Install4JPropertyDescriptor.create((String)PROPERTY_VARIABLE_NAME, (Class)this.getBeanClass(), (String)"Variable name", (String)"The name of the variable that will be set with the value. Enter the variable without the installer prefix and the dollar sign. If the value cannot be found in the registry, the variable value will not be set.", (String)PROPERTY_VARIABLE_NAME));
    }

    public void validateBean(Bean bean) throws BeanValidationException {
        this.checkNotEmpty(PROPERTY_REGISTRY_ROOT, bean);
        this.checkKeyName(PROPERTY_KEY_NAME, bean);
        this.checkNotEmpty(PROPERTY_VARIABLE_NAME, bean);
    }
}

