/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.misc;

import com.install4j.api.beaninfo.ActionElevationType;
import com.install4j.api.beaninfo.BeanValidationException;
import com.install4j.api.beaninfo.BeanValidator;
import com.install4j.api.beaninfo.FilePropertyDescriptor;
import com.install4j.api.beaninfo.FileSelectionMode;
import com.install4j.api.beaninfo.Install4JBeanInfo;
import com.install4j.api.beaninfo.Install4JPropertyDescriptor;
import com.install4j.api.beans.Bean;
import com.install4j.runtime.beans.BeanInfo;
import com.install4j.runtime.beans.actions.SystemActionBeanInfo;
import com.install4j.runtime.beans.actions.misc.RunExecutableAction;
import com.install4j.runtime.beans.common.BeanInfoUtil;
import com.install4j.runtime.beans.common.CategoryUtil;
import com.install4j.runtime.beans.mappers.MapPropertyConverter;
import com.install4j.runtime.beans.propertycustomizers.EnvironmentVariablesCustomizer;
import com.install4j.runtime.installer.helper.launching.InputRedirectionMode;
import com.install4j.runtime.installer.helper.launching.OutputRedirectionMode;

@BeanInfo
public class RunExecutableActionBeanInfo
extends SystemActionBeanInfo
implements BeanValidator {
    public static final String NAME = "Run executable or batch file";
    private static final String PROPERTY_EXECUTABLE = "executable";
    private static final String PROPERTY_WORKING_DIRECTORY = "workingDirectory";
    private static final String PROPERTY_WAIT = "wait";
    private static final String PROPERTY_TIMEOUT = "timeout";
    private static final String PROPERTY_WAIT_FOR_STREAMS = "waitForStreams";
    private static final String PROPERTY_RETURN_CODE_VARIABLE = "returnCodeVariable";
    private static final String PROPERTY_USE_ROLLBACK_EXECUTABLE = "useRollbackExecutable";
    private static final String PROPERTY_ROLLBACK_EXECUTABLE = "rollbackExecutable";
    private static final String PROPERTY_ROLLBACK_WORKING_DIRECTORY = "rollbackWorkingDirectory";
    private static final String PROPERTY_ROLLBACK_ARGUMENTS = "rollbackArguments";
    private static final String PROPERTY_LOG_ARGUMENTS = "logArguments";
    private static final String PROPERTY_STDOUT_FILE = "stdoutFile";
    private static final String PROPERTY_STDOUT_REDIRECTION_MODE = "stdoutRedirectionMode";
    private static final String PROPERTY_STDOUT_VARIABLE_NAME = "stdoutVariableName";
    private static final String PROPERTY_UPDATE_STDOUT_VARIABLE_LINES = "updateStdoutVariableLines";
    private static final String PROPERTY_FAIL_ON_STDOUT_FILE_ERROR = "failOnStdoutFileError";
    private static final String PROPERTY_STDERR_FILE = "stderrFile";
    private static final String PROPERTY_STDERR_REDIRECTION_MODE = "stderrRedirectionMode";
    private static final String PROPERTY_STDERR_VARIABLE_NAME = "stderrVariableName";
    private static final String PROPERTY_UPDATE_STDERR_VARIABLE_LINES = "updateStderrVariableLines";
    private static final String PROPERTY_FAIL_ON_STDERR_FILE_ERROR = "failOnStderrFileError";
    private static final String PROPERTY_STDIN_FILE = "stdinFile";
    private static final String PROPERTY_STDIN_REDIRECTION_MODE = "stdinRedirectionMode";
    private static final String PROPERTY_STDIN_STRING = "stdinString";
    private static final String PROPERTY_FAIL_ON_STDIN_FILE_ERROR = "failOnStdinFileError";
    private static final String PROPERTY_INCLUDE_PARENT_ENVIRONMENT_VARIABLES = "includeParentEnvironmentVariables";
    private static final String PROPERTY_ENVIRONMENT_VARIABLES = "environmentVariables";
    private static final String PROPERTY_SHOW_WINDOWS_CONSOLE = "showWindowsConsole";
    private static final String PROPERTY_KEEP_CONSOLE_WINDOW = "keepConsoleWindow";
    private static final String CONTEXT_ENVIRONMENT_VARIABLES = "environmentVariables";
    private static final String RELATIVE_FILE_NOTICE = " Relative paths are relative to the working directory of the installer application. To use a file in the installation directory, enter a path like <tt>${installer:sys.installationDir}/log.txt</tt>.";
    private static final String NOTE_EXECUTABLE = " Do not add arguments here, but use the separate \"Arguments\" property instead.";

    public RunExecutableActionBeanInfo() {
        super(NAME, "Runs an executable or a Windows batch file. The action can optionally wait for termination of the executable.", "Miscellaneous", true, false, null, RunExecutableAction.class);
        this.setDefaultActionElevationType(ActionElevationType.ELEVATE);
        this.addPropertyDescriptor(Install4JPropertyDescriptor.create((String)PROPERTY_EXECUTABLE, (Class)this.getBeanClass(), (String)"Executable", (String)"The file that should be executed. Do not add arguments here, but use the separate \"Arguments\" property instead."));
        this.addPropertyDescriptor((Install4JPropertyDescriptor)FilePropertyDescriptor.create((String)PROPERTY_WORKING_DIRECTORY, (Class)this.getBeanClass(), (String)"Working directory", (String)"The working directory for the execution.", (FileSelectionMode)FileSelectionMode.DIRECTORIES_ONLY));
        this.addPropertyDescriptor(Install4JPropertyDescriptor.create((String)"arguments", (Class)this.getBeanClass(), (String)"Arguments", (String)("The arguments passed to the executable." + BeanInfoUtil.ARGUMENTS_NOTICE)));
        this.addPropertyDescriptor(Install4JPropertyDescriptor.create((String)PROPERTY_USE_ROLLBACK_EXECUTABLE, (Class)this.getBeanClass(), (String)"Use rollback executable", (String)"If selected, an executable is invoked in the case of rollback. You can configure the executable with the child properties. All other properties, such as redirection and environment variables are shared with the regular executable.").setActionListHiddenKeys(new String[]{"noRollback"}));
        this.addPropertyDescriptor(BeanInfoUtil.reparent(PROPERTY_USE_ROLLBACK_EXECUTABLE, Install4JPropertyDescriptor.create((String)PROPERTY_ROLLBACK_EXECUTABLE, (Class)this.getBeanClass(), (String)"Rollback executable", (String)"The file that should be executed in the case of rollback. Do not add arguments here, but use the separate \"Arguments\" property instead.")));
        this.addPropertyDescriptor(BeanInfoUtil.reparent(PROPERTY_USE_ROLLBACK_EXECUTABLE, (Install4JPropertyDescriptor)FilePropertyDescriptor.create((String)PROPERTY_ROLLBACK_WORKING_DIRECTORY, (Class)this.getBeanClass(), (String)"Rollback working directory", (String)"The working directory for the execution of the rollback executable.", (FileSelectionMode)FileSelectionMode.DIRECTORIES_ONLY)));
        this.addPropertyDescriptor(BeanInfoUtil.reparent(PROPERTY_USE_ROLLBACK_EXECUTABLE, Install4JPropertyDescriptor.create((String)PROPERTY_ROLLBACK_ARGUMENTS, (Class)this.getBeanClass(), (String)"Rollback arguments", (String)("The arguments passed to the rollback executable." + BeanInfoUtil.ARGUMENTS_NOTICE))));
        this.addPropertyDescriptor(Install4JPropertyDescriptor.create((String)PROPERTY_WAIT, (Class)this.getBeanClass(), (String)"Wait for termination", (String)"If the action should wait for termination of the process and check if the return value is 0."));
        this.addPropertyDescriptor(BeanInfoUtil.reparent(PROPERTY_WAIT, Install4JPropertyDescriptor.create((String)PROPERTY_RETURN_CODE_VARIABLE, (Class)this.getBeanClass(), (String)"Variable name for return code", (String)"If set, the return code will be saved to this installer variable. The type of the variable will be <tt>java.lang.Integer</tt>. Under Windows, this variable will always be equal to 0 if the \"Show console window\" option below is selected. If a timeout has been set and the process is killed after the timeout, the return value will be -10000.", (String)"variableName").setVariableValueClass(Integer.class)));
        this.addPropertyDescriptor(BeanInfoUtil.reparent(PROPERTY_WAIT, Install4JPropertyDescriptor.create((String)PROPERTY_TIMEOUT, (Class)this.getBeanClass(), (String)"Timeout in seconds", (String)"If set to a value greater than 0, the executable will be killed after that number of seconds if it does not return earlier.In that case, the return value will be -10000.")));
        this.addPropertyDescriptor(BeanInfoUtil.reparent(PROPERTY_WAIT, Install4JPropertyDescriptor.create((String)PROPERTY_WAIT_FOR_STREAMS, (Class)this.getBeanClass(), (String)"Wait for output streams", (String)"If selected, the action will wait until the output streams of the process are fully written. If the process has launched child processes, this can mean that the action will wait until those child processes have terminated. If that is not desired, please deselect this option.")));
        this.addPropertyDescriptor(Install4JPropertyDescriptor.create((String)PROPERTY_LOG_ARGUMENTS, (Class)this.getBeanClass(), (String)"Log arguments", (String)"If the arguments should be written into the log file or not. Disabled by default due to security reasons."));
        this.addOutputRedirectionProperties("stdout", PROPERTY_STDOUT_REDIRECTION_MODE, PROPERTY_STDOUT_VARIABLE_NAME, PROPERTY_UPDATE_STDOUT_VARIABLE_LINES, PROPERTY_STDOUT_FILE, PROPERTY_FAIL_ON_STDOUT_FILE_ERROR);
        this.addOutputRedirectionProperties("stderr", PROPERTY_STDERR_REDIRECTION_MODE, PROPERTY_STDERR_VARIABLE_NAME, PROPERTY_UPDATE_STDERR_VARIABLE_LINES, PROPERTY_STDERR_FILE, PROPERTY_FAIL_ON_STDERR_FILE_ERROR);
        this.addInputRedirectionProperties();
        this.addPropertyDescriptor(this.categoryEnvironmentVariables(Install4JPropertyDescriptor.create((String)PROPERTY_INCLUDE_PARENT_ENVIRONMENT_VARIABLES, (Class)this.getBeanClass(), (String)"Include parent environment variables", (String)"If selected, the environment variables of the parent process (the installer) will be set. Otherwise, only the environment variables in the \"Specific environment variables\" will be set. This option is ignored on macOS.")));
        this.addPropertyDescriptor(this.categoryEnvironmentVariables(Install4JPropertyDescriptor.create((String)"environmentVariables", (Class)this.getBeanClass(), (String)"Specific environment variables", (String)"Specify additional or modified environment variables that should be set for the executed process.<p>Use previous values with the syntax <tt>${PATH};additional</tt>.</p>", (String)"environmentVariables")));
        this.addPropertyDescriptor(CategoryUtil.categoryWindows(Install4JPropertyDescriptor.create((String)PROPERTY_SHOW_WINDOWS_CONSOLE, (Class)this.getBeanClass(), (String)"Show console window", (String)"Show a console window with the console output of the executable. This makes only sense if a command line executable is called.")));
        this.addPropertyDescriptor(BeanInfoUtil.reparent(PROPERTY_SHOW_WINDOWS_CONSOLE, Install4JPropertyDescriptor.create((String)PROPERTY_KEEP_CONSOLE_WINDOW, (Class)this.getBeanClass(), (String)"Keep console window", (String)"If selected, the console window will not be closed when the executable has finished. The user has to close the console window manually. This can be useful for debugging purposes. If the \"Wait for termination\" property is selected, the action will not terminate until the user has closed the console window.")));
        BeanInfoUtil.addPropertyConverters(new MapPropertyConverter("environmentVariables", EnvironmentVariablesCustomizer.class), (Install4JBeanInfo)this);
    }

    private void addOutputRedirectionProperties(String string, String string2, String string3, String string4, String string5, String string6) {
        this.addPropertyDescriptor(this.categoryRedirection(Install4JPropertyDescriptor.create((String)string2, (Class)this.getBeanClass(), (String)("Redirect " + string), (String)("Redirection mode for " + string))));
        this.addPropertyDescriptor(this.reparent(string2, Install4JPropertyDescriptor.create((String)string3, (Class)this.getBeanClass(), (String)"Installer variable name", (String)("An installer variable name to which the " + string + " output of the executed process is saved. The contents of the variable will not be displayed in the log file.")).setContext("variableName"), OutputRedirectionMode.VARIABLE));
        this.addPropertyDescriptor(this.reparent(string2, Install4JPropertyDescriptor.create((String)string4, (Class)this.getBeanClass(), (String)"Update variable after each line", (String)"If selected, the variable will be updated after each line, otherwise the variable will be updated once the stream is closed.<p>If you select this property, you can use a \"HTML or text display\" form component to display a live view of the output by setting its text to the configured installer variable and configuring the caret to follow the end of the document.</p>"), OutputRedirectionMode.VARIABLE));
        this.addPropertyDescriptor(this.reparent(string2, Install4JPropertyDescriptor.create((String)string5, (Class)this.getBeanClass(), (String)"Redirection file", (String)("A file to which the " + string + " output of the executed process is saved. If you specify <tt>/dev/" + string + "</tt>, the output will be printed to the default <tt>" + string + "</tt> stream of the installer application. Relative paths are relative to the working directory of the installer application. To use a file in the installation directory, enter a path like <tt>${installer:sys.installationDir}/log.txt</tt>.")), OutputRedirectionMode.FILE));
        this.addPropertyDescriptor(this.reparent(string2, Install4JPropertyDescriptor.create((String)string6, (Class)this.getBeanClass(), (String)"Fail on error", (String)"If selected, the action fails if the redirection file cannot be written. Otherwise, errors are silently ignored."), OutputRedirectionMode.FILE));
    }

    private void addInputRedirectionProperties() {
        this.addPropertyDescriptor(this.categoryRedirection(Install4JPropertyDescriptor.create((String)PROPERTY_STDIN_REDIRECTION_MODE, (Class)this.getBeanClass(), (String)"Redirect stdin", (String)"Redirection mode for stdin")));
        this.addPropertyDescriptor(this.reparent(PROPERTY_STDIN_REDIRECTION_MODE, Install4JPropertyDescriptor.create((String)PROPERTY_STDIN_STRING, (Class)this.getBeanClass(), (String)"Input string", (String)"A string that should be fed to the input stream of the executed process.").setContext("multiline"), InputRedirectionMode.STRING));
        this.addPropertyDescriptor(this.reparent(PROPERTY_STDIN_REDIRECTION_MODE, Install4JPropertyDescriptor.create((String)PROPERTY_STDIN_FILE, (Class)this.getBeanClass(), (String)"Redirection file", (String)"A file which should be fed to the input stream of the executed process. If you specify <tt>/dev/stdin</tt>, the input from the default <tt>stdin</tt> stream of the installer application will be used. Relative paths are relative to the working directory of the installer application. To use a file in the installation directory, enter a path like <tt>${installer:sys.installationDir}/log.txt</tt>."), InputRedirectionMode.FILE));
        this.addPropertyDescriptor(this.reparent(PROPERTY_STDIN_REDIRECTION_MODE, Install4JPropertyDescriptor.create((String)PROPERTY_FAIL_ON_STDIN_FILE_ERROR, (Class)this.getBeanClass(), (String)"Fail on error", (String)"If selected, the action fails if the redirection file cannot be written. Otherwise, errors are silently ignored."), InputRedirectionMode.FILE));
    }

    private Install4JPropertyDescriptor reparent(String string, Install4JPropertyDescriptor install4JPropertyDescriptor, Object object) {
        install4JPropertyDescriptor.setParentProperty(string);
        install4JPropertyDescriptor.setVisibilityDiscriminator((bean, object2) -> object == object2);
        return install4JPropertyDescriptor;
    }

    public void validateBean(Bean bean) throws BeanValidationException {
        this.checkNotEmpty(PROPERTY_EXECUTABLE, bean);
        this.checkNotEmpty(PROPERTY_WORKING_DIRECTORY, bean);
        if (((RunExecutableAction)bean).isUseRollbackExecutable()) {
            this.checkNotEmpty(PROPERTY_ROLLBACK_EXECUTABLE, bean);
            this.checkNotEmpty(PROPERTY_ROLLBACK_WORKING_DIRECTORY, bean);
        }
        this.checkRedirection(bean, PROPERTY_STDERR_REDIRECTION_MODE, PROPERTY_STDERR_FILE, PROPERTY_STDERR_VARIABLE_NAME);
        this.checkRedirection(bean, PROPERTY_STDOUT_REDIRECTION_MODE, PROPERTY_STDOUT_FILE, PROPERTY_STDOUT_VARIABLE_NAME);
        this.checkRedirection(bean, PROPERTY_STDIN_REDIRECTION_MODE, PROPERTY_STDIN_FILE, PROPERTY_STDIN_STRING);
    }

    private void checkRedirection(Bean bean, String string, String string2, String string3) throws BeanValidationException {
        Object object = this.getPropertyValue(string, bean);
        if (object == OutputRedirectionMode.FILE || object == InputRedirectionMode.FILE) {
            this.checkNotEmpty(string2, bean);
        } else if (object == OutputRedirectionMode.VARIABLE || object == InputRedirectionMode.STRING) {
            this.checkNotEmpty(string3, bean);
        }
        RunExecutableAction runExecutableAction = (RunExecutableAction)bean;
        if (object instanceof OutputRedirectionMode) {
            OutputRedirectionMode outputRedirectionMode = (OutputRedirectionMode)object;
            if (!runExecutableAction.isWait() && outputRedirectionMode.isWaitRequired()) {
                throw new BeanValidationException("The redirection mode \"" + String.valueOf(object) + "\" requires that the \"Wait for termination\" property is selected.", string);
            }
            if (runExecutableAction.isShowWindowsConsole() && outputRedirectionMode != OutputRedirectionMode.NONE) {
                throw new BeanValidationException("The redirection mode \"" + String.valueOf(object) + "\" requires that the \"Show console window\" property is not selected.", string);
            }
        }
    }

    public Install4JPropertyDescriptor categoryRedirection(Install4JPropertyDescriptor install4JPropertyDescriptor) {
        install4JPropertyDescriptor.setPropertyCategory("Redirection");
        return install4JPropertyDescriptor;
    }

    public Install4JPropertyDescriptor categoryEnvironmentVariables(Install4JPropertyDescriptor install4JPropertyDescriptor) {
        install4JPropertyDescriptor.setPropertyCategory("Environment Variables");
        return install4JPropertyDescriptor;
    }
}

