/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.misc;

import com.install4j.api.beaninfo.ActionElevationType;
import com.install4j.api.beaninfo.Install4JPropertyDescriptor;
import com.install4j.runtime.beans.BeanInfo;
import com.install4j.runtime.beans.actions.SystemActionBeanInfo;
import com.install4j.runtime.beans.actions.misc.PrivilegeRequirement;
import com.install4j.runtime.beans.actions.misc.RequestPrivilegesAction;
import com.install4j.runtime.beans.actions.misc.RequireInstallerPrivilegesAction;
import com.install4j.runtime.beans.common.CategoryUtil;

@BeanInfo
public class RequestPrivilegesActionBeanInfo
extends SystemActionBeanInfo {
    public static final String NAME = "Request privileges";
    private static final String FAILURE_STRATEGY_TEXT = " This property overrides the \"Failure strategy\" property of the action. A separate property is necessary since the behavior can be configured differently for Windows, macOS and Unix.";
    private static final String LINUX_PRIVILEGE_REQUIREMENT = "linuxPrivilegeRequirement";

    public RequestPrivilegesActionBeanInfo() {
        super(NAME, "Requests configurable administrator privileges. On Windows Vista and higher and on macOS, the installer will be restarted with the requested privileges or a helper process will be created that can perform certain actions in a privileged context. When you restart the installer, you should not install files before this action.<p>Please see the help topic on \"Elevation Of Privileges\" for a detailed discussion of this action.</p>", "Miscellaneous", true, false, null, RequestPrivilegesAction.class);
        this.setDefaultActionElevationType(ActionElevationType.NONE, true);
        this.addPropertyDescriptor(CategoryUtil.categoryWindows(Install4JPropertyDescriptor.create((String)"obtainIfAdminWin", (Class)this.getBeanClass(), (String)"Try to obtain full privileges if admin user", (String)"If selected and the user is an admin user with limited privileges on Vista and higher, the action will try to start a new process with full privileges.")));
        this.addPropertyDescriptor(CategoryUtil.categoryWindows(Install4JPropertyDescriptor.create((String)"obtainIfNormalWin", (Class)this.getBeanClass(), (String)"Try to obtain full privileges if normal user", (String)"If selected and the user is a non-admin user, the action will either try to start a new process with full privileges on Vista and higher or fail on previous versions of Windows.")));
        this.addPropertyDescriptor(CategoryUtil.categoryWindows(Install4JPropertyDescriptor.create((String)"failIfNotObtainedWin", (Class)this.getBeanClass(), (String)"Show failure if requested privileges cannot be obtained", (String)"If selected and the privileges required above could not be obtained a failure message will be shown and the installation will be canceled. This property overrides the \"Failure strategy\" property of the action. A separate property is necessary since the behavior can be configured differently for Windows, macOS and Unix.")));
        this.addPropertyDescriptor(CategoryUtil.categoryMacos(Install4JPropertyDescriptor.create((String)"obtainIfAdminMac", (Class)this.getBeanClass(), (String)"Try to obtain root privileges if admin user", (String)"If selected and the user is an admin user, the action will try to start a new process with root privileges. The user will have to enter his password.")));
        this.addPropertyDescriptor(CategoryUtil.categoryMacos(Install4JPropertyDescriptor.create((String)"obtainIfNormalMac", (Class)this.getBeanClass(), (String)"Try to obtain root privileges if normal user", (String)"If selected and the user is a non-admin user, the action will try to start a new process with root privileges. The user will have to enter the password of an admin account.")));
        this.addPropertyDescriptor(CategoryUtil.categoryMacos(Install4JPropertyDescriptor.create((String)"failIfNotObtainedMac", (Class)this.getBeanClass(), (String)"Show failure if requested privileges cannot be obtained", (String)"If selected and the privileges required above could not be obtained a failure message will be shown and the installation will be canceled. This property overrides the \"Failure strategy\" property of the action. A separate property is necessary since the behavior can be configured differently for Windows, macOS and Unix.")));
        this.addPropertyDescriptor(CategoryUtil.categoryLinux(Install4JPropertyDescriptor.create((String)LINUX_PRIVILEGE_REQUIREMENT, (Class)this.getBeanClass(), (String)"Linux privilege requirement", (String)"If set to \"Root\" the installer must be started as root, otherwise a failure message will be shown, and the installation will be canceled. This property overrides the \"Failure strategy\" property of the action. A separate property is necessary since the behavior can be configured differently for Windows, macOS and Unix.<p>If set to \"Try to obtain privileges\" the installer will start a helper process with pkexec in GUI mode and with sudo or su in console mode.</p>")));
        this.addPropertyDescriptor(Install4JPropertyDescriptor.create((String)"failIfNotObtainedLinux", (Class)this.getBeanClass(), (String)"Show failure if requested privileges cannot be obtained", (String)"If selected and the privileges required above could not be obtained a failure message will be shown and the installation will be canceled. This property overrides the \"Failure strategy\" property of the action. A separate property is necessary since the behavior can be configured differently for Windows, macOS and Unix.").setParentProperty(LINUX_PRIVILEGE_REQUIREMENT).setVisibilityDiscriminator((bean, object) -> object == PrivilegeRequirement.OBTAIN));
        this.addPropertyDescriptor(CategoryUtil.categoryUnix(Install4JPropertyDescriptor.create((String)"failIfNotRootUnix", (Class)this.getBeanClass(), (String)"Show failure if current user is not root", (String)"If selected and the current user is not root a failure message will be shown and the installation will be canceled. This property overrides the \"Failure strategy\" property of the action. A separate property is necessary since the behavior can be configured differently for Windows, macOS and Unix.")));
        this.setUninstallerStartupAction(RequireInstallerPrivilegesAction.class.getName());
    }
}

