/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures.constants;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gjt.jclasslib.io.DataInput;
import org.gjt.jclasslib.io.DataOutput;
import org.gjt.jclasslib.structures.AbstractConstant;
import org.gjt.jclasslib.structures.ClassFile;
import org.gjt.jclasslib.structures.ConstantType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0096\u0002J\b\u0010#\u001a\u00020$H\u0016J\u0014\u0010%\u001a\u00020$*\u00020\u001c2\u0006\u0010&\u001a\u00020\u0007H\u0002J\f\u0010'\u001a\u00020\u0007*\u00020\u0019H\u0002R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\tR\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u001d\u001a\u00020\u00078TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\t\u00a8\u0006("}, d2={"Lorg/gjt/jclasslib/structures/constants/ConstantUtf8Info;", "Lorg/gjt/jclasslib/structures/AbstractConstant;", "classFile", "Lorg/gjt/jclasslib/structures/ClassFile;", "<init>", "(Lorg/gjt/jclasslib/structures/ClassFile;)V", "string", "", "getString", "()Ljava/lang/String;", "setString", "(Ljava/lang/String;)V", "constantType", "Lorg/gjt/jclasslib/structures/ConstantType;", "getConstantType", "()Lorg/gjt/jclasslib/structures/ConstantType;", "verbose", "getVerbose", "bytes", "", "getBytes", "()[B", "readData", "", "input", "Lorg/gjt/jclasslib/io/DataInput;", "writeData", "output", "Lorg/gjt/jclasslib/io/DataOutput;", "debugInfo", "getDebugInfo", "equals", "", "other", "", "hashCode", "", "writeUTF", "str", "readUTF", "data"})
public final class ConstantUtf8Info
extends AbstractConstant {
    @NotNull
    private String string;

    public ConstantUtf8Info(@NotNull ClassFile classFile) {
        Intrinsics.checkNotNullParameter((Object)classFile, (String)"classFile");
        super(classFile);
        this.string = "";
    }

    @NotNull
    public final String getString() {
        return this.string;
    }

    public final void setString(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.string = string;
    }

    @Override
    @NotNull
    public ConstantType getConstantType() {
        return ConstantType.UTF8;
    }

    @Override
    @NotNull
    public String getVerbose() {
        return this.string;
    }

    @NotNull
    public final byte[] getBytes() {
        return StringsKt.encodeToByteArray((String)this.string);
    }

    @Override
    protected void readData(@NotNull DataInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.string = this.readUTF(input);
    }

    @Override
    protected void writeData(@NotNull DataOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        output.writeByte(ConstantType.UTF8.getTag());
        this.writeUTF(output, this.string);
    }

    @Override
    @NotNull
    protected String getDebugInfo() {
        return "with length " + this.string.length() + " (\"" + this.string + "\")";
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (!(other instanceof ConstantUtf8Info)) {
            return false;
        }
        return super.equals(other) && Intrinsics.areEqual((Object)((ConstantUtf8Info)other).string, (Object)this.string);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.string.hashCode();
    }

    private final int writeUTF(DataOutput $this$writeUTF, String str) {
        char c;
        int i;
        int strlen;
        int utfLen = strlen = str.length();
        for (int i2 = 0; i2 < strlen; ++i2) {
            char c2 = str.charAt(i2);
            if (c2 < '\u0080' && c2 != '\u0000') continue;
            utfLen += c2 >= '\u0800' ? 2 : 1;
        }
        if (utfLen > 65535 || utfLen < strlen) {
            throw new IllegalStateException("String too long: " + utfLen + " chars");
        }
        byte[] bytes = new byte[utfLen + 2];
        int count = 0;
        bytes[count++] = (byte)(utfLen >>> 8 & 0xFF);
        bytes[count++] = (byte)(utfLen & 0xFF);
        for (i = 0; i < strlen && (c = str.charAt(i)) < '\u0080' && c != '\u0000'; ++i) {
            bytes[count++] = (byte)c;
        }
        while (i < strlen) {
            c = str.charAt(i);
            if (c < '\u0080' && c != '\u0000') {
                bytes[count++] = (byte)c;
            } else if (c >= '\u0800') {
                bytes[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytes[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytes[count++] = (byte)(0x80 | c & 0x3F);
            } else {
                bytes[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
                bytes[count++] = (byte)(0x80 | c & 0x3F);
            }
            ++i;
        }
        $this$writeUTF.write(bytes);
        return utfLen + 2;
    }

    private final String readUTF(DataInput $this$readUTF) {
        int c;
        int count;
        int utfLen = $this$readUTF.readUnsignedShort();
        char[] chars = new char[utfLen];
        byte[] bytes = $this$readUTF.readByteArray(utfLen);
        int charCount = 0;
        for (count = 0; count < utfLen && (c = bytes[count] & 0xFF) <= 127; ++count) {
            chars[charCount++] = (char)c;
        }
        while (count < utfLen) {
            byte char2;
            c = bytes[count] & 0xFF;
            int n = c >> 4;
            boolean bl = 0 <= n ? n < 8 : false;
            if (bl) {
                ++count;
                chars[charCount++] = (char)c;
                continue;
            }
            if (n == 12 || n == 13) {
                if ((count += 2) > utfLen) {
                    throw new IllegalStateException("malformed input: partial character at end");
                }
                char2 = bytes[count - 1];
                if ((char2 & 0xC0) != 128) {
                    throw new IllegalStateException("malformed input around byte " + count);
                }
                chars[charCount++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                continue;
            }
            if (n == 14) {
                if ((count += 3) > utfLen) {
                    throw new IllegalStateException("malformed input: partial character at end");
                }
                char2 = bytes[count - 2];
                byte char3 = bytes[count - 1];
                if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                    throw new IllegalStateException("malformed input around byte " + (count - 1));
                }
                chars[charCount++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F);
                continue;
            }
            throw new IllegalStateException("malformed input around byte " + count);
        }
        return StringsKt.concatToString((char[])chars, (int)0, (int)charCount);
    }
}

