/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.screens.components;

import com.install4j.api.SystemInfo;
import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.events.InstallerVariableEvent;
import com.install4j.api.formcomponents.FormEnvironment;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.formcomponents.InstallationDirectoryChooserComponent;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.components.DirectorySelector;
import com.install4j.runtime.installer.frontend.components.FileValidator;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.content.ContentInstaller;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.MissingResourceException;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class InstallationDirectorySelector
implements DirectorySelector.InternalValidator,
FileValidator {
    private InstallationDirectoryChooserComponent component;
    private JLabel lblSpace;
    private JLabel lblFreeSpace;
    private DirectorySelector directorySelector;
    private boolean initialized;
    private Context context;
    private FormEnvironment formEnvironment;
    private boolean designTime;

    public InstallationDirectorySelector(InstallationDirectoryChooserComponent component) {
        this.component = component;
    }

    public void setDesignTime(boolean designTime) {
        this.designTime = designTime;
    }

    public void update() {
        this.init();
        if (this.lblSpace != null) {
            long minSize = this.designTime ? 0L : (long)((double)ContentInstaller.getInstance().getMinSize() * 1.1);
            String spaceText = this.getSizeText(minSize);
            this.lblSpace.setText(spaceText);
        }
        if (this.lblFreeSpace != null) {
            long freeSize = this.designTime ? 0L : SystemInfo.getFreeDiskSpace(this.directorySelector.getSelectedFile());
            String freeSpaceText = this.getSizeText(freeSize);
            this.lblFreeSpace.setText(freeSpaceText);
        }
    }

    private String getSizeText(long bytes) {
        if (bytes > 0x280000000L) {
            return Messages.format(this.getMessage(".ComponentSize3"), this.getGB(bytes));
        }
        return Messages.format(this.getMessage(".ComponentSize2"), this.getMB(bytes));
    }

    private void init() {
        if (!this.initialized && !this.designTime) {
            String standardDirectoryName;
            File initialParentFile;
            File defaultDirectory = this.context.getInstallationDirectory();
            InstallerConfig config = InstallerConfig.getCurrentInstance();
            if (!(!this.component.isSuggestAppDir() || config.isAddOnInstaller() || Util.isMacosInstaller() && config.getMacSpecificConfig().isSingleBundle())) {
                initialParentFile = defaultDirectory.getParentFile();
                standardDirectoryName = defaultDirectory.getName();
            } else {
                initialParentFile = defaultDirectory;
                standardDirectoryName = null;
            }
            if (initialParentFile == null) {
                initialParentFile = defaultDirectory;
                standardDirectoryName = config.getApplicationName();
            }
            this.directorySelector.initDirectory(initialParentFile, standardDirectoryName);
            this.directorySelector.setNoStandardDirectoryNameForUpdate(true);
            this.directorySelector.setAllowSpacesOnUnix(this.component.isAllowSpacesOnUnix());
            this.directorySelector.setManualEntryAllowed(this.component.isManualEntryAllowed());
            this.directorySelector.setStandardValidation(this.component.isStandardValidation());
            this.initialized = true;
        }
    }

    private void setupControls() {
        this.ensureDirectorySelectorCreated();
        this.directorySelector.activateNextScreenOnEnter(this.context.getWizardContext());
        this.directorySelector.addPropertyChangeListener("selectedPath", event -> this.update());
    }

    private void ensureDirectorySelectorCreated() {
        if (this.directorySelector == null) {
            this.directorySelector = new DirectorySelector(this.component.isCompact() ? null : this.getMessage(".ReadyMemoDir").replace(':', ' ').trim(), this.formEnvironment.getWidgetStyleHandler(), this.designTime);
            this.directorySelector.setInternalValidator(this);
            this.directorySelector.setValidator(this);
        }
    }

    public JComponent createComponent() {
        this.setupControls();
        JPanel panel = new JPanel(new GridBagLayout()){

            @Override
            public int getBaseline(int width, int height) {
                return InstallationDirectorySelector.this.directorySelector.getBaseline(width, height);
            }
        };
        panel.setOpaque(false);
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridy = 0;
        gc.gridx = 0;
        if (this.component.isShowRequiredDiskSpace() || this.component.isShowFreeDiskSpace()) {
            gc.insets.bottom = 5;
        }
        gc.anchor = 21;
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.gridwidth = 3;
        panel.add((Component)this.directorySelector, gc);
        ++gc.gridy;
        gc.gridwidth = 1;
        gc.weightx = 0.0;
        if (this.component.isShowRequiredDiskSpace()) {
            this.lblSpace = this.addLabel(".RequiredDiskSpaceLabel", panel, gc);
        }
        if (this.component.isShowFreeDiskSpace() && (Util.isWindows() || Util.isMacOS() || Util.isLinux())) {
            this.lblFreeSpace = this.addLabel(".FreeDiskSpaceLabel", panel, gc);
        }
        this.update();
        return panel;
    }

    private JLabel addLabel(String messageKey, JPanel panel, GridBagConstraints gc) {
        JLabel valueLabel = this.createStyledLabel("");
        gc.insets.right = 5;
        panel.add((Component)this.createStyledLabel(this.getMessage(messageKey)), gc);
        gc.insets.right = 0;
        gc.gridx = 1;
        gc.weightx = 0.0;
        gc.fill = 0;
        gc.anchor = 22;
        panel.add((Component)valueLabel, gc);
        gc.anchor = 21;
        gc.fill = 2;
        ++gc.gridy;
        gc.gridx = 0;
        gc.weightx = 0.0;
        return valueLabel;
    }

    private JLabel createStyledLabel(String text) {
        return this.formEnvironment.getWidgetStyleHandler().applyWidgetStyle(new JLabel(text));
    }

    private String getMB(long sizeBytes) {
        return this.getFormattedSize(sizeBytes, 0x100000L);
    }

    private String getGB(long sizeBytes) {
        return this.getFormattedSize(sizeBytes, 0x40000000L);
    }

    private String getFormattedSize(double sizeBytes, long factor) {
        double size = sizeBytes / (double)factor;
        if (size < 0.0) {
            size = 0.0;
        }
        DecimalFormat decimalFormat = size < 10.0 ? new DecimalFormat("#,###,##0.0") : new DecimalFormat("#,###,##0");
        return decimalFormat.format(size);
    }

    private String getMessage(String key) throws MissingResourceException {
        return Messages.getString(key);
    }

    public void setContext(Context context) {
        this.context = context;
        context.addInstallerEventListener(event -> {
            if (!this.context.isConsole() && !this.context.isUnattended() && event instanceof InstallerVariableEvent && Objects.equals(((InstallerVariableEvent)event).getVariableName(), "sys.installationDir")) {
                this.init();
                this.directorySelector.setDirectory(this.context.getInstallationDirectory());
            }
        });
    }

    public void setFormEnvironment(FormEnvironment formEnvironment) {
        this.formEnvironment = formEnvironment;
    }

    @Override
    public File validateInternally(File dir) {
        return ContentInstaller.validateInstallationDir(dir, this.component.isValidateApplicationId(), this.component.isCheckFreeSpace(), this.component.isExistingDirWarning(), this.context.isUnattended(), false);
    }

    @Override
    public boolean isValidFile(File file) {
        if (this.component.getValidationScript() != null) {
            Object[] arguments = this.formEnvironment != null ? new Object[]{file, this.formEnvironment} : new Object[]{file};
            return ContextImpl.getContextInt(this.context).runBooleanScript(this.component.getValidationScript().getValue(), this.component, arguments);
        }
        return true;
    }

    private File getSelectedDir() {
        this.init();
        return this.directorySelector.getSelectedFile();
    }

    public boolean handleUnattended() {
        File selectedDir = this.validateInternally(this.context.getInstallationDirectory());
        if (selectedDir == null || !this.checkWritableIfConfigured(selectedDir)) {
            Util.showMessage(Messages.getString(".DestinationDirHelp"), 1);
            return false;
        }
        if (!Boolean.getBoolean("install4j.extraSilent") && !InstallerUtil.isUnattendedAlerts()) {
            Util.showMessage(Messages.format(Messages.getString(".UnattendedInstallationDir"), selectedDir), 1);
        }
        if (this.context instanceof InstallerContext) {
            ((InstallerContext)this.context).setInstallationDirectory(selectedDir);
        }
        return true;
    }

    public boolean handleConsole(Console console) throws UserCanceledException {
        this.ensureDirectorySelectorCreated();
        this.init();
        while (true) {
            String defaultDirectory = this.context.getInstallationDirectory().getAbsolutePath();
            String answer = console.askString(Messages.format(this.getMessage(".SelectDirDesc"), InstallerConfig.getCurrentInstance().getApplicationName()), defaultDirectory);
            try {
                File selectedDir = new File(answer).getCanonicalFile();
                this.directorySelector.setSelectedFile(selectedDir);
                if (!new File(answer).isAbsolute() || selectedDir.exists() && !selectedDir.isDirectory()) {
                    console.println(Messages.format(this.getMessage(".InvalidDirectory"), answer));
                    continue;
                }
                if (!this.directorySelector.checkSelectedFile() || (selectedDir = this.directorySelector.getSelectedFile()) == null || !this.checkWritableIfConfigured(selectedDir)) continue;
                if (this.context instanceof InstallerContext) {
                    ((InstallerContext)this.context).setInstallationDirectory(selectedDir);
                }
                return true;
            }
            catch (IOException e) {
                console.println(Messages.format(this.getMessage(".InvalidDirectory"), answer));
                continue;
            }
            break;
        }
    }

    public DirectorySelector getDirectorySelector() {
        return this.directorySelector;
    }

    public void focusTextField() {
        this.directorySelector.focusTextField();
    }

    public boolean checkCompleted() {
        if (this.directorySelector.checkSelectedFile()) {
            File destDir = this.getSelectedDir();
            if (this.context instanceof InstallerContext) {
                ((InstallerContext)this.context).setInstallationDirectory(destDir);
            }
            return this.checkWritableIfConfigured(destDir);
        }
        return false;
    }

    private boolean checkWritableIfConfigured(File destDir) {
        return !this.component.isCheckWritable() || this.component.isNoWritableCheckIfInstallingForAllUsers() && InstallerVariables.getBooleanVariable("sys.installForAllUsers") || InstallerUtil.checkWritableInstallationDirectory(destDir, true);
    }
}

