/*
 * Decompiled with CFR 0.152.
 */
package com.install4j;

import com.install4j.buildtools.BaseTaskConfig;
import com.install4j.buildtools.BuildToolHelper;
import com.install4j.buildtools.InstallationProvisioner;
import com.install4j.buildtools.InvalidConfigException;
import com.install4j.buildtools.shadowed.ejt.util.LoadingDescriptor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.jetbrains.annotations.Nullable;

public abstract class BaseTask
extends Task {
    public static final boolean TEST_TASK = Boolean.getBoolean("install4j.testBuildToolTask");
    private File installDir;
    private File autoProvisioningCacheDir;
    private List<VmParameter> vmParameters = new ArrayList<VmParameter>();

    protected abstract String getApplicationName();

    public void init() throws BuildException {
        super.init();
        File baseDir = LoadingDescriptor.getInstance(((Object)((Object)this)).getClass()).getBaseDir();
        if (baseDir == null) {
            throw new BuildException("Cannot find " + this.getApplicationName() + " installation directory");
        }
        try {
            File antJarParentDir = new File(baseDir, "..").getCanonicalFile();
            File executableFile = BuildToolHelper.getInstall4jExecutableFile(antJarParentDir, this.getCompilerExecutableName());
            if (executableFile.exists()) {
                this.installDir = antJarParentDir;
            } else {
                this.preconfiguredExecutableFileNotFound(executableFile);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getCompilerExecutableName() {
        return "install4jc";
    }

    protected void preconfiguredExecutableFileNotFound(File executableFile) throws IOException {
    }

    public void setAutoProvisioningCacheDir(File autoProvisioningCacheDir) {
        this.autoProvisioningCacheDir = autoProvisioningCacheDir;
    }

    protected File getAutoProvisioningCacheDir() {
        return this.autoProvisioningCacheDir;
    }

    public void addConfiguredVmParameter(VmParameter vmParameter) {
        this.vmParameters.add(vmParameter);
    }

    protected List<String> getVmParameters() {
        ArrayList<String> strings = new ArrayList<String>();
        for (VmParameter vmParameter : this.vmParameters) {
            String value = vmParameter.value;
            if (value == null || value.isEmpty()) continue;
            strings.add(value);
        }
        return strings;
    }

    @Nullable
    protected File getInstallDir() {
        return this.installDir;
    }

    protected void runExecutable(final BaseTaskConfig config) throws BuildException {
        try {
            List<String> commandLine = config.createCommandLine(new InstallationProvisioner(){

                @Override
                protected File getCacheDirectory() {
                    File install4jDistDir = config.getAutoProvisioningCacheDir();
                    if (install4jDistDir != null) {
                        return install4jDistDir;
                    }
                    return BuildToolHelper.getDefaultAutoProvisioningCacheDir();
                }

                @Override
                protected void log(String message) {
                    BaseTask.this.log(message, 2);
                }

                @Override
                protected void logVerbose(String message) {
                    BaseTask.this.log(message, 3);
                }
            });
            if (TEST_TASK) {
                System.out.print("Command:");
                for (String line : commandLine) {
                    System.out.print(' ');
                    System.out.print(line);
                }
                System.out.println();
                String extraLoggingOutput = config.getExtraLoggingOutput();
                if (extraLoggingOutput != null) {
                    System.out.println(extraLoggingOutput);
                }
            }
            Execute.runCommand((Task)this, (String[])commandLine.toArray(new String[0]));
        }
        catch (InvalidConfigException e) {
            throw new BuildException((Throwable)e);
        }
    }

    protected List<String> split(@Nullable String string, String delimiter) {
        if (string == null) {
            return null;
        }
        return Arrays.asList(string.split(Pattern.quote(delimiter)));
    }

    public static class VmParameter {
        private String value;

        public void setValue(String value) {
            this.value = value;
        }
    }
}

